/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import com.auth0.jwt.exceptions.IncorrectClaimException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.security.JwtAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "authenticationEntryPoint", "Lorg/springframework/security/web/AuthenticationEntryPoint;", "(Lorg/springframework/security/authentication/AuthenticationManager;Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;Lorg/springframework/security/web/AuthenticationEntryPoint;)V", "securityContextHolderStrategy", "Lorg/springframework/security/core/context/SecurityContextHolderStrategy;", "kotlin.jvm.PlatformType", "securityContextRepository", "Lorg/springframework/security/web/context/SecurityContextRepository;", "authenticate", "", "jwt", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "doFilterInternal", "filterChain", "Ljakarta/servlet/FilterChain;", "getJwtString", "header", "cookie", "Ljakarta/servlet/http/Cookie;", "Companion", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseJwtFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseJwtFilter.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class SupabaseJwtFilter
extends OncePerRequestFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final SecurityContextHolderStrategy securityContextHolderStrategy;
    @NotNull
    private final SecurityContextRepository securityContextRepository;

    public SupabaseJwtFilter(@NotNull AuthenticationManager authenticationManager, @NotNull SupabaseProperties supabaseProperties, @NotNull AuthenticationEntryPoint authenticationEntryPoint) {
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Intrinsics.checkNotNullParameter((Object)authenticationEntryPoint, (String)"authenticationEntryPoint");
        this.authenticationManager = authenticationManager;
        this.supabaseProperties = supabaseProperties;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        this.securityContextRepository = (SecurityContextRepository)new RequestAttributeSecurityContextRepository();
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain2) {
        block8: {
            String jwtString;
            Cookie cookie;
            block7: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter((Object)filterChain2, (String)"filterChain");
                Cookie[] cookieArray = request.getCookies();
                if (cookieArray != null) {
                    Cookie[] cookieArray2 = cookieArray;
                    int n = cookieArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Cookie cookie2;
                        Cookie it = cookie2 = cookieArray2[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                        cookie = cookie2;
                        break block7;
                    }
                    cookie = null;
                } else {
                    cookie = null;
                }
            }
            Cookie cookie3 = cookie;
            String header = request.getHeader("HX-Current-URL");
            String string = jwtString = this.getJwtString(header, cookie3);
            if (string != null) {
                String jwt = string;
                boolean bl = false;
                try {
                    this.authenticate(jwt, request, response);
                }
                catch (TokenExpiredException e) {
                    Companion.setJWTCookie(response, jwtString, this.supabaseProperties, 0);
                }
                catch (IncorrectClaimException e) {
                    String string2 = e.getMessage();
                    boolean bl2 = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"The Token can't be used before", (boolean)false, (int)2, null) : false;
                    if (!bl2) break block8;
                    this.logger.debug((Object)e.getMessage());
                    Thread.sleep(1000L);
                    this.authenticate(jwt, request, response);
                }
            }
        }
        filterChain2.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private final void authenticate(String jwt, HttpServletRequest request, HttpServletResponse response) {
        Authentication authResult = this.authenticationManager.authenticate((Authentication)new JwtAuthenticationToken(jwt));
        SecurityContext securityContext = this.securityContextHolderStrategy.createEmptyContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"createEmptyContext(...)");
        SecurityContext context = securityContext;
        context.setAuthentication(authResult);
        de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtFilter$Companion.setJWTCookie$default(Companion, response, jwt, this.supabaseProperties, 0, 4, null);
        this.securityContextRepository.saveContext(context, request, response);
    }

    private final String getJwtString(String header, Cookie cookie) {
        String string;
        String string2 = header;
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"#access_token=", (boolean)false, (int)2, null) : false;
        if (bl) {
            string = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)header, (String)"&", null, (int)2, null), (String)"#access_token=", null, (int)2, null);
        } else {
            Cookie cookie2 = cookie;
            string = cookie2 != null ? cookie2.getValue() : null;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter$Companion;", "", "()V", "setJWTCookie", "", "Ljakarta/servlet/http/HttpServletResponse;", "accessToken", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "maxAge", "", "htmx-supabase-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void setJWTCookie(@NotNull HttpServletResponse $this$setJWTCookie, @NotNull String accessToken, @NotNull SupabaseProperties supabaseProperties, int maxAge) {
            void it;
            Cookie cookie;
            Intrinsics.checkNotNullParameter((Object)$this$setJWTCookie, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
            Cookie cookie2 = cookie = new Cookie("JWT", accessToken);
            HttpServletResponse httpServletResponse = $this$setJWTCookie;
            boolean bl = false;
            it.setSecure(supabaseProperties.getSslOnly());
            it.setHttpOnly(true);
            it.setPath("/");
            it.setMaxAge(maxAge);
            httpServletResponse.addCookie(cookie);
        }

        public static /* synthetic */ void setJWTCookie$default(Companion companion, HttpServletResponse httpServletResponse, String string, SupabaseProperties supabaseProperties, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 6000;
            }
            companion.setJWTCookie(httpServletResponse, string, supabaseProperties, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

