/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import com.auth0.jwt.JWTVerifier;
import de.tschuehly.htmx.spring.supabase.auth.exception.UnknownSupabaseException;
import de.tschuehly.htmx.spring.supabase.auth.security.JwtAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.types.SupabaseUser;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "jwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "(Lcom/auth0/jwt/JWTVerifier;)V", "authenticate", "Lorg/springframework/security/core/Authentication;", "token", "supports", "", "authentication", "Ljava/lang/Class;", "htmx-supabase-spring-boot-starter"})
public final class SupabaseAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final JWTVerifier jwtVerifier;

    public SupabaseAuthenticationProvider(@NotNull JWTVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        this.jwtVerifier = jwtVerifier;
    }

    @NotNull
    public Authentication authenticate(@NotNull Authentication token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        boolean cfr_ignored_0 = token instanceof JwtAuthenticationToken;
        if (!(token instanceof JwtAuthenticationToken)) {
            throw new UnknownSupabaseException("Something went wrong when trying to authenticate with the jwt");
        }
        Map claims = this.jwtVerifier.verify(((JwtAuthenticationToken)token).getJwtString()).getClaims();
        Intrinsics.checkNotNull((Object)claims);
        return (Authentication)SupabaseAuthenticationToken.Companion.authenticated(new SupabaseUser(claims));
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return Intrinsics.areEqual(authentication, JwtAuthenticationToken.class);
    }
}

