/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import de.tschuehly.htmx.spring.supabase.auth.SupabaseAutoConfiguration;
import de.tschuehly.htmx.spring.supabase.auth.config.DefaultExceptionHandlerConfig;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.controller.SupabaseUserController;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseSecurityConfig;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserServiceGoTrueImpl;
import io.github.jan.supabase.SupabaseClient;
import io.github.jan.supabase.SupabaseClientBuilder;
import io.github.jan.supabase.gotrue.Auth;
import io.github.jan.supabase.gotrue.AuthKt;
import io.github.jan.supabase.plugins.SupabasePluginProvider;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="supabase", name={"projectId"})
@EnableConfigurationProperties(value={SupabaseProperties.class})
@Import(value={SupabaseSecurityConfig.class, DefaultExceptionHandlerConfig.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseProperties", "()Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "dataSource", "Ljavax/sql/DataSource;", "supabaseClient", "Lio/github/jan/supabase/gotrue/Auth;", "supabaseController", "Lde/tschuehly/htmx/spring/supabase/auth/controller/SupabaseUserController;", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "supabaseJwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "supabaseService", "goTrueClient", "supabaseAuthenticationProvider", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n+ 2 SupabaseClientBuilder.kt\nio/github/jan/supabase/SupabaseClientBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n114#2:96\n1#3:97\n*S KotlinDebug\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n*L\n60#1:96\n*E\n"})
public class SupabaseAutoConfiguration {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseAutoConfiguration(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserService supabaseService(@NotNull Auth goTrueClient, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider) {
        Intrinsics.checkNotNullParameter((Object)goTrueClient, (String)"goTrueClient");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        this.getLogger().debug("Registering the SupabaseUserService");
        return new SupabaseUserServiceGoTrueImpl(this.getSupabaseProperties(), goTrueClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserController supabaseController(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.getLogger().debug("Registering the SupabaseUserController");
        return new SupabaseUserController(supabaseUserService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Auth supabaseClient(@NotNull SupabaseProperties supabaseProperties) {
        void supabaseKey$iv;
        void supabaseUrl$iv;
        SupabaseClientBuilder supabaseClientBuilder;
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Object object = supabaseProperties.getUrl();
        if (object == null) {
            object = "https://" + supabaseProperties.getProjectId() + ".supabase.co";
        }
        String string = object;
        String string2 = supabaseProperties.getAnonKey();
        boolean $i$f$createSupabaseClient = false;
        SupabaseClientBuilder $this$supabaseClient_u24lambda_u240 = supabaseClientBuilder = new SupabaseClientBuilder((String)supabaseUrl$iv, (String)supabaseKey$iv);
        boolean bl = false;
        $this$supabaseClient_u24lambda_u240.install((SupabasePluginProvider)Auth.Companion, (Function1)supabaseClient.supabase.1.1.INSTANCE);
        SupabaseClient supabase2 = supabaseClientBuilder.build();
        return AuthKt.getAuth((SupabaseClient)supabase2);
    }

    @Bean
    @NotNull
    public JWTVerifier supabaseJwtVerifier(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        JWTVerifier jWTVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)supabaseProperties.getJwtSecret())).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTVerifier, (String)"build(...)");
        return jWTVerifier;
    }

    @Bean
    @ConditionalOnProperty(prefix="supabase.database", name={"host"})
    @NotNull
    public DataSource dataSource(@NotNull SupabaseProperties supabaseProperties) {
        DataSourceBuilder dataSourceBuilder;
        block2: {
            SupabaseProperties.Database db;
            block4: {
                Object it;
                String string;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
                    dataSourceBuilder = DataSourceBuilder.create();
                    dataSourceBuilder.driverClassName("org.postgresql.Driver");
                    SupabaseProperties.Database database = supabaseProperties.getDatabase();
                    if (database == null) break block2;
                    db = database;
                    boolean bl = false;
                    dataSourceBuilder.url("jdbc:postgresql://" + db.getHost() + ":" + db.getPort() + "/" + db.getName());
                    string = db.getUsername();
                    if (string == null) break block3;
                    it = string;
                    boolean bl2 = false;
                    DataSourceBuilder dataSourceBuilder2 = dataSourceBuilder.username((String)it);
                    string = dataSourceBuilder2;
                    if (dataSourceBuilder2 != null) break block4;
                }
                it = this;
                boolean bl = false;
                string = dataSourceBuilder.username("postgres." + supabaseProperties.getProjectId());
            }
            dataSourceBuilder.password(db.getPassword());
        }
        DataSource dataSource = dataSourceBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"build(...)");
        return dataSource;
    }
}

