/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.types;

import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006BO\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J_\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser;", "", "claimsMap", "", "", "Lcom/auth0/jwt/interfaces/Claim;", "(Ljava/util/Map;)V", "id", "Ljava/util/UUID;", "email", "phone", "userMetadata", "", "roles", "", "provider", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/lang/String;)V", "getEmail", "()Ljava/lang/String;", "getId", "()Ljava/util/UUID;", "getPhone", "getProvider", "getRoles", "()Ljava/util/List;", "getUserMetadata", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "getAuthorities", "", "Lorg/springframework/security/core/GrantedAuthority;", "hashCode", "", "toString", "Companion", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseUser.kt\nde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n37#3,2:63\n*S KotlinDebug\n*F\n+ 1 SupabaseUser.kt\nde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser\n*L\n39#1:59\n39#1:60,3\n39#1:63,2\n*E\n"})
public final class SupabaseUser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final UUID id;
    @Nullable
    private final String email;
    @Nullable
    private final String phone;
    @NotNull
    private final Map<String, String> userMetadata;
    @NotNull
    private final List<String> roles;
    @Nullable
    private final String provider;
    @NotNull
    private static final ObjectMapper mapper;

    public SupabaseUser(@Nullable UUID id, @Nullable String email, @Nullable String phone, @NotNull Map<String, String> userMetadata, @NotNull List<String> roles, @Nullable String provider) {
        Intrinsics.checkNotNullParameter(userMetadata, (String)"userMetadata");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        this.id = id;
        this.email = email;
        this.phone = phone;
        this.userMetadata = userMetadata;
        this.roles = roles;
        this.provider = provider;
    }

    @Nullable
    public final UUID getId() {
        return this.id;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @Nullable
    public final String getPhone() {
        return this.phone;
    }

    @NotNull
    public final Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    @Nullable
    public final String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<GrantedAuthority> getAuthorities() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.roles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add("ROLE_" + string2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] roleList = thisCollection$iv.toArray(new String[0]);
        return AuthorityUtils.createAuthorityList((String[])Arrays.copyOf(roleList, roleList.length));
    }

    /*
     * WARNING - void declaration
     */
    public SupabaseUser(@NotNull Map<String, ? extends Claim> claimsMap) {
        Map map;
        UUID uUID;
        SupabaseUser supabaseUser;
        Intrinsics.checkNotNullParameter(claimsMap, (String)"claimsMap");
        SupabaseUser supabaseUser2 = this;
        Claim claim = claimsMap.get("sub");
        if (claim != null) {
            void it;
            Claim claim2 = claim;
            supabaseUser = supabaseUser2;
            boolean bl = false;
            uUID = UUID.fromString(it.asString());
            supabaseUser2 = supabaseUser;
        } else {
            uUID = null;
        }
        Claim claim3 = claimsMap.get("email");
        String string = claim3 != null ? claim3.asString() : null;
        Claim claim4 = claimsMap.get("phone");
        String string2 = claim4 != null ? claim4.asString() : null;
        Claim claim5 = claimsMap.get("user_metadata");
        if (claim5 != null) {
            Claim bl = claim5;
            String string3 = string2;
            String string4 = string;
            UUID uUID2 = uUID;
            supabaseUser = supabaseUser2;
            boolean bl2 = false;
            Claim claim6 = claimsMap.get("user_metadata");
            Map map2 = (Map)mapper.readValue(claim6 != null ? claim6.toString() : null, (TypeReference)new TypeReference<Map<String, String>>(){});
            supabaseUser2 = supabaseUser;
            uUID = uUID2;
            string = string4;
            string2 = string3;
            map = map2;
        } else {
            map = null;
        }
        Map map3 = map;
        supabaseUser2(uUID, string, string2, map3 == null ? (Map)new LinkedHashMap() : map3, Companion.getRolesFromAppMetadata(claimsMap), Companion.getProviderFromAppMetadata(claimsMap));
    }

    @Nullable
    public final UUID component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.email;
    }

    @Nullable
    public final String component3() {
        return this.phone;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.userMetadata;
    }

    @NotNull
    public final List<String> component5() {
        return this.roles;
    }

    @Nullable
    public final String component6() {
        return this.provider;
    }

    @NotNull
    public final SupabaseUser copy(@Nullable UUID id, @Nullable String email, @Nullable String phone, @NotNull Map<String, String> userMetadata, @NotNull List<String> roles, @Nullable String provider) {
        Intrinsics.checkNotNullParameter(userMetadata, (String)"userMetadata");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        return new SupabaseUser(id, email, phone, userMetadata, roles, provider);
    }

    public static /* synthetic */ SupabaseUser copy$default(SupabaseUser supabaseUser, UUID uUID, String string, String string2, Map map, List list, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = supabaseUser.id;
        }
        if ((n & 2) != 0) {
            string = supabaseUser.email;
        }
        if ((n & 4) != 0) {
            string2 = supabaseUser.phone;
        }
        if ((n & 8) != 0) {
            map = supabaseUser.userMetadata;
        }
        if ((n & 0x10) != 0) {
            list = supabaseUser.roles;
        }
        if ((n & 0x20) != 0) {
            string3 = supabaseUser.provider;
        }
        return supabaseUser.copy(uUID, string, string2, map, list, string3);
    }

    @NotNull
    public String toString() {
        return "SupabaseUser(id=" + this.id + ", email=" + this.email + ", phone=" + this.phone + ", userMetadata=" + this.userMetadata + ", roles=" + this.roles + ", provider=" + this.provider + ")";
    }

    public int hashCode() {
        int result = this.id == null ? 0 : this.id.hashCode();
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.phone == null ? 0 : this.phone.hashCode());
        result = result * 31 + ((Object)this.userMetadata).hashCode();
        result = result * 31 + ((Object)this.roles).hashCode();
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SupabaseUser)) {
            return false;
        }
        SupabaseUser supabaseUser = (SupabaseUser)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)supabaseUser.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.email, (Object)supabaseUser.email)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.phone, (Object)supabaseUser.phone)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userMetadata, supabaseUser.userMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.roles, supabaseUser.roles)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.provider, (Object)supabaseUser.provider);
    }

    static {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        mapper = objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nJ \u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getProviderFromAppMetadata", "", "claimsMap", "", "Lcom/auth0/jwt/interfaces/Claim;", "getRolesFromAppMetadata", "", "htmx-supabase-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        @NotNull
        public final List<String> getRolesFromAppMetadata(@NotNull Map<String, ? extends Claim> claimsMap) {
            Object roles;
            Intrinsics.checkNotNullParameter(claimsMap, (String)"claimsMap");
            Object object = claimsMap.get("app_metadata");
            Object v1 = object != null && (object = object.asMap()) != null ? object.get("roles") : (roles = null);
            if (roles instanceof List && CollectionsKt.firstOrNull((List)roles) instanceof String) {
                return roles;
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public final String getProviderFromAppMetadata(@NotNull Map<String, ? extends Claim> claimsMap) {
            Intrinsics.checkNotNullParameter(claimsMap, (String)"claimsMap");
            Object object = claimsMap.get("app_metadata");
            String string = String.valueOf(object != null && (object = object.asMap()) != null ? object.get("provider") : null);
            if (string == null) {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

