/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.controller.SupabaseUserController;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtVerifier;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseSecurityConfig;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import io.github.jan.supabase.SupabaseClient;
import io.github.jan.supabase.SupabaseClientBuilder;
import io.github.jan.supabase.auth.Auth;
import io.github.jan.supabase.auth.AuthConfig;
import io.github.jan.supabase.auth.AuthKt;
import io.github.jan.supabase.plugins.SupabasePluginProvider;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={SupabaseProperties.class})
@Import(value={SupabaseSecurityConfig.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0017J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;)V", "getSupabaseProperties", "()Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "supabaseService", "Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "goTrueClient", "Lio/github/jan/supabase/auth/Auth;", "supabaseAuthenticationProvider", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "supabaseController", "Lde/tschuehly/htmx/spring/supabase/auth/controller/SupabaseUserController;", "supabaseUserService", "supabaseClient", "supabaseJwtVerifier", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier;", "dataSource", "Ljavax/sql/DataSource;", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n+ 2 SupabaseClientBuilder.kt\nio/github/jan/supabase/SupabaseClientBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n148#2:104\n1#3:105\n*S KotlinDebug\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n*L\n65#1:104\n*E\n"})
public class SupabaseAutoConfiguration {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseAutoConfiguration(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserService supabaseService(@NotNull Auth goTrueClient, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)goTrueClient, (String)"goTrueClient");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.getLogger().debug("Registering the SupabaseUserService");
        return new SupabaseUserService(this.getSupabaseProperties(), goTrueClient, applicationEventPublisher, supabaseAuthenticationProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserController supabaseController(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.getLogger().debug("Registering the SupabaseUserController");
        return new SupabaseUserController(supabaseUserService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Auth supabaseClient(@NotNull SupabaseProperties supabaseProperties) {
        void supabaseKey$iv;
        void supabaseUrl$iv;
        SupabaseClientBuilder supabaseClientBuilder;
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Object object = supabaseProperties.getUrl();
        if (object == null) {
            object = "https://" + supabaseProperties.getProjectId() + ".supabase.co";
        }
        String string = object;
        String string2 = supabaseProperties.getAnonKey();
        if (string2 == null) {
            throw new IllegalStateException();
        }
        String string3 = string2;
        boolean $i$f$createSupabaseClient = false;
        SupabaseClientBuilder $this$supabaseClient_u24lambda_u241 = supabaseClientBuilder = new SupabaseClientBuilder((String)supabaseUrl$iv, (String)supabaseKey$iv);
        boolean bl = false;
        $this$supabaseClient_u24lambda_u241.install((SupabasePluginProvider)Auth.Companion, SupabaseAutoConfiguration::supabaseClient$lambda$1$lambda$0);
        SupabaseClient supabase = supabaseClientBuilder.build();
        return AuthKt.getAuth((SupabaseClient)supabase);
    }

    @Bean
    @NotNull
    public SupabaseJwtVerifier supabaseJwtVerifier(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        JWTVerifier jwtVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)supabaseProperties.getJwtSecret())).build();
        Intrinsics.checkNotNull((Object)jwtVerifier);
        return new SupabaseJwtVerifier(jwtVerifier);
    }

    @Bean
    @ConfigurationProperties(value="supabase.datasource")
    @ConditionalOnProperty(prefix="supabase.database", name={"host"})
    @NotNull
    public DataSource dataSource(@NotNull SupabaseProperties supabaseProperties) {
        DataSourceBuilder dataSourceBuilder;
        block2: {
            SupabaseProperties.Database db;
            block4: {
                Object it;
                String string;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
                    dataSourceBuilder = DataSourceBuilder.create();
                    dataSourceBuilder.driverClassName("org.postgresql.Driver");
                    SupabaseProperties.Database database = supabaseProperties.getDatabase();
                    if (database == null) break block2;
                    db = database;
                    boolean bl = false;
                    dataSourceBuilder.url("jdbc:postgresql://" + db.getHost() + ":" + db.getPort() + "/" + db.getName());
                    string = db.getUsername();
                    if (string == null) break block3;
                    it = string;
                    boolean bl2 = false;
                    DataSourceBuilder dataSourceBuilder2 = dataSourceBuilder.username((String)it);
                    string = dataSourceBuilder2;
                    if (dataSourceBuilder2 != null) break block4;
                }
                it = this;
                boolean bl = false;
                string = dataSourceBuilder.username("postgres." + supabaseProperties.getProjectId());
            }
            dataSourceBuilder.password(db.getPassword());
        }
        DataSource dataSource = dataSourceBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"build(...)");
        return dataSource;
    }

    private static final Unit supabaseClient$lambda$1$lambda$0(AuthConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setAutoSaveToStorage(false);
        $this$install.setAutoLoadFromStorage(false);
        $this$install.setAlwaysAutoRefresh(false);
        return Unit.INSTANCE;
    }
}

