/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.controller;

import de.tschuehly.htmx.spring.supabase.auth.exception.info.MissingCredentialsException;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"api/user"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J \u0010\u0013\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0017J\b\u0010\u0014\u001a\u00020\rH\u0017J\u0014\u0010\u0015\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017J\u0014\u0010\u0016\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017J\u0014\u0010\u0017\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017J \u0010\u0018\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0017JT\u0010\u001a\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\r0\u001cH\u0012J\b\u0010\u001f\u001a\u00020\rH\u0017J\b\u0010 \u001a\u00020\rH\u0017J$\u0010!\u001a\u00020\r2\u0010\b\u0001\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010#2\b\b\u0001\u0010$\u001a\u00020\u000fH\u0017J\u0012\u0010%\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0012\u0010&\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/controller/SupabaseUserController;", "", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;)V", "getSupabaseUserService", "()Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "login", "", "email", "", "password", "response", "Ljakarta/servlet/http/HttpServletResponse;", "signUp", "anonSignIn", "anonSignInWithEmail", "linkIdentity", "sendEmailOtp", "confirmEmailOtp", "otp", "checkCredentialsAndExecute", "function", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "authorizeWithJwtOrResetPassword", "logout", "setRoles", "roles", "", "userId", "sendPasswordResetEmail", "updatePassword", "htmx-supabase-spring-boot-starter"})
public class SupabaseUserController {
    @NotNull
    private final SupabaseUserService supabaseUserService;
    @NotNull
    private final Logger logger;

    public SupabaseUserController(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.supabaseUserService = supabaseUserService;
        Logger logger = LoggerFactory.getLogger(SupabaseUserController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseUserService getSupabaseUserService() {
        return this.supabaseUserService;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @PostMapping(value={"/login"})
    public void login(@RequestParam @Nullable String email, @RequestParam @Nullable String password, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.checkCredentialsAndExecute(email, password, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> SupabaseUserController.login$lambda$0(this, arg_0, arg_1)));
    }

    @PostMapping(value={"/signup"})
    public void signUp(@RequestParam @Nullable String email, @RequestParam @Nullable String password) {
        this.checkCredentialsAndExecute(email, password, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> SupabaseUserController.signUp$lambda$1(this, arg_0, arg_1)));
    }

    @PostMapping(value={"/loginAnon"})
    public void anonSignIn() {
        this.getSupabaseUserService().signInAnonymously();
    }

    @PostMapping(value={"/loginAnonWithEmail"})
    @ResponseBody
    public void anonSignInWithEmail(@RequestParam @Nullable String email) {
        if (email != null) {
            this.getSupabaseUserService().signInAnonymouslyWithEmail(email);
        } else {
            MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
        }
    }

    @PostMapping(value={"/linkIdentity"})
    public void linkIdentity(@RequestParam @Nullable String email) {
        if (email != null) {
            this.getLogger().debug("User with the email " + email + " is linking an Anonymous User");
            this.getSupabaseUserService().requestEmailChange(email);
        } else {
            MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
        }
    }

    @PostMapping(value={"/signInWithMagicLink"})
    public void sendEmailOtp(@RequestParam @Nullable String email) {
        if (email != null) {
            this.getLogger().debug("User with the email " + email + " is trying to sign in with a Magic Link");
            this.getSupabaseUserService().signInWithMagicLink(email);
        } else {
            MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
        }
    }

    @PostMapping(value={"/confirmEmailOtp"})
    @ResponseBody
    public void confirmEmailOtp(@RequestParam @Nullable String email, @RequestParam @Nullable String otp) {
        CharSequence charSequence = email;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
        }
        if ((charSequence = (CharSequence)otp) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            MissingCredentialsException.Companion.MissingCredentials.OTP_MISSING.throwExc();
        }
        this.getLogger().debug("User with the email " + email + " is confirming an OTP");
        SupabaseUserService supabaseUserService = this.getSupabaseUserService();
        String string = email;
        Intrinsics.checkNotNull((Object)string);
        String string2 = otp;
        Intrinsics.checkNotNull((Object)string2);
        supabaseUserService.confirmEmailOtp(string, string2);
    }

    private void checkCredentialsAndExecute(String email, String password, Function2<? super String, ? super String, Unit> function) {
        CharSequence charSequence = email;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)password) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            MissingCredentialsException.Companion.MissingCredentials.PASSWORD_AND_EMAIL_MISSING.throwExc();
        } else {
            charSequence = email;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
            } else {
                charSequence = password;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    MissingCredentialsException.Companion.MissingCredentials.PASSWORD_MISSING.throwExc();
                } else {
                    function.invoke((Object)((Object)StringsKt.trim((CharSequence)email)).toString(), (Object)((Object)StringsKt.trim((CharSequence)password)).toString());
                }
            }
        }
    }

    @PostMapping(value={"/jwt"})
    @ResponseBody
    public void authorizeWithJwtOrResetPassword() {
        this.getSupabaseUserService().handleClientAuthentication();
    }

    @GetMapping(value={"/logout"})
    @ResponseBody
    public void logout() {
        this.getSupabaseUserService().logout();
    }

    @PutMapping(value={"/setRoles"})
    @ResponseBody
    public void setRoles(@RequestParam @Nullable List<String> roles, @RequestParam @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (Intrinsics.areEqual((Object)userId, (Object)"")) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "UserId required");
        }
        this.getSupabaseUserService().setRolesWithRequest(userId, roles);
    }

    @PostMapping(value={"/sendPasswordResetEmail"})
    @ResponseBody
    public void sendPasswordResetEmail(@RequestParam @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.getLogger().debug("User with the email " + email + " requested a password reset");
        this.getSupabaseUserService().sendPasswordRecoveryEmail(email);
    }

    @PostMapping(value={"/updatePassword"})
    @ResponseBody
    public void updatePassword(@RequestParam @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.getSupabaseUserService().updatePassword(password);
    }

    private static final Unit login$lambda$0(SupabaseUserController this$0, String checkedEmail, String checkedPassword) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)checkedEmail, (String)"checkedEmail");
        Intrinsics.checkNotNullParameter((Object)checkedPassword, (String)"checkedPassword");
        this$0.getLogger().debug("User with the email " + checkedEmail + " is trying to login");
        this$0.getSupabaseUserService().loginWithEmail(checkedEmail, checkedPassword);
        return Unit.INSTANCE;
    }

    private static final Unit signUp$lambda$1(SupabaseUserController this$0, String checkedEmail, String checkedPassword) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)checkedEmail, (String)"checkedEmail");
        Intrinsics.checkNotNullParameter((Object)checkedPassword, (String)"checkedPassword");
        this$0.getLogger().debug("User with the email " + checkedEmail + " is trying to signup");
        this$0.getSupabaseUserService().signUpWithEmail(checkedEmail, checkedPassword);
        return Unit.INSTANCE;
    }
}

