/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.htmx;

import de.tschuehly.htmx.spring.supabase.auth.exception.HxCurrentUrlHeaderNotFound;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxSwapType;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0005\u00a8\u0006!"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/htmx/HtmxUtil;", "", "<init>", "()V", "idSelector", "", "id", "retarget", "", "cssSelector", "getCurrentUrl", "retargetToId", "swap", "hxSwapType", "Lio/github/wimdeblauwe/htmx/spring/boot/mvc/HxSwapType;", "trigger", "event", "setHeader", "headerName", "headerValue", "htmxResponseHeader", "Lio/github/wimdeblauwe/htmx/spring/boot/mvc/HtmxResponseHeader;", "isHtmxRequest", "", "getCookie", "Ljakarta/servlet/http/Cookie;", "name", "getResponse", "Ljakarta/servlet/http/HttpServletResponse;", "getRequest", "Ljakarta/servlet/http/HttpServletRequest;", "redirect", "path", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nHtmxUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmxUtil.kt\nde/tschuehly/htmx/spring/supabase/auth/htmx/HtmxUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class HtmxUtil {
    @NotNull
    public static final HtmxUtil INSTANCE = new HtmxUtil();

    private HtmxUtil() {
    }

    @NotNull
    public final String idSelector(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return "#" + id;
    }

    public final void retarget(@Nullable String cssSelector) {
        this.setHeader(HtmxResponseHeader.HX_RETARGET.getValue(), cssSelector);
    }

    @NotNull
    public final String getCurrentUrl() {
        String string = this.getRequest().getHeader("HX-Current-URL");
        if (string == null) {
            throw new HxCurrentUrlHeaderNotFound();
        }
        return string;
    }

    public final void retargetToId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        HttpServletRequest request = this.getRequest();
        if (request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue()) != null) {
            this.setHeader(HtmxResponseHeader.HX_RETARGET.getValue(), (String)(StringsKt.startsWith$default((String)id, (String)"#", (boolean)false, (int)2, null) ? id : "#" + id));
        }
    }

    public final void swap(@NotNull HxSwapType hxSwapType) {
        Intrinsics.checkNotNullParameter((Object)hxSwapType, (String)"hxSwapType");
        this.setHeader(HtmxResponseHeader.HX_RESWAP.getValue(), hxSwapType.getValue());
    }

    public final void trigger(@Nullable String event) {
        String header = this.getResponse().getHeader(HtmxResponseHeader.HX_TRIGGER.getValue());
        Object[] objectArray = new String[]{header, event};
        this.setHeader(HtmxResponseHeader.HX_TRIGGER.getValue(), CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    public final void setHeader(@Nullable String headerName, @Nullable String headerValue) {
        this.getResponse().setHeader(headerName, headerValue);
    }

    public final void setHeader(@NotNull HtmxResponseHeader htmxResponseHeader, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)htmxResponseHeader, (String)"htmxResponseHeader");
        this.getResponse().setHeader(htmxResponseHeader.getValue(), headerValue);
    }

    public final boolean isHtmxRequest() {
        return Intrinsics.areEqual((Object)this.getRequest().getHeader(HtmxRequestHeader.HX_REQUEST.getValue()), (Object)"true");
    }

    @Nullable
    public final Cookie getCookie(@NotNull String name) {
        Cookie cookie;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Cookie[] cookieArray = this.getRequest().getCookies();
            if (cookieArray != null) {
                Cookie[] cookieArray2 = cookieArray;
                int n = cookieArray2.length;
                for (int i = 0; i < n; ++i) {
                    Cookie cookie2;
                    Cookie it = cookie2 = cookieArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    cookie = cookie2;
                    break block3;
                }
                cookie = null;
            } else {
                cookie = null;
            }
        }
        return cookie;
    }

    @NotNull
    public final HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = requestAttributes instanceof ServletRequestAttributes ? (ServletRequestAttributes)requestAttributes : null;
        if (servletRequestAttributes == null || (servletRequestAttributes = servletRequestAttributes.getResponse()) == null) {
            throw new RuntimeException("No response found in RequestContextHolder");
        }
        return servletRequestAttributes;
    }

    @NotNull
    public final HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = requestAttributes instanceof ServletRequestAttributes ? (ServletRequestAttributes)requestAttributes : null;
        if (servletRequestAttributes == null || (servletRequestAttributes = servletRequestAttributes.getRequest()) == null) {
            throw new RuntimeException("No response found in RequestContextHolder");
        }
        return servletRequestAttributes;
    }

    public final void redirect(@Nullable String path) {
        if (path != null) {
            this.setHeader(HtmxResponseHeader.HX_REDIRECT, path);
            this.setHeader(HtmxResponseHeader.HX_RESWAP, HxSwapType.NONE.getValue());
        }
    }
}

