/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import de.tschuehly.htmx.spring.supabase.auth.exception.UnknownSupabaseException;
import de.tschuehly.htmx.spring.supabase.auth.security.JwtAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtVerifier;
import de.tschuehly.htmx.spring.supabase.auth.types.SupabaseUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "supabaseJwtVerifier", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier;)V", "authenticate", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationToken;", "token", "Lorg/springframework/security/core/Authentication;", "supports", "", "authentication", "Ljava/lang/Class;", "htmx-supabase-spring-boot-starter"})
public final class SupabaseAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final SupabaseJwtVerifier supabaseJwtVerifier;

    public SupabaseAuthenticationProvider(@NotNull SupabaseJwtVerifier supabaseJwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)supabaseJwtVerifier, (String)"supabaseJwtVerifier");
        this.supabaseJwtVerifier = supabaseJwtVerifier;
    }

    @NotNull
    public SupabaseAuthenticationToken authenticate(@NotNull Authentication token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        boolean cfr_ignored_0 = token instanceof JwtAuthenticationToken;
        if (!(token instanceof JwtAuthenticationToken)) {
            throw new UnknownSupabaseException("Something went wrong when trying to authenticate with the jwt");
        }
        SupabaseJwtVerifier.VerificationResult jwt = this.supabaseJwtVerifier.verify(((JwtAuthenticationToken)token).getJwtString());
        return SupabaseAuthenticationToken.Companion.authenticated(SupabaseUser.Companion.createFromJWT(jwt));
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return Intrinsics.areEqual(authentication, JwtAuthenticationToken.class);
    }
}

