/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import com.auth0.jwt.exceptions.IncorrectClaimException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "getJwtString", "", "Companion", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseJwtFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseJwtFilter.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class SupabaseJwtFilter
extends OncePerRequestFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final SupabaseUserService supabaseUserService;

    public SupabaseJwtFilter(@NotNull SupabaseProperties supabaseProperties, @NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.supabaseProperties = supabaseProperties;
        this.supabaseUserService = supabaseUserService;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
            String jwtString = this.getJwtString(request);
            if (jwtString != null) {
                try {
                    this.supabaseUserService.authenticate(jwtString);
                }
                catch (TokenExpiredException e) {
                    Companion.setJWTCookie(response, jwtString, this.supabaseProperties, 0);
                }
                catch (IncorrectClaimException e) {
                    Object object = e.getMessage();
                    String string = object;
                    boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"The Token can't be used before", (boolean)false, (int)2, null) : false;
                    if (!bl) break block4;
                    this.logger.debug((Object)e.getMessage());
                    Thread.sleep(1000L);
                    object = this.supabaseUserService.authenticate(jwtString);
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private final String getJwtString(HttpServletRequest request) {
        String string;
        String header;
        Cookie cookie;
        block5: {
            Cookie[] cookieArray = request.getCookies();
            if (cookieArray != null) {
                Cookie[] cookieArray2 = cookieArray;
                int n = cookieArray2.length;
                for (int i = 0; i < n; ++i) {
                    Cookie cookie2;
                    Cookie it = cookie2 = cookieArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                    cookie = cookie2;
                    break block5;
                }
                cookie = null;
            } else {
                cookie = null;
            }
        }
        Cookie cookie3 = cookie;
        String string2 = header = request.getHeader("HX-Current-URL");
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"#access_token=", (boolean)false, (int)2, null) : false;
        if (bl) {
            string = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)header, (String)"&", null, (int)2, null), (String)"#access_token=", null, (int)2, null);
        } else {
            Cookie cookie4 = cookie3;
            string = cookie4 != null ? cookie4.getValue() : null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter$Companion;", "", "<init>", "()V", "setJWTCookie", "", "Ljakarta/servlet/http/HttpServletResponse;", "accessToken", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "maxAge", "", "htmx-supabase-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void setJWTCookie(@NotNull HttpServletResponse $this$setJWTCookie, @NotNull String accessToken, @NotNull SupabaseProperties supabaseProperties, int maxAge) {
            void it;
            Cookie cookie;
            Intrinsics.checkNotNullParameter((Object)$this$setJWTCookie, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
            Cookie cookie2 = cookie = new Cookie("JWT", accessToken);
            HttpServletResponse httpServletResponse = $this$setJWTCookie;
            boolean bl = false;
            it.setSecure(supabaseProperties.getSslOnly());
            it.setHttpOnly(true);
            if (supabaseProperties.getCookieDomain() != null) {
                it.setDomain(supabaseProperties.getCookieDomain());
            }
            it.setPath("/");
            it.setMaxAge(maxAge);
            httpServletResponse.addCookie(cookie);
        }

        public static /* synthetic */ void setJWTCookie$default(Companion companion, HttpServletResponse httpServletResponse, String string, SupabaseProperties supabaseProperties, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 6000;
            }
            companion.setJWTCookie(httpServletResponse, string, supabaseProperties, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

