/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier;", "", "jwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "<init>", "(Lcom/auth0/jwt/JWTVerifier;)V", "verify", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier$VerificationResult;", "jwt", "", "VerificationResult", "htmx-supabase-spring-boot-starter"})
public final class SupabaseJwtVerifier {
    @NotNull
    private final JWTVerifier jwtVerifier;

    public SupabaseJwtVerifier(@NotNull JWTVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        this.jwtVerifier = jwtVerifier;
    }

    @NotNull
    public final VerificationResult verify(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        DecodedJWT verifiedJwt = this.jwtVerifier.verify(jwt);
        Map map = verifiedJwt.getClaims();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getClaims(...)");
        String string = verifiedJwt.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToken(...)");
        return new VerificationResult(map, string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier$VerificationResult;", "", "claims", "", "", "Lcom/auth0/jwt/interfaces/Claim;", "token", "<init>", "(Ljava/util/Map;Ljava/lang/String;)V", "getClaims", "()Ljava/util/Map;", "getToken", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "htmx-supabase-spring-boot-starter"})
    public static final class VerificationResult {
        @NotNull
        private final Map<String, Claim> claims;
        @NotNull
        private final String token;

        public VerificationResult(@NotNull Map<String, Claim> claims, @NotNull String token) {
            Intrinsics.checkNotNullParameter(claims, (String)"claims");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.claims = claims;
            this.token = token;
        }

        @NotNull
        public final Map<String, Claim> getClaims() {
            return this.claims;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final Map<String, Claim> component1() {
            return this.claims;
        }

        @NotNull
        public final String component2() {
            return this.token;
        }

        @NotNull
        public final VerificationResult copy(@NotNull Map<String, Claim> claims, @NotNull String token) {
            Intrinsics.checkNotNullParameter(claims, (String)"claims");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return new VerificationResult(claims, token);
        }

        public static /* synthetic */ VerificationResult copy$default(VerificationResult verificationResult, Map map, String string, int n, Object object) {
            if ((n & 1) != 0) {
                map = verificationResult.claims;
            }
            if ((n & 2) != 0) {
                string = verificationResult.token;
            }
            return verificationResult.copy(map, string);
        }

        @NotNull
        public String toString() {
            return "VerificationResult(claims=" + this.claims + ", token=" + this.token + ")";
        }

        public int hashCode() {
            int result = ((Object)this.claims).hashCode();
            result = result * 31 + this.token.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerificationResult)) {
                return false;
            }
            VerificationResult verificationResult = (VerificationResult)other;
            if (!Intrinsics.areEqual(this.claims, verificationResult.claims)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.token, (Object)verificationResult.token);
        }
    }
}

