/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAccessDeniedHandler;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationEntryPoint;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtFilter;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtVerifier;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AuthorizeHttpRequestsDsl;
import org.springframework.security.config.annotation.web.CsrfDsl;
import org.springframework.security.config.annotation.web.ExceptionHandlingDsl;
import org.springframework.security.config.annotation.web.HeadersDsl;
import org.springframework.security.config.annotation.web.HttpBasicDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDslKt;
import org.springframework.security.config.annotation.web.SessionManagementDsl;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.headers.FrameOptionsDsl;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity(debug=false)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;)V", "getSupabaseProperties", "()Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "supabaseJwtFilter", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter;", "supabaseAuthenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "supabaseAccessDeniedHandler", "Lorg/springframework/security/web/access/AccessDeniedHandler;", "supabaseAuthenticationEntryPoint", "Lorg/springframework/security/web/AuthenticationEntryPoint;", "supabaseAuthenticationProvider", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "supabaseJwtVerifier", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier;", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "authManager", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseSecurityConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseSecurityConfig.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 HttpSecurityDsl.kt\norg/springframework/security/config/annotation/web/HttpSecurityDsl\n*L\n1#1,144:1\n216#2,2:145\n37#3,2:147\n13346#4,2:149\n13346#4,2:151\n13346#4,2:153\n13346#4,2:155\n13346#4,2:157\n13346#4,2:159\n13346#4,2:161\n13346#4,2:163\n1170#5,2:165\n*S KotlinDebug\n*F\n+ 1 SupabaseSecurityConfig.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig\n*L\n36#1:145,2\n138#1:147,2\n39#1:149,2\n43#1:151,2\n47#1:153,2\n51#1:155,2\n61#1:157,2\n65#1:159,2\n69#1:161,2\n73#1:163,2\n92#1:165,2\n*E\n"})
public class SupabaseSecurityConfig {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseSecurityConfig(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseSecurityConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http, @NotNull SupabaseJwtFilter supabaseJwtFilter, @NotNull AuthenticationManager supabaseAuthenticationManager) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)((Object)supabaseJwtFilter), (String)"supabaseJwtFilter");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationManager, (String)"supabaseAuthenticationManager");
        Map<String, SupabaseProperties.Role> $this$forEach$iv = this.getSupabaseProperties().getRoles();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SupabaseProperties.Role>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SupabaseProperties.Role> element$iv;
            Map.Entry<String, SupabaseProperties.Role> entry = element$iv = iterator.next();
            boolean bl = false;
            String role = entry.getKey();
            SupabaseProperties.Role paths = entry.getValue();
            HttpSecurityDslKt.invoke((HttpSecurity)http, arg_0 -> SupabaseSecurityConfig.filterChain$lambda$6$lambda$5(paths, this, role, arg_0));
        }
        HttpSecurityDslKt.invoke((HttpSecurity)http, arg_0 -> SupabaseSecurityConfig.filterChain$lambda$18(supabaseAuthenticationManager, supabaseJwtFilter, this, arg_0));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public AccessDeniedHandler supabaseAccessDeniedHandler() {
        return new SupabaseAccessDeniedHandler(this.getSupabaseProperties());
    }

    @Bean
    @NotNull
    public AuthenticationEntryPoint supabaseAuthenticationEntryPoint() {
        return new SupabaseAuthenticationEntryPoint(this.getSupabaseProperties());
    }

    @Bean
    @NotNull
    public SupabaseAuthenticationProvider supabaseAuthenticationProvider(@NotNull SupabaseJwtVerifier supabaseJwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)supabaseJwtVerifier, (String)"supabaseJwtVerifier");
        return new SupabaseAuthenticationProvider(supabaseJwtVerifier);
    }

    @Bean
    @NotNull
    public SupabaseJwtFilter supabaseJwtFilter(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        return new SupabaseJwtFilter(this.getSupabaseProperties(), supabaseUserService);
    }

    @Bean
    @NotNull
    public AuthenticationManager authManager(@NotNull HttpSecurity http, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider, @NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)supabaseAuthenticationProvider);
        if (supabaseProperties.getBasicAuth().getEnabled()) {
            Collection $this$toTypedArray$iv = supabaseProperties.getBasicAuth().getRoles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            authenticationManagerBuilder.inMemoryAuthentication().withUser(supabaseProperties.getBasicAuth().getUsername()).password(supabaseProperties.getBasicAuth().getPassword()).roles(Arrays.copyOf(stringArray, stringArray.length));
        }
        Object object = authenticationManagerBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AuthenticationManager)object;
    }

    private static final Unit filterChain$lambda$6$lambda$5$lambda$4(SupabaseProperties.Role $paths, SupabaseSecurityConfig this$0, String $role, AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
        String path;
        String element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)$paths, (String)"$paths");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$role, (String)"$role");
        Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
        String[] $this$forEach$iv = $paths.getGet();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method GET is secured with Expression: hasRole('" + $role + "')");
            String string = $role.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string));
        }
        $this$forEach$iv = $paths.getPost();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method POST is secured with Expression: hasRole('" + $role + "')");
            String string = $role.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string));
        }
        $this$forEach$iv = $paths.getDelete();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method DELETE is secured with Expression: hasRole('" + $role + "')");
            String string = $role.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string));
        }
        $this$forEach$iv = $paths.getPut();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method PUT is secured with Expression: hasRole('" + $role + "')");
            String string = $role.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string));
        }
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$6$lambda$5(SupabaseProperties.Role $paths, SupabaseSecurityConfig this$0, String $role, HttpSecurityDsl $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$paths, (String)"$paths");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$role, (String)"$role");
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.authorizeHttpRequests(arg_0 -> SupabaseSecurityConfig.filterChain$lambda$6$lambda$5$lambda$4($paths, this$0, $role, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$11(SupabaseSecurityConfig this$0, AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
        String path;
        String element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
        String[] $this$forEach$iv = this$0.getSupabaseProperties().getPublic().getGet();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method GET is public");
            HttpMethod httpMethod = HttpMethod.GET;
            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"GET");
            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
        }
        $this$forEach$iv = this$0.getSupabaseProperties().getPublic().getPost();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method POST is public");
            HttpMethod httpMethod = HttpMethod.POST;
            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
        }
        $this$forEach$iv = this$0.getSupabaseProperties().getPublic().getDelete();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method DELETE is public");
            HttpMethod httpMethod = HttpMethod.DELETE;
            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"DELETE");
            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
        }
        $this$forEach$iv = this$0.getSupabaseProperties().getPublic().getPut();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            path = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            this$0.getLogger().info("Path: " + path + " with Method PUT is public");
            HttpMethod httpMethod = HttpMethod.PUT;
            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"PUT");
            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
        }
        $this$authorizeHttpRequests.authorize($this$authorizeHttpRequests.getAnyRequest(), $this$authorizeHttpRequests.getAuthenticated());
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$12(SessionManagementDsl $this$sessionManagement) {
        Intrinsics.checkNotNullParameter((Object)$this$sessionManagement, (String)"$this$sessionManagement");
        $this$sessionManagement.setSessionCreationPolicy(SessionCreationPolicy.STATELESS);
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$13(HttpBasicDsl $this$httpBasic) {
        Intrinsics.checkNotNullParameter((Object)$this$httpBasic, (String)"$this$httpBasic");
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$14(CsrfDsl $this$csrf) {
        Intrinsics.checkNotNullParameter((Object)$this$csrf, (String)"$this$csrf");
        $this$csrf.disable();
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$16$lambda$15(FrameOptionsDsl $this$frameOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$frameOptions, (String)"$this$frameOptions");
        $this$frameOptions.getSameOrigin();
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$16(HeadersDsl $this$headers) {
        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
        $this$headers.frameOptions(SupabaseSecurityConfig::filterChain$lambda$18$lambda$16$lambda$15);
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18$lambda$17(SupabaseSecurityConfig this$0, ExceptionHandlingDsl $this$exceptionHandling) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$exceptionHandling, (String)"$this$exceptionHandling");
        $this$exceptionHandling.setAuthenticationEntryPoint(this$0.supabaseAuthenticationEntryPoint());
        $this$exceptionHandling.setAccessDeniedHandler(this$0.supabaseAccessDeniedHandler());
        return Unit.INSTANCE;
    }

    private static final Unit filterChain$lambda$18(AuthenticationManager $supabaseAuthenticationManager, SupabaseJwtFilter $supabaseJwtFilter, SupabaseSecurityConfig this$0, HttpSecurityDsl $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$supabaseAuthenticationManager, (String)"$supabaseAuthenticationManager");
        Intrinsics.checkNotNullParameter((Object)((Object)$supabaseJwtFilter), (String)"$supabaseJwtFilter");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.authorizeHttpRequests(arg_0 -> SupabaseSecurityConfig.filterChain$lambda$18$lambda$11(this$0, arg_0));
        $this$invoke.sessionManagement(SupabaseSecurityConfig::filterChain$lambda$18$lambda$12);
        $this$invoke.setAuthenticationManager($supabaseAuthenticationManager);
        $this$invoke.httpBasic(SupabaseSecurityConfig::filterChain$lambda$18$lambda$13);
        $this$invoke.csrf(SupabaseSecurityConfig::filterChain$lambda$18$lambda$14);
        $this$invoke.headers(SupabaseSecurityConfig::filterChain$lambda$18$lambda$16);
        HttpSecurityDsl this_$iv = $this$invoke;
        boolean $i$f$addFilterBefore = false;
        this_$iv.addFilterBefore((Filter)$supabaseJwtFilter, UsernamePasswordAuthenticationFilter.class);
        $this$invoke.exceptionHandling(arg_0 -> SupabaseSecurityConfig.filterChain$lambda$18$lambda$17(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

