/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.service;

import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.events.SupabaseUserAuthenticated;
import de.tschuehly.htmx.spring.supabase.auth.events.SupabaseUserEmailUpdateConfirmed;
import de.tschuehly.htmx.spring.supabase.auth.events.SupabaseUserEmailUpdateRequested;
import de.tschuehly.htmx.spring.supabase.auth.events.SupabaseUserRolesUpdated;
import de.tschuehly.htmx.spring.supabase.auth.exception.AnonymousSignInDisabled;
import de.tschuehly.htmx.spring.supabase.auth.exception.JWTTokenNullException;
import de.tschuehly.htmx.spring.supabase.auth.exception.MissingServiceRoleForAdminAccessException;
import de.tschuehly.htmx.spring.supabase.auth.exception.OtpExpiredException;
import de.tschuehly.htmx.spring.supabase.auth.exception.OtpSignupNotAllowedExceptions;
import de.tschuehly.htmx.spring.supabase.auth.exception.SupabaseAuthException;
import de.tschuehly.htmx.spring.supabase.auth.exception.UnknownSupabaseException;
import de.tschuehly.htmx.spring.supabase.auth.exception.ValidationFailedException;
import de.tschuehly.htmx.spring.supabase.auth.exception.WeakPasswordException;
import de.tschuehly.htmx.spring.supabase.auth.exception.email.OtpEmailSent;
import de.tschuehly.htmx.spring.supabase.auth.exception.email.PasswordRecoveryEmailSent;
import de.tschuehly.htmx.spring.supabase.auth.exception.email.RegistrationConfirmationEmailSent;
import de.tschuehly.htmx.spring.supabase.auth.exception.email.SuccessfulPasswordUpdate;
import de.tschuehly.htmx.spring.supabase.auth.exception.info.InvalidLoginCredentialsException;
import de.tschuehly.htmx.spring.supabase.auth.exception.info.NewPasswordShouldBeDifferentFromOldPasswordException;
import de.tschuehly.htmx.spring.supabase.auth.exception.info.UserAlreadyRegisteredException;
import de.tschuehly.htmx.spring.supabase.auth.exception.info.UserNeedsToConfirmEmailBeforeLoginException;
import de.tschuehly.htmx.spring.supabase.auth.exception.info.UserNeedsToConfirmEmailForEmailChangeException;
import de.tschuehly.htmx.spring.supabase.auth.htmx.HtmxUtil;
import de.tschuehly.htmx.spring.supabase.auth.security.JwtAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationToken;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtFilter;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseSecurityContextHolder;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserService;
import de.tschuehly.htmx.spring.supabase.auth.types.SupabaseUser;
import io.github.jan.supabase.auth.Auth;
import io.github.jan.supabase.auth.OtpType;
import io.github.jan.supabase.auth.admin.AdminUserUpdateBuilder;
import io.github.jan.supabase.auth.exception.AuthErrorCode;
import io.github.jan.supabase.auth.exception.AuthRestException;
import io.github.jan.supabase.auth.providers.AuthProvider;
import io.github.jan.supabase.auth.providers.builtin.Email;
import io.github.jan.supabase.auth.providers.builtin.OTP;
import io.github.jan.supabase.auth.user.UserInfo;
import io.github.jan.supabase.auth.user.UserUpdateBuilder;
import io.github.jan.supabase.exceptions.RestException;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import jakarta.servlet.http.Cookie;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.Instant;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020\u0015J\u001e\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00172\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010.J(\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00172\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010.H\u0002J\u000e\u00101\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u00102\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017J@\u00103\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172'\u00104\u001a#\b\u0001\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001507\u0012\u0006\u0012\u0004\u0018\u00010\u000105\u00a2\u0006\u0002\b8H\u0002\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/service/SupabaseUserService;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "goTrueClient", "Lio/github/jan/supabase/auth/Auth;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "authenticationManager", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "<init>", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;Lio/github/jan/supabase/auth/Auth;Lorg/springframework/context/ApplicationEventPublisher;Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;)V", "securityContextHolderStrategy", "Lorg/springframework/security/core/context/SecurityContextHolderStrategy;", "kotlin.jvm.PlatformType", "Lorg/springframework/security/core/context/SecurityContextHolderStrategy;", "securityContextRepository", "Lorg/springframework/security/web/context/SecurityContextRepository;", "logger", "Lorg/slf4j/Logger;", "signUpWithEmail", "", "email", "", "password", "emailConfirmationEnabled", "", "user", "Lio/github/jan/supabase/auth/user/UserInfo;", "loginWithEmail", "signInWithMagicLink", "handleClientAuthentication", "signInAnonymously", "requestEmailChange", "confirmEmailOtp", "otp", "resendEmailChangeConfirmation", "signInAnonymouslyWithEmail", "authenticateWithCurrentSession", "Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser;", "authenticate", "jwt", "logout", "setRolesWithRequest", "userId", "roles", "", "setRoles", "serviceRoleJWT", "sendPasswordRecoveryEmail", "updatePassword", "runGoTrue", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "handleAuthException", "exc", "Lio/github/jan/supabase/auth/exception/AuthRestException;", "handleGoTrueException", "e", "Lio/github/jan/supabase/exceptions/RestException;", "htmx-supabase-spring-boot-starter"})
public final class SupabaseUserService {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Auth goTrueClient;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final SupabaseAuthenticationProvider authenticationManager;
    private final SecurityContextHolderStrategy securityContextHolderStrategy;
    @NotNull
    private final SecurityContextRepository securityContextRepository;
    @NotNull
    private final Logger logger;

    public SupabaseUserService(@NotNull SupabaseProperties supabaseProperties, @NotNull Auth goTrueClient, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull SupabaseAuthenticationProvider authenticationManager) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Intrinsics.checkNotNullParameter((Object)goTrueClient, (String)"goTrueClient");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        this.supabaseProperties = supabaseProperties;
        this.goTrueClient = goTrueClient;
        this.applicationEventPublisher = applicationEventPublisher;
        this.authenticationManager = authenticationManager;
        this.securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        this.securityContextRepository = (SecurityContextRepository)new RequestAttributeSecurityContextRepository();
        Logger logger = LoggerFactory.getLogger(SupabaseUserService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public final void signUpWithEmail(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, password, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            final /* synthetic */ String $password;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = Auth.DefaultImpls.signUpWith$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (AuthProvider)((AuthProvider)Email.INSTANCE), null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String java.lang.String io.github.jan.supabase.auth.providers.builtin.Email$Config ), (Lio/github/jan/supabase/auth/providers/builtin/Email$Config;)Lkotlin/Unit;)((String)this.$email, (String)this.$password), (Continuation)((Continuation)this), (int)2, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (SupabaseUserService.access$emailConfirmationEnabled(this.this$0, user = (UserInfo)v0)) {
                            SupabaseUserService.access$getLogger$p(this.this$0).debug("User " + this.$email + " signed up, email confirmation sent");
                            v1 = user;
                            throw new RegistrationConfirmationEmailSent(this.$email, (Instant)(v1 != null ? v1.getConfirmationSentAt() : null));
                        }
                        SupabaseUserService.access$getLogger$p(this.this$0).debug("User " + this.$email + " successfully signed up");
                        this.this$0.loginWithEmail(this.$email, this.$password);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $email, String $password, Email.Config $this$signUpWith) {
                $this$signUpWith.setEmail($email);
                $this$signUpWith.setPassword($password);
                return Unit.INSTANCE;
            }
        }));
    }

    private final boolean emailConfirmationEnabled(UserInfo user) {
        UserInfo userInfo = user;
        return (userInfo != null ? userInfo.getEmail() : null) != null;
    }

    public final void loginWithEmail(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, password, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            final /* synthetic */ String $password;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = Auth.DefaultImpls.signInWith$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (AuthProvider)((AuthProvider)Email.INSTANCE), null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String java.lang.String io.github.jan.supabase.auth.providers.builtin.Email$Config ), (Lio/github/jan/supabase/auth/providers/builtin/Email$Config;)Lkotlin/Unit;)((String)this.$email, (String)this.$password), (Continuation)((Continuation)this), (int)2, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        user = SupabaseUserService.access$authenticateWithCurrentSession(this.this$0);
                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserAuthenticated(user, this.$email));
                        SupabaseUserService.access$getLogger$p(this.this$0).debug("User: " + this.$email + " successfully logged in");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $email, String $password, Email.Config $this$signInWith) {
                $this$signInWith.setEmail($email);
                $this$signInWith.setPassword($password);
                return Unit.INSTANCE;
            }
        }));
    }

    public final void signInWithMagicLink(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = Auth.DefaultImpls.signInWith$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (AuthProvider)((AuthProvider)OTP.INSTANCE), null, arg_0 -> signInWithMagicLink.1.invokeSuspend$lambda$0(this.$email, this.this$0, arg_0), (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) throw new OtpEmailSent(this.$email);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new OtpEmailSent(this.$email);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $email, SupabaseUserService this$0, OTP.Config $this$signInWith) {
                $this$signInWith.setEmail($email);
                $this$signInWith.setCreateUser(SupabaseUserService.access$getSupabaseProperties$p(this$0).getOtpCreateUser());
                return Unit.INSTANCE;
            }
        }));
    }

    public final void handleClientAuthentication() {
        String url = HtmxUtil.INSTANCE.getCurrentUrl();
        SupabaseUser supabaseUser = SupabaseSecurityContextHolder.INSTANCE.getAuthenticatedUser();
        if (supabaseUser == null) {
            throw new UnknownSupabaseException("No authenticated user found in SecurityContextRepository");
        }
        SupabaseUser user = supabaseUser;
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)"type=recovery", (boolean)false, (int)2, null)) {
            this.logger.debug("User: " + user.getEmail() + " is trying to reset his password");
            HtmxUtil.INSTANCE.setHeader(HtmxResponseHeader.HX_REDIRECT, this.supabaseProperties.getPasswordRecoveryPage());
            return;
        }
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)"type=email_change", (boolean)false, (int)2, null)) {
            this.logger.debug("User: " + user.getEmail() + " has set email");
            String string = user.getEmail();
            if (string == null) {
                throw new IllegalStateException("Email shouldn't be null");
            }
            String email = string;
            this.applicationEventPublisher.publishEvent((Object)new SupabaseUserEmailUpdateConfirmed(user.getId(), email));
            return;
        }
        this.applicationEventPublisher.publishEvent((Object)new SupabaseUserAuthenticated(user, null, 2, null));
        HtmxUtil.INSTANCE.setHeader(HtmxResponseHeader.HX_REDIRECT, this.supabaseProperties.getSuccessfulLoginRedirectPage());
    }

    public final void signInAnonymously() {
        SupabaseUserService.runGoTrue$default(this, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = Auth.DefaultImpls.signInAnonymously$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), null, null, (Continuation)((Continuation)this), (int)3, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        user = SupabaseUserService.access$authenticateWithCurrentSession(this.this$0);
                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserAuthenticated(user, null, 2, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public final void requestEmailChange(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        SupabaseUserService.runGoTrue$default(this, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, null){
            Object L$0;
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = SupabaseSecurityContextHolder.INSTANCE.getAuthenticatedUser();
                        if (v0 == null) {
                            throw new UnknownSupabaseException("No authenticated user found in SecurityContext");
                        }
                        user = v0;
                        this.L$0 = user;
                        this.label = 1;
                        v1 = Auth.DefaultImpls.importAuthToken$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (String)user.getVerifiedJwt(), null, (boolean)false, (boolean)false, (Continuation)((Continuation)this), (int)14, null);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        user = (SupabaseUser)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl19:
                        // 2 sources

                        this.L$0 = user;
                        this.label = 2;
                        v2 = Auth.DefaultImpls.updateUser$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (boolean)false, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String io.github.jan.supabase.auth.user.UserUpdateBuilder ), (Lio/github/jan/supabase/auth/user/UserUpdateBuilder;)Lkotlin/Unit;)((String)this.$email), (Continuation)((Continuation)this), (int)3, null);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        user = (SupabaseUser)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        if (Intrinsics.areEqual((Object)user.getEmail(), (Object)this.$email)) {
                            this.L$0 = user;
                            this.label = 3;
                            v3 = Auth.DefaultImpls.resendEmail$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (OtpType.Email)OtpType.Email.EMAIL_CHANGE, (String)this.$email, null, (Continuation)((Continuation)this), (int)4, null);
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        user = (SupabaseUser)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl40:
                        // 2 sources

                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserEmailUpdateRequested(user.getId(), this.$email));
                        throw new UserNeedsToConfirmEmailForEmailChangeException(this.$email);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $email, UserUpdateBuilder $this$updateUser) {
                $this$updateUser.setEmail($email);
                return Unit.INSTANCE;
            }
        }, 1, null);
    }

    public final void confirmEmailOtp(@NotNull String email, @NotNull String otp) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)otp, (String)"otp");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, otp, null){
            Object L$0;
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            final /* synthetic */ String $otp;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                this.$otp = $otp;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = SupabaseSecurityContextHolder.INSTANCE.getAuthenticatedUser();
                        if (v0 == null) {
                            throw new UnknownSupabaseException("No authenticated user found in SecurityContext");
                        }
                        user = v0;
                        this.L$0 = user;
                        this.label = 1;
                        v1 = Auth.DefaultImpls.importAuthToken$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (String)user.getVerifiedJwt(), null, (boolean)false, (boolean)false, (Continuation)((Continuation)this), (int)14, null);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        user = (SupabaseUser)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl19:
                        // 2 sources

                        this.L$0 = user;
                        this.label = 2;
                        v2 = Auth.DefaultImpls.verifyEmailOtp$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (OtpType.Email)OtpType.Email.EMAIL_CHANGE, (String)this.$email, (String)this.$otp, null, (Continuation)((Continuation)this), (int)8, null);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        user = (SupabaseUser)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserEmailUpdateConfirmed(user.getId(), this.$email));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void resendEmailChangeConfirmation(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = Auth.DefaultImpls.resendEmail$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (OtpType.Email)OtpType.Email.EMAIL_CHANGE, (String)this.$email, null, (Continuation)((Continuation)this), (int)4, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void signInAnonymouslyWithEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = Auth.DefaultImpls.signInAnonymously$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), null, null, (Continuation)((Continuation)this), (int)3, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = Auth.DefaultImpls.updateUser$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (boolean)false, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String io.github.jan.supabase.auth.user.UserUpdateBuilder ), (Lio/github/jan/supabase/auth/user/UserUpdateBuilder;)Lkotlin/Unit;)((String)this.$email), (Continuation)((Continuation)this), (int)3, null);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        user = SupabaseUserService.access$authenticateWithCurrentSession(this.this$0);
                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserAuthenticated(user, this.$email));
                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserEmailUpdateRequested(user.getId(), this.$email));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $email, UserUpdateBuilder $this$updateUser) {
                $this$updateUser.setEmail($email);
                return Unit.INSTANCE;
            }
        }));
    }

    private final SupabaseUser authenticateWithCurrentSession() {
        Object object = this.goTrueClient.currentSessionOrNull();
        if (object == null || (object = object.getAccessToken()) == null) {
            throw new JWTTokenNullException("The JWT that requested from supabase is null");
        }
        Object token = object;
        SupabaseJwtFilter.Companion.setJWTCookie$default(SupabaseJwtFilter.Companion, HtmxUtil.INSTANCE.getResponse(), (String)token, this.supabaseProperties, 0, 4, null);
        HtmxUtil.INSTANCE.setHeader(HtmxResponseHeader.HX_REDIRECT, this.supabaseProperties.getSuccessfulLoginRedirectPage());
        return this.authenticate((String)token);
    }

    @NotNull
    public final SupabaseUser authenticate(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        SupabaseAuthenticationToken authResult = this.authenticationManager.authenticate((Authentication)new JwtAuthenticationToken(jwt));
        SecurityContext securityContext = this.securityContextHolderStrategy.createEmptyContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"createEmptyContext(...)");
        SecurityContext context = securityContext;
        context.setAuthentication((Authentication)authResult);
        SupabaseJwtFilter.Companion.setJWTCookie$default(SupabaseJwtFilter.Companion, HtmxUtil.INSTANCE.getResponse(), jwt, this.supabaseProperties, 0, 4, null);
        this.securityContextRepository.saveContext(context, HtmxUtil.INSTANCE.getRequest(), HtmxUtil.INSTANCE.getResponse());
        SecurityContextHolder.setContext((SecurityContext)context);
        return authResult.getPrincipal();
    }

    public final void logout() {
        String jwt;
        SecurityContextHolder.getContext().setAuthentication(null);
        Cookie cookie = HtmxUtil.INSTANCE.getCookie("JWT");
        String string = jwt = cookie != null ? cookie.getValue() : null;
        if (jwt != null) {
            SupabaseJwtFilter.Companion.setJWTCookie(HtmxUtil.INSTANCE.getResponse(), jwt, this.supabaseProperties, 0);
            String string2 = this.supabaseProperties.getPostLogoutPage();
            if (string2 == null) {
                string2 = "/";
            }
            HtmxUtil.INSTANCE.setHeader(HtmxResponseHeader.HX_REDIRECT, string2);
        }
    }

    public final void setRolesWithRequest(@NotNull String userId, @Nullable List<String> roles) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Cookie cookie = HtmxUtil.INSTANCE.getCookie("JWT");
            if (cookie == null) break block0;
            Cookie it = cookie;
            boolean bl = false;
            String string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            this.setRoles(string, userId, roles);
        }
    }

    private final void setRoles(String serviceRoleJWT, String userId, List<String> roles) {
        List list = roles;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List roleArray = list;
        SupabaseUserService.runGoTrue$default(this, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, serviceRoleJWT, userId, (List<String>)roleArray, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $serviceRoleJWT;
            final /* synthetic */ String $userId;
            final /* synthetic */ List<String> $roleArray;
            {
                this.this$0 = $receiver;
                this.$serviceRoleJWT = $serviceRoleJWT;
                this.$userId = $userId;
                this.$roleArray = $roleArray;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = Auth.DefaultImpls.importAuthToken$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (String)this.$serviceRoleJWT, null, (boolean)false, (boolean)false, (Continuation)((Continuation)this), (int)14, null);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = SupabaseUserService.access$getGoTrueClient$p(this.this$0).getAdmin().updateUserById(this.$userId, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$3(java.util.List io.github.jan.supabase.auth.admin.AdminUserUpdateBuilder ), (Lio/github/jan/supabase/auth/admin/AdminUserUpdateBuilder;)Lkotlin/Unit;)(this.$roleArray), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        SupabaseUserService.access$getApplicationEventPublisher$p(this.this$0).publishEvent((Object)new SupabaseUserRolesUpdated(this.$userId, this.$roleArray));
                        SupabaseUserService.access$getLogger$p(this.this$0).debug("The roles of the user with id {} were updated to {}", (Object)this.$userId, this.$roleArray);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$3$lambda$2$lambda$1(List $roleArray, JsonArrayBuilder $this$putJsonArray) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $roleArray;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)it));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$3(List $roleArray, AdminUserUpdateBuilder $this$updateUserById) {
                void $this$invokeSuspend_u24lambda_u243_u24lambda_u242;
                JsonObjectBuilder builder$iv;
                boolean $i$f$buildJsonObject = false;
                JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
                AdminUserUpdateBuilder adminUserUpdateBuilder = $this$updateUserById;
                boolean bl = false;
                JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$invokeSuspend_u24lambda_u243_u24lambda_u242, (String)"roles", arg_0 -> setRoles.1.invokeSuspend$lambda$3$lambda$2$lambda$1($roleArray, arg_0));
                adminUserUpdateBuilder.setAppMetadata(builder$iv.build());
                return Unit.INSTANCE;
            }
        }, 1, null);
    }

    public final void sendPasswordRecoveryEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = Auth.DefaultImpls.resetPasswordForEmail$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (String)this.$email, null, null, (Continuation)((Continuation)this), (int)6, null);
                        if (object3 != object2) throw new PasswordRecoveryEmailSent("User with " + this.$email + " has requested a password recovery email");
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new PasswordRecoveryEmailSent("User with " + this.$email + " has requested a password recovery email");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void updatePassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        SupabaseUser supabaseUser = SupabaseSecurityContextHolder.INSTANCE.getAuthenticatedUser();
        if (supabaseUser == null) {
            throw new UnknownSupabaseException("No authenticated user found in SecurityContextRepository");
        }
        SupabaseUser user = supabaseUser;
        String string = user.getEmail();
        if (string == null) {
            string = "no-email";
        }
        String email = string;
        this.runGoTrue(email, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, user, password, null){
            int label;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ SupabaseUser $user;
            final /* synthetic */ String $password;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 /* !! */  = HtmxUtil.INSTANCE.getCookie("JWT");
                        if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getValue()) == null) {
                            throw new JWTTokenNullException("No JWT found in request");
                        }
                        jwt /* !! */  = v0 /* !! */ ;
                        this.label = 1;
                        v1 = Auth.DefaultImpls.importAuthToken$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (String)jwt /* !! */ , null, (boolean)false, (boolean)false, (Continuation)((Continuation)this), (int)14, null);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl17:
                        // 2 sources

                        this.label = 2;
                        v2 = Auth.DefaultImpls.updateUser$default((Auth)SupabaseUserService.access$getGoTrueClient$p(this.this$0), (boolean)false, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String io.github.jan.supabase.auth.user.UserUpdateBuilder ), (Lio/github/jan/supabase/auth/user/UserUpdateBuilder;)Lkotlin/Unit;)((String)this.$password), (Continuation)((Continuation)this), (int)3, null);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl25:
                        // 2 sources

                        throw new SuccessfulPasswordUpdate(this.$user.getEmail());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(String $password, UserUpdateBuilder $this$updateUser) {
                $this$updateUser.setPassword($password);
                return Unit.INSTANCE;
            }
        }));
    }

    private final void runGoTrue(String email, Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, this, email, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $block;
            final /* synthetic */ SupabaseUserService this$0;
            final /* synthetic */ String $email;
            {
                this.$block = $block;
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        this.label = 1;
                        v0 = this.$block.invoke((Object)$this$runBlocking, (Object)this);
                        ** if (v0 != var4_2) goto lbl12
lbl11:
                        // 1 sources

                        return var4_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.label = 2;
                        v1 = SupabaseUserService.access$getGoTrueClient$p(this.this$0).clearSession((Continuation)this);
                        v2 = v1;
                        if (v1 != var4_2) return Unit.INSTANCE;
                        return var4_2;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        return Unit.INSTANCE;
                    }
                    catch (AuthRestException exc) {
                        SupabaseUserService.access$handleAuthException(this.this$0, exc, this.$email);
                        this.label = 3;
                        {
                            catch (Throwable var3_6) {
                                this.L$0 = var3_6;
                                this.label = 5;
                                v3 = SupabaseUserService.access$getGoTrueClient$p(this.this$0).clearSession((Continuation)this);
                                v4 = v3;
                                if (v3 != var4_2) throw var3_7;
                                return var4_2;
                            }
                        }
                        v5 = SupabaseUserService.access$getGoTrueClient$p(this.this$0).clearSession((Continuation)this);
                        v6 = v5;
                        if (v5 != var4_2) return Unit.INSTANCE;
                        return var4_2;
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (RestException e) {
                            SupabaseUserService.access$handleGoTrueException(this.this$0, e, this.$email);
                            this.label = 4;
                            v7 = SupabaseUserService.access$getGoTrueClient$p(this.this$0).clearSession((Continuation)this);
                            v8 = v7;
                            if (v7 != var4_2) return Unit.INSTANCE;
                            return var4_2;
                            case 4: {
                                ResultKt.throwOnFailure((Object)$result);
                                v8 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                    }
                    case 5: {
                        var3_7 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        throw var3_7;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    static /* synthetic */ void runGoTrue$default(SupabaseUserService supabaseUserService, String string, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "no-email";
        }
        supabaseUserService.runGoTrue(string, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)function2);
    }

    private final void handleAuthException(AuthRestException exc, String email) {
        AuthErrorCode authErrorCode = exc.getErrorCode();
        switch (authErrorCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authErrorCode.ordinal()]) {
            case 1: {
                throw new UserAlreadyRegisteredException(email);
            }
            case 2: {
                throw new UserAlreadyRegisteredException(email);
            }
            case 3: {
                throw new NewPasswordShouldBeDifferentFromOldPasswordException(email);
            }
            case 4: {
                throw new WeakPasswordException(email);
            }
            case 5: {
                throw new OtpExpiredException(email);
            }
            case 6: {
                throw new ValidationFailedException(email);
            }
            case 7: {
                SupabaseUser supabaseUser = SupabaseSecurityContextHolder.INSTANCE.getAuthenticatedUser();
                throw new MissingServiceRoleForAdminAccessException(supabaseUser != null ? supabaseUser.getId() : null);
            }
        }
        throw new SupabaseAuthException(exc);
    }

    private final void handleGoTrueException(RestException e, String email) {
        String string = e.getMessage();
        if (string == null) {
            SupabaseUserService it = this;
            boolean bl = false;
            this.logger.error(e.getMessage());
            throw new UnknownSupabaseException(null, 1, null);
        }
        String message = string;
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Anonymous sign-ins are disabled", (boolean)true)) {
            throw new AnonymousSignInDisabled();
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Invalid login credentials", (boolean)true)) {
            throw new InvalidLoginCredentialsException(email);
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Email not confirmed", (boolean)true)) {
            throw new UserNeedsToConfirmEmailBeforeLoginException(email);
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Signups not allowed for otp", (boolean)true)) {
            throw new OtpSignupNotAllowedExceptions(message);
        }
        this.logger.error(e.getMessage());
        throw new UnknownSupabaseException(null, 1, null);
    }

    public static final /* synthetic */ Auth access$getGoTrueClient$p(SupabaseUserService $this) {
        return $this.goTrueClient;
    }

    public static final /* synthetic */ boolean access$emailConfirmationEnabled(SupabaseUserService $this, UserInfo user) {
        return $this.emailConfirmationEnabled(user);
    }

    public static final /* synthetic */ Logger access$getLogger$p(SupabaseUserService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SupabaseUser access$authenticateWithCurrentSession(SupabaseUserService $this) {
        return $this.authenticateWithCurrentSession();
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(SupabaseUserService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ SupabaseProperties access$getSupabaseProperties$p(SupabaseUserService $this) {
        return $this.supabaseProperties;
    }

    public static final /* synthetic */ void access$handleAuthException(SupabaseUserService $this, AuthRestException exc, String email) {
        $this.handleAuthException(exc, email);
    }

    public static final /* synthetic */ void access$handleGoTrueException(SupabaseUserService $this, RestException e, String email) {
        $this.handleGoTrueException(e, email);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthErrorCode.values().length];
            try {
                nArray[AuthErrorCode.EmailExists.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.UserAlreadyExists.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.SamePassword.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.WeakPassword.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.OtpExpired.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.ValidationFailed.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthErrorCode.NotAdmin.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

