/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.types;

import com.auth0.jwt.interfaces.Claim;
import de.tschuehly.htmx.spring.supabase.auth.exception.ClaimsCannotBeNullException;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtVerifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\nH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003Jq\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0016R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006/"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser;", "", "id", "Ljava/util/UUID;", "email", "", "phone", "isAnonymous", "", "userMetadata", "", "roles", "", "provider", "verifiedJwt", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/util/UUID;", "getEmail", "()Ljava/lang/String;", "getPhone", "()Z", "getUserMetadata", "()Ljava/util/Map;", "getRoles", "()Ljava/util/List;", "getProvider", "getVerifiedJwt", "getAuthorities", "", "Lorg/springframework/security/core/GrantedAuthority;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "htmx-supabase-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nSupabaseUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseUser.kt\nde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n1557#2:60\n1628#2,3:61\n37#3,2:64\n*S KotlinDebug\n*F\n+ 1 SupabaseUser.kt\nde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser\n*L\n54#1:60\n54#1:61,3\n54#1:64,2\n*E\n"})
public final class SupabaseUser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @Nullable
    private final String email;
    @Nullable
    private final String phone;
    private final boolean isAnonymous;
    @NotNull
    private final Map<String, Object> userMetadata;
    @NotNull
    private final List<String> roles;
    @Nullable
    private final String provider;
    @NotNull
    private final String verifiedJwt;

    public SupabaseUser(@NotNull UUID id, @Nullable String email, @Nullable String phone, boolean isAnonymous, @NotNull Map<String, Object> userMetadata, @NotNull List<String> roles, @Nullable String provider, @NotNull String verifiedJwt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(userMetadata, (String)"userMetadata");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)verifiedJwt, (String)"verifiedJwt");
        this.id = id;
        this.email = email;
        this.phone = phone;
        this.isAnonymous = isAnonymous;
        this.userMetadata = userMetadata;
        this.roles = roles;
        this.provider = provider;
        this.verifiedJwt = verifiedJwt;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @Nullable
    public final String getPhone() {
        return this.phone;
    }

    public final boolean isAnonymous() {
        return this.isAnonymous;
    }

    @NotNull
    public final Map<String, Object> getUserMetadata() {
        return this.userMetadata;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    @Nullable
    public final String getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getVerifiedJwt() {
        return this.verifiedJwt;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<GrantedAuthority> getAuthorities() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.roles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add("ROLE_" + string2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] roleList = thisCollection$iv.toArray(new String[0]);
        return AuthorityUtils.createAuthorityList((String[])Arrays.copyOf(roleList, roleList.length));
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.email;
    }

    @Nullable
    public final String component3() {
        return this.phone;
    }

    public final boolean component4() {
        return this.isAnonymous;
    }

    @NotNull
    public final Map<String, Object> component5() {
        return this.userMetadata;
    }

    @NotNull
    public final List<String> component6() {
        return this.roles;
    }

    @Nullable
    public final String component7() {
        return this.provider;
    }

    @NotNull
    public final String component8() {
        return this.verifiedJwt;
    }

    @NotNull
    public final SupabaseUser copy(@NotNull UUID id, @Nullable String email, @Nullable String phone, boolean isAnonymous, @NotNull Map<String, Object> userMetadata, @NotNull List<String> roles, @Nullable String provider, @NotNull String verifiedJwt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(userMetadata, (String)"userMetadata");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)verifiedJwt, (String)"verifiedJwt");
        return new SupabaseUser(id, email, phone, isAnonymous, userMetadata, roles, provider, verifiedJwt);
    }

    public static /* synthetic */ SupabaseUser copy$default(SupabaseUser supabaseUser, UUID uUID, String string, String string2, boolean bl, Map map, List list, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = supabaseUser.id;
        }
        if ((n & 2) != 0) {
            string = supabaseUser.email;
        }
        if ((n & 4) != 0) {
            string2 = supabaseUser.phone;
        }
        if ((n & 8) != 0) {
            bl = supabaseUser.isAnonymous;
        }
        if ((n & 0x10) != 0) {
            map = supabaseUser.userMetadata;
        }
        if ((n & 0x20) != 0) {
            list = supabaseUser.roles;
        }
        if ((n & 0x40) != 0) {
            string3 = supabaseUser.provider;
        }
        if ((n & 0x80) != 0) {
            string4 = supabaseUser.verifiedJwt;
        }
        return supabaseUser.copy(uUID, string, string2, bl, map, list, string3, string4);
    }

    @NotNull
    public String toString() {
        return "SupabaseUser(id=" + this.id + ", email=" + this.email + ", phone=" + this.phone + ", isAnonymous=" + this.isAnonymous + ", userMetadata=" + this.userMetadata + ", roles=" + this.roles + ", provider=" + this.provider + ", verifiedJwt=" + this.verifiedJwt + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.phone == null ? 0 : this.phone.hashCode());
        result = result * 31 + Boolean.hashCode(this.isAnonymous);
        result = result * 31 + ((Object)this.userMetadata).hashCode();
        result = result * 31 + ((Object)this.roles).hashCode();
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + this.verifiedJwt.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SupabaseUser)) {
            return false;
        }
        SupabaseUser supabaseUser = (SupabaseUser)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)supabaseUser.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.email, (Object)supabaseUser.email)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.phone, (Object)supabaseUser.phone)) {
            return false;
        }
        if (this.isAnonymous != supabaseUser.isAnonymous) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userMetadata, supabaseUser.userMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.roles, supabaseUser.roles)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.provider, (Object)supabaseUser.provider)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.verifiedJwt, (Object)supabaseUser.verifiedJwt);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000f"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser$Companion;", "", "<init>", "()V", "createFromJWT", "Lde/tschuehly/htmx/spring/supabase/auth/types/SupabaseUser;", "verifiedJwt", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtVerifier$VerificationResult;", "getRolesFromAppMetadata", "", "", "claimsMap", "", "Lcom/auth0/jwt/interfaces/Claim;", "getProviderFromAppMetadata", "htmx-supabase-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SupabaseUser createFromJWT(@NotNull SupabaseJwtVerifier.VerificationResult verifiedJwt) {
            Object object;
            Object metadata;
            Map<String, Claim> claimsMap;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)verifiedJwt, (String)"verifiedJwt");
                    claimsMap = verifiedJwt.getClaims();
                    Object object2 = claimsMap.get("user_metadata");
                    if (object2 == null || (object2 = object2.asMap()) == null || (object2 = MapsKt.toMutableMap((Map)object2)) == null) {
                        object2 = metadata = (Map)new LinkedHashMap();
                    }
                    if ((object = claimsMap.get("sub")) == null) break block4;
                    Claim it = object;
                    boolean bl = false;
                    UUID uUID = UUID.fromString(it.asString());
                    object = uUID;
                    if (uUID != null) break block5;
                }
                throw new ClaimsCannotBeNullException("sub claim is null");
            }
            Claim claim = claimsMap.get("email");
            Claim claim2 = claimsMap.get("phone");
            String string = verifiedJwt.getToken();
            String string2 = this.getProviderFromAppMetadata(claimsMap);
            List<String> list = this.getRolesFromAppMetadata(claimsMap);
            Object object3 = metadata;
            Object object4 = claimsMap.get("is_anonymous");
            boolean bl = object4 != null && (object4 = object4.asBoolean()) != null ? (Boolean)object4 : true;
            String string3 = claim2 != null ? claim2.asString() : null;
            String string4 = claim != null ? claim.asString() : null;
            Object object5 = object;
            return new SupabaseUser((UUID)object5, string4, string3, bl, (Map<String, Object>)object3, list, string2, string);
        }

        private final List<String> getRolesFromAppMetadata(Map<String, ? extends Claim> claimsMap) {
            Object roles;
            Object object = claimsMap.get("app_metadata");
            Object v1 = object != null && (object = object.asMap()) != null ? object.get("roles") : (roles = null);
            if (roles instanceof List && CollectionsKt.firstOrNull((List)roles) instanceof String) {
                return roles;
            }
            return CollectionsKt.emptyList();
        }

        private final String getProviderFromAppMetadata(Map<String, ? extends Claim> claimsMap) {
            Object object = claimsMap.get("app_metadata");
            String string = String.valueOf(object != null && (object = object.asMap()) != null ? object.get("provider") : null);
            if (string == null) {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

