/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.action;

import de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction;
import de.tschuehly.spring.viewcomponent.core.action.GetViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PatchViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PostViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PutViewAction;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionRegistry;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponent;
import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J-\u0010\u0016\u001a\u00020\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0012\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0012J\b\u0010\u001d\u001a\u00020\u0010H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lde/tschuehly/spring/viewcomponent/core/action/ViewActionConfiguration;", "", "context", "Lorg/springframework/context/ApplicationContext;", "requestMappingHandlerMapping", "Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping;", "viewActionRegistry", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;", "(Lorg/springframework/context/ApplicationContext;Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping;Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;)V", "getContext", "()Lorg/springframework/context/ApplicationContext;", "getRequestMappingHandlerMapping", "()Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping;", "getViewActionRegistry", "()Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;", "createRequestMappingForAnnotation", "", "viewComponentName", "", "viewComponentBean", "mapping", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry$PathMapping;", "processViewComponentBean", "viewComponentMethods", "", "Ljava/lang/reflect/Method;", "([Ljava/lang/reflect/Method;Ljava/lang/String;Ljava/lang/Object;)V", "processViewComponentMethods", "method", "registerViewActionEndpoints", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewActionConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewActionConfiguration.kt\nde/tschuehly/spring/viewcomponent/core/action/ViewActionConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n215#2,2:94\n13579#3,2:96\n13579#3,2:98\n*S KotlinDebug\n*F\n+ 1 ViewActionConfiguration.kt\nde/tschuehly/spring/viewcomponent/core/action/ViewActionConfiguration\n*L\n26#1:94,2\n38#1:96,2\n44#1:98,2\n*E\n"})
public class ViewActionConfiguration {
    @NotNull
    private final ApplicationContext context;
    @NotNull
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    @NotNull
    private final ViewActionRegistry viewActionRegistry;

    public ViewActionConfiguration(@NotNull ApplicationContext context, @NotNull RequestMappingHandlerMapping requestMappingHandlerMapping, @NotNull ViewActionRegistry viewActionRegistry) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)requestMappingHandlerMapping, (String)"requestMappingHandlerMapping");
        Intrinsics.checkNotNullParameter((Object)viewActionRegistry, (String)"viewActionRegistry");
        this.context = context;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.viewActionRegistry = viewActionRegistry;
    }

    @NotNull
    public ApplicationContext getContext() {
        return this.context;
    }

    @NotNull
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return this.requestMappingHandlerMapping;
    }

    @NotNull
    public ViewActionRegistry getViewActionRegistry() {
        return this.viewActionRegistry;
    }

    @PostConstruct
    public void registerViewActionEndpoints() {
        Map viewComponentBeans;
        Map map = this.getContext().getBeansWithAnnotation(ViewComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context.getBeansWithAnno\u2026iewComponent::class.java)");
        Map $this$forEach$iv = viewComponentBeans = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Class beanType;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String viewComponentName = (String)entry.getKey();
            Object viewComponentBean = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ClassUtils.getUserClass(viewComponentBean.getClass()), (String)"getUserClass(viewComponentBean.javaClass)");
            Method[] viewComponentMethods = beanType.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)viewComponentMethods, (String)"viewComponentMethods");
            Intrinsics.checkNotNullExpressionValue((Object)viewComponentName, (String)"viewComponentName");
            Intrinsics.checkNotNullExpressionValue(viewComponentBean, (String)"viewComponentBean");
            this.processViewComponentBean(viewComponentMethods, viewComponentName, viewComponentBean);
        }
    }

    private void processViewComponentBean(Method[] viewComponentMethods, String viewComponentName, Object viewComponentBean) {
        Method[] $this$forEach$iv = viewComponentMethods;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Method element$iv;
            Method method = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.processViewComponentMethods(method, viewComponentName, viewComponentBean);
        }
    }

    private void processViewComponentMethods(Method method, String viewComponentName, Object viewComponentBean) {
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.declaredAnnotations");
        Object[] $this$forEach$iv = annotationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewActionRegistry.PathMapping pathMapping;
            Pair pair;
            Annotation declaredAnnotation = (Annotation)element$iv;
            boolean bl = false;
            KClass kClass = JvmClassMappingKt.getAnnotationClass((Annotation)declaredAnnotation);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(GetViewAction.class))) {
                Intrinsics.checkNotNull((Object)declaredAnnotation, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.GetViewAction");
                pair = TuplesKt.to((Object)RequestMethod.GET, (Object)((GetViewAction)declaredAnnotation).path());
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(PostViewAction.class))) {
                Intrinsics.checkNotNull((Object)declaredAnnotation, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PostViewAction");
                pair = TuplesKt.to((Object)RequestMethod.POST, (Object)((PostViewAction)declaredAnnotation).path());
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(PutViewAction.class))) {
                Intrinsics.checkNotNull((Object)declaredAnnotation, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PutViewAction");
                pair = TuplesKt.to((Object)RequestMethod.PUT, (Object)((PutViewAction)declaredAnnotation).path());
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(PatchViewAction.class))) {
                Intrinsics.checkNotNull((Object)declaredAnnotation, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PatchViewAction");
                pair = TuplesKt.to((Object)RequestMethod.PATCH, (Object)((PatchViewAction)declaredAnnotation).path());
            } else {
                if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(DeleteViewAction.class))) continue;
                Intrinsics.checkNotNull((Object)declaredAnnotation, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction");
                pair = TuplesKt.to((Object)RequestMethod.DELETE, (Object)((DeleteViewAction)declaredAnnotation).path());
            }
            Pair viewActionPair = pair;
            if (Intrinsics.areEqual((Object)viewActionPair.getSecond(), (Object)"")) {
                String string = ("/" + viewComponentName + "/" + method.getName()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                pathMapping = new ViewActionRegistry.PathMapping(string, (RequestMethod)viewActionPair.getFirst(), method);
            } else {
                String string = ((String)viewActionPair.getSecond()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                pathMapping = new ViewActionRegistry.PathMapping(string, (RequestMethod)viewActionPair.getFirst(), method);
            }
            ViewActionRegistry.PathMapping pathMapping2 = pathMapping;
            this.createRequestMappingForAnnotation(viewComponentName, viewComponentBean, pathMapping2);
        }
    }

    private void createRequestMappingForAnnotation(String viewComponentName, Object viewComponentBean, ViewActionRegistry.PathMapping mapping) {
        RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
        PathPatternParser parser = new PathPatternParser();
        parser.setCaseSensitive(false);
        options.setPatternParser(parser);
        String[] stringArray = new String[]{mapping.getPath()};
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])stringArray);
        stringArray = new RequestMethod[]{mapping.getRequestMethod()};
        this.getRequestMappingHandlerMapping().registerMapping(builder.methods((RequestMethod[])stringArray).options(options).build(), viewComponentBean, mapping.getMethod());
        this.getViewActionRegistry().registerMapping(viewComponentName, mapping);
    }
}

