/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.action;

import de.tschuehly.spring.viewcomponent.core.action.ViewActionConstant;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionRegistry;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProcessingException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0010H\u0012J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0012J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lde/tschuehly/spring/viewcomponent/core/action/ViewActionParser;", "", "viewActionRegistry", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;", "(Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;)V", "getViewActionRegistry", "()Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;", "addHtmxAttrForNestedViewComponents", "", "document", "Lorg/jsoup/nodes/Element;", "getHXAttr", "", "requestMethod", "Lorg/springframework/web/bind/annotation/RequestMethod;", "getSingleChildElement", "Lorg/jsoup/nodes/Document;", "parseViewComponent", "viewComponentName", "htmlString", "processRootElementViewComponent", "replaceViewActionAttrWithHtmxAttr", "viewComponentElement", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewActionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewActionParser.kt\nde/tschuehly/spring/viewcomponent/core/action/ViewActionParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1855#2,2:103\n1855#2,2:105\n*S KotlinDebug\n*F\n+ 1 ViewActionParser.kt\nde/tschuehly/spring/viewcomponent/core/action/ViewActionParser\n*L\n56#1:103,2\n70#1:105,2\n*E\n"})
public class ViewActionParser {
    @NotNull
    private final ViewActionRegistry viewActionRegistry;

    public ViewActionParser(@NotNull ViewActionRegistry viewActionRegistry) {
        Intrinsics.checkNotNullParameter((Object)viewActionRegistry, (String)"viewActionRegistry");
        this.viewActionRegistry = viewActionRegistry;
    }

    @NotNull
    public ViewActionRegistry getViewActionRegistry() {
        return this.viewActionRegistry;
    }

    @NotNull
    public String parseViewComponent(@NotNull String viewComponentName, @NotNull String htmlString) {
        Intrinsics.checkNotNullParameter((Object)viewComponentName, (String)"viewComponentName");
        Intrinsics.checkNotNullParameter((Object)htmlString, (String)"htmlString");
        Document document = Jsoup.parse((String)htmlString, (String)"", (Parser)Parser.xmlParser());
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(htmlString, \"\", Parser.xmlParser())");
        Document document2 = document;
        this.addHtmxAttrForNestedViewComponents((Element)document2);
        this.processRootElementViewComponent(document2, viewComponentName);
        String string = document2.outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.outerHtml()");
        return string;
    }

    private void processRootElementViewComponent(Document document, String viewComponentName) {
        if (document.getElementsByAttribute(ViewActionConstant.INSTANCE.getAttributeName()).size() == 0) {
            return;
        }
        Element childElement = this.getSingleChildElement(document);
        if (Intrinsics.areEqual((Object)childElement.nodeName(), (Object)"html")) {
            Element element = document.selectFirst("body");
            if (element == null) {
                throw new ViewComponentProcessingException("No body tag in the root ViewComponent found, this is required", null);
            }
            Element bodyElement = element;
            bodyElement.attr("id", viewComponentName);
            this.replaceViewActionAttrWithHtmxAttr(bodyElement);
        } else {
            childElement.attr("id", viewComponentName);
            this.replaceViewActionAttrWithHtmxAttr(childElement);
        }
    }

    private Element getSingleChildElement(Document document) {
        Element firstChild = document.firstElementChild();
        if (!Intrinsics.areEqual((Object)document.lastElementChild(), (Object)firstChild) || firstChild == null) {
            throw new ViewComponentProcessingException("ViewComponent need to have one root html node", null);
        }
        return firstChild;
    }

    private void addHtmxAttrForNestedViewComponents(Element document) {
        Elements elements = document.getElementsByAttribute(ViewActionConstant.INSTANCE.getNestedViewComponentAttributeName());
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"document.getElementsByAt\u2026ewComponentAttributeName)");
        Elements nestedViewComponents = elements;
        Iterable $this$forEach$iv = (Iterable)nestedViewComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element viewComponentElement = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)viewComponentElement, (String)"viewComponentElement");
            this.replaceViewActionAttrWithHtmxAttr(viewComponentElement);
        }
    }

    private void replaceViewActionAttrWithHtmxAttr(Element viewComponentElement) {
        String string = viewComponentElement.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"viewComponentElement.id()");
        String viewComponentName = string;
        if (Intrinsics.areEqual((Object)viewComponentName, (Object)"")) {
            throw new ViewComponentProcessingException("Id with name of viewcomponent is needed on the viewcomponent element, this should be set by the templating engine when processing nested viewcomponents", null);
        }
        Elements elements = viewComponentElement.getElementsByAttribute(ViewActionConstant.INSTANCE.getAttributeName());
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"viewComponentElement.get\u2026onConstant.attributeName)");
        Elements postViewActions = elements;
        Iterable $this$forEach$iv = (Iterable)postViewActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ViewActionRegistry.PathMapping viewActionMapping;
            Element el;
            block7: {
                block6: {
                    el = (Element)element$iv;
                    boolean bl = false;
                    String string2 = el.attr(ViewActionConstant.INSTANCE.getAttributeName());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"el.attr(ViewActionConstant.attributeName)");
                    String[] stringArray = new String[]{"?"};
                    List splitMethodAttribute = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String methodName = (String)splitMethodAttribute.get(0);
                    el.removeAttr(ViewActionConstant.INSTANCE.getAttributeName());
                    viewActionMapping = this.getViewActionRegistry().getMapping(viewComponentName, methodName);
                    object = (String)CollectionsKt.getOrNull((List)splitMethodAttribute, (int)1);
                    if (object == null) break block6;
                    String pathAttributeString = object;
                    boolean bl2 = false;
                    String string3 = viewActionMapping.getPath() + "?" + pathAttributeString;
                    object = string3;
                    if (string3 != null) break block7;
                }
                object = viewActionMapping.getPath();
            }
            String path = object;
            el.attr(this.getHXAttr(viewActionMapping.getRequestMethod()), path);
            if (Intrinsics.areEqual((Object)el.attr("hx-target"), (Object)"")) {
                el.attr("hx-target", "#" + viewComponentName);
            }
            if (!Intrinsics.areEqual((Object)el.attr("hx-swap"), (Object)"")) continue;
            el.attr("hx-swap", "outerHTML");
        }
    }

    @NotNull
    public String getHXAttr(@NotNull RequestMethod requestMethod) {
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        return switch (WhenMappings.$EnumSwitchMapping$0[requestMethod.ordinal()]) {
            case 1 -> "hx-get";
            case 2 -> "hx-post";
            case 3 -> "hx-put";
            case 4 -> "hx-patch";
            case 5 -> "hx-delete";
            default -> throw new ViewComponentProcessingException("RequestMethod: " + requestMethod.name() + " not supported", null);
        };
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

