/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.action;

import de.tschuehly.spring.viewcomponent.core.action.ViewActionRegistryException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry;", "", "()V", "viewActionMapping", "", "", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry$PathMapping;", "getMapping", "viewComponentName", "viewActionMethodName", "registerMapping", "", "mapping", "viewActionKey", "PathMapping", "spring-view-component-core"})
public class ViewActionRegistry {
    @NotNull
    private final Map<String, PathMapping> viewActionMapping = new LinkedHashMap();

    public void registerMapping(@NotNull String viewComponentName, @NotNull PathMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)viewComponentName, (String)"viewComponentName");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        String string = mapping.getMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapping.method.name");
        String key = this.viewActionKey(viewComponentName, string);
        if (this.viewActionMapping.containsKey(key)) {
            throw new ViewActionRegistryException("Cannot register duplicate path mapping");
        }
        this.viewActionMapping.put(key, mapping);
    }

    @NotNull
    public PathMapping getMapping(@NotNull String viewComponentName, @NotNull String viewActionMethodName) {
        Intrinsics.checkNotNullParameter((Object)viewComponentName, (String)"viewComponentName");
        Intrinsics.checkNotNullParameter((Object)viewActionMethodName, (String)"viewActionMethodName");
        String viewActionKey = this.viewActionKey(viewComponentName, viewActionMethodName);
        PathMapping pathMapping = this.viewActionMapping.get(viewActionKey);
        if (pathMapping == null) {
            throw new ViewActionRegistryException("ViewActionMapping with the key " + viewActionKey + " not found");
        }
        return pathMapping;
    }

    @NotNull
    public String viewActionKey(@NotNull String viewComponentName, @NotNull String viewActionMethodName) {
        Intrinsics.checkNotNullParameter((Object)viewComponentName, (String)"viewComponentName");
        Intrinsics.checkNotNullParameter((Object)viewActionMethodName, (String)"viewActionMethodName");
        String string = (viewComponentName + "_" + viewActionMethodName).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lde/tschuehly/spring/viewcomponent/core/action/ViewActionRegistry$PathMapping;", "", "path", "", "requestMethod", "Lorg/springframework/web/bind/annotation/RequestMethod;", "method", "Ljava/lang/reflect/Method;", "(Ljava/lang/String;Lorg/springframework/web/bind/annotation/RequestMethod;Ljava/lang/reflect/Method;)V", "getMethod", "()Ljava/lang/reflect/Method;", "getPath", "()Ljava/lang/String;", "getRequestMethod", "()Lorg/springframework/web/bind/annotation/RequestMethod;", "spring-view-component-core"})
    public static final class PathMapping {
        @NotNull
        private final String path;
        @NotNull
        private final RequestMethod requestMethod;
        @NotNull
        private final Method method;

        public PathMapping(@NotNull String path, @NotNull RequestMethod requestMethod, @NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.path = path;
            this.requestMethod = requestMethod;
            this.method = method;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final RequestMethod getRequestMethod() {
            return this.requestMethod;
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }
    }
}

