/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.processor;

import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentChangeListener;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.devtools.classpath.ClassPathFileSystemWatcher;
import org.springframework.boot.devtools.classpath.ClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.boot.devtools.filewatch.FileSystemWatcherFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\u0006\u0010$\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0019\u0010\u0019\u001a\n \u000e*\u0004\u0018\u00010\u001a0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006%"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentFileSystemWatcher;", "Lorg/springframework/boot/devtools/classpath/ClassPathFileSystemWatcher;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "fileSystemWatcherFactory", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcherFactory;", "restartStrategy", "Lorg/springframework/boot/devtools/classpath/ClassPathRestartStrategy;", "urls", "", "Ljava/net/URL;", "(Lorg/springframework/context/ApplicationContext;Lorg/springframework/boot/devtools/filewatch/FileSystemWatcherFactory;Lorg/springframework/boot/devtools/classpath/ClassPathRestartStrategy;[Ljava/net/URL;)V", "fileSystemWatcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "kotlin.jvm.PlatformType", "getFileSystemWatcher", "()Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "javaGradleBuildDir", "", "getJavaGradleBuildDir", "()Ljava/lang/String;", "javaMavenBuildDir", "getJavaMavenBuildDir", "kotlinGradleBuildDir", "getKotlinGradleBuildDir", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "[Ljava/net/URL;", "afterPropertiesSet", "", "getSrcDir", "Lkotlin/Pair;", "Ljava/io/File;", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "classPath", "spring-view-component-core"})
public final class ViewComponentFileSystemWatcher
extends ClassPathFileSystemWatcher {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final FileSystemWatcherFactory fileSystemWatcherFactory;
    @NotNull
    private final ClassPathRestartStrategy restartStrategy;
    @NotNull
    private final URL[] urls;
    private final Logger logger;
    @NotNull
    private final String kotlinGradleBuildDir;
    @NotNull
    private final String javaGradleBuildDir;
    @NotNull
    private final String javaMavenBuildDir;
    private final FileSystemWatcher fileSystemWatcher;

    public ViewComponentFileSystemWatcher(@NotNull ApplicationContext applicationContext, @NotNull FileSystemWatcherFactory fileSystemWatcherFactory, @NotNull ClassPathRestartStrategy restartStrategy, @NotNull URL[] urls) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)fileSystemWatcherFactory, (String)"fileSystemWatcherFactory");
        Intrinsics.checkNotNullParameter((Object)restartStrategy, (String)"restartStrategy");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        super(fileSystemWatcherFactory, restartStrategy, urls);
        this.applicationContext = applicationContext;
        this.fileSystemWatcherFactory = fileSystemWatcherFactory;
        this.restartStrategy = restartStrategy;
        this.urls = urls;
        this.logger = LoggerFactory.getLogger(ViewComponentFileSystemWatcher.class);
        this.kotlinGradleBuildDir = "build/classes/kotlin/main/";
        this.javaGradleBuildDir = "build/classes/java/main/";
        this.javaMavenBuildDir = "target/classes/";
        this.fileSystemWatcher = this.fileSystemWatcherFactory.getFileSystemWatcher();
    }

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getKotlinGradleBuildDir() {
        return this.kotlinGradleBuildDir;
    }

    @NotNull
    public final String getJavaGradleBuildDir() {
        return this.javaGradleBuildDir;
    }

    @NotNull
    public final String getJavaMavenBuildDir() {
        return this.javaMavenBuildDir;
    }

    public final FileSystemWatcher getFileSystemWatcher() {
        return this.fileSystemWatcher;
    }

    public void afterPropertiesSet() {
        String classPath = CollectionsKt.first((Iterable)this.applicationContext.getBeansWithAnnotation(SpringBootApplication.class).values()).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"classPath");
        Pair<File, ViewComponentParser.BuildType> pair = this.getSrcDir(classPath);
        File srcDir = (File)pair.component1();
        ViewComponentParser.BuildType buildType = (ViewComponentParser.BuildType)((Object)pair.component2());
        this.logger.info("Watching for template changes at: " + srcDir.getAbsoluteFile().getPath());
        this.fileSystemWatcher.addSourceDirectory(srcDir);
        this.fileSystemWatcher.addListener((FileChangeListener)new ViewComponentChangeListener(this.applicationContext, buildType, (ApplicationEventPublisher)this.applicationContext));
        this.fileSystemWatcher.start();
    }

    private final Pair<File, ViewComponentParser.BuildType> getSrcDir(String classPath) {
        Object file;
        String srcDir;
        if (StringsKt.endsWith$default((String)classPath, (String)this.kotlinGradleBuildDir, (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{this.kotlinGradleBuildDir};
            srcDir = StringsKt.split$default((CharSequence)classPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0) + "/src/main/kotlin";
            file = new File(srcDir);
            if (((File)file).exists()) {
                return TuplesKt.to((Object)file, (Object)((Object)ViewComponentParser.BuildType.GRADLE));
            }
        }
        if (StringsKt.endsWith$default((String)classPath, (String)this.javaGradleBuildDir, (boolean)false, (int)2, null)) {
            file = new String[]{this.javaGradleBuildDir};
            srcDir = StringsKt.split$default((CharSequence)classPath, (String[])file, (boolean)false, (int)0, (int)6, null).get(0) + "src/main/java";
            if (((File)(file = new File(srcDir))).exists()) {
                return TuplesKt.to((Object)file, (Object)((Object)ViewComponentParser.BuildType.GRADLE));
            }
        }
        if (StringsKt.endsWith$default((String)classPath, (String)this.javaMavenBuildDir, (boolean)false, (int)2, null)) {
            file = new String[]{this.javaMavenBuildDir};
            srcDir = StringsKt.split$default((CharSequence)classPath, (String[])file, (boolean)false, (int)0, (int)6, null).get(0) + "src/main/java";
            if (((File)(file = new File(srcDir))).exists()) {
                return TuplesKt.to((Object)file, (Object)((Object)ViewComponentParser.BuildType.MAVEN));
            }
        }
        throw new ViewComponentProcessingException("No srcDir found", null);
    }
}

