/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.processor;

import de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction;
import de.tschuehly.spring.viewcomponent.core.action.GetViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PatchViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PostViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PutViewAction;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionMethod;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponent;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener;", "Lorg/springframework/boot/devtools/filewatch/FileChangeListener;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "buildType", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/springframework/context/ApplicationContext;Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;Lorg/springframework/context/ApplicationEventPublisher;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isTemplate", "", "changeSet", "", "Lorg/springframework/boot/devtools/filewatch/ChangedFiles;", "onChange", "", "Companion", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewComponentChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentChangeListener.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n515#2:85\n500#2,6:86\n1747#3,2:92\n1747#3,3:94\n1749#3:97\n*S KotlinDebug\n*F\n+ 1 ViewComponentChangeListener.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener\n*L\n27#1:85\n27#1:86,6\n47#1:92,2\n48#1:94,3\n47#1:97\n*E\n"})
public final class ViewComponentChangeListener
implements FileChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ViewComponentParser.BuildType buildType;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Logger logger;

    public ViewComponentChangeListener(@NotNull ApplicationContext applicationContext, @NotNull ViewComponentParser.BuildType buildType, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)buildType), (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.applicationContext = applicationContext;
        this.buildType = buildType;
        this.applicationEventPublisher = applicationEventPublisher;
        this.logger = LoggerFactory.getLogger(ViewComponentChangeListener.class);
    }

    /*
     * WARNING - void declaration
     */
    public void onChange(@NotNull Set<ChangedFiles> changeSet) {
        Intrinsics.checkNotNullParameter(changeSet, (String)"changeSet");
        if (this.isTemplate(changeSet)) {
            Class<Object> clazz;
            void $this$filterTo$iv$iv;
            Set set = ((ChangedFiles)CollectionsKt.first((Iterable)changeSet)).getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"changeSet.first().files");
            File srcFile = ((ChangedFile)CollectionsKt.first((Iterable)set)).getFile();
            Map map = this.applicationContext.getBeansWithAnnotation(ViewComponent.class);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"applicationContext.getBe\u2026iewComponent::class.java)");
            Map $this$filter$iv = map;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                String string = ((String)k).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                Intrinsics.checkNotNullExpressionValue((Object)srcFile, (String)"srcFile");
                String string2 = FilesKt.getNameWithoutExtension((File)srcFile).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Object bean = CollectionsKt.first((Iterable)destination$iv$iv.values());
            if (AopUtils.isAopProxy((Object)bean) && bean instanceof Advised) {
                Object object = ((Advised)bean).getTargetSource().getTarget();
                Intrinsics.checkNotNull((Object)object);
                clazz = object.getClass();
            } else {
                clazz = bean.getClass();
            }
            Class<Object> javaClass = clazz;
            List<ViewActionMethod> methodList = Companion.getViewActionMethods(javaClass);
            this.logger.debug("Detected Change to {}", (Object)srcFile.getAbsoluteFile());
            Intrinsics.checkNotNullExpressionValue((Object)srcFile, (String)"srcFile");
            String string = javaClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
            String string3 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            ViewComponentParser parser = new ViewComponentParser(srcFile, this.buildType, methodList, string3, null, 16, null);
            parser.parseFile(true);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ContextRefreshedEvent(this.applicationContext));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTemplate(Set<ChangedFiles> changeSet) {
        boolean bl;
        Iterable $this$any$iv = changeSet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ChangedFiles changedFiles = (ChangedFiles)element$iv;
            boolean bl2 = false;
            Set set = changedFiles.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"changedFiles.files");
            Iterable $this$any$iv2 = set;
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl = false;
                continue;
            }
            for (Object element$iv2 : $this$any$iv2) {
                ChangedFile it = (ChangedFile)element$iv2;
                boolean bl3 = false;
                String string = it.getRelativeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeName");
                if (StringsKt.endsWith$default((String)string, (String)".html", (boolean)false, (int)2, null)) return true;
                String string2 = it.getRelativeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.relativeName");
                if (StringsKt.endsWith$default((String)string2, (String)".th", (boolean)false, (int)2, null)) return true;
                String string3 = it.getRelativeName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.relativeName");
                if (StringsKt.endsWith$default((String)string3, (String)".jte", (boolean)false, (int)2, null)) return true;
                String string4 = it.getRelativeName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.relativeName");
                if (StringsKt.endsWith$default((String)string4, (String)".kte", (boolean)false, (int)2, null)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a8\u0006\b"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener$Companion;", "", "()V", "getViewActionMethods", "", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionMethod;", "javaClass", "Ljava/lang/Class;", "spring-view-component-core"})
    @SourceDebugExtension(value={"SMAP\nViewComponentChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentChangeListener.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n11653#2,9:85\n13579#2:94\n13580#2:96\n11662#2:97\n1#3:95\n*S KotlinDebug\n*F\n+ 1 ViewComponentChangeListener.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentChangeListener$Companion\n*L\n58#1:85,9\n58#1:94\n58#1:96\n58#1:97\n58#1:95\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ViewActionMethod> getViewActionMethods(@NotNull Class<Object> javaClass) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
            Method[] methodArray = javaClass.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"javaClass.declaredMethods");
            Object[] $this$mapNotNull$iv = methodArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                ViewActionMethod viewActionMethod;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                Method method = (Method)element$iv$iv;
                boolean bl2 = false;
                if (method.getAnnotation(GetViewAction.class) != null) {
                    Intrinsics.checkNotNull((Object)method.getAnnotation(GetViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.GetViewAction");
                    viewActionMethod = new ViewActionMethod(method.getName().toString(), get.path(), GetViewAction.class);
                } else if (method.getAnnotation(PostViewAction.class) != null) {
                    Intrinsics.checkNotNull((Object)method.getAnnotation(PostViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PostViewAction");
                    viewActionMethod = new ViewActionMethod(method.getName().toString(), get.path(), PostViewAction.class);
                } else if (method.getAnnotation(PutViewAction.class) != null) {
                    Intrinsics.checkNotNull((Object)method.getAnnotation(PutViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PutViewAction");
                    viewActionMethod = new ViewActionMethod(method.getName().toString(), get.path(), PutViewAction.class);
                } else if (method.getAnnotation(PatchViewAction.class) != null) {
                    Intrinsics.checkNotNull((Object)method.getAnnotation(PatchViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PatchViewAction");
                    viewActionMethod = new ViewActionMethod(method.getName().toString(), get.path(), PatchViewAction.class);
                } else if (method.getAnnotation(DeleteViewAction.class) != null) {
                    Intrinsics.checkNotNull((Object)method.getAnnotation(DeleteViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction");
                    viewActionMethod = new ViewActionMethod(method.getName().toString(), get.path(), DeleteViewAction.class);
                } else {
                    viewActionMethod = null;
                }
                if (viewActionMethod == null) continue;
                ViewActionMethod it$iv$iv = viewActionMethod;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

