/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.processor;

import de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction;
import de.tschuehly.spring.viewcomponent.core.action.GetViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PatchViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PostViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PutViewAction;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionMethod;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import de.tschuehly.spring.viewcomponent.jte.JteViewComponentCompiler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002()B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0013H\u0002J&\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u0007J\f\u0010$\u001a\u00020\n*\u00020\nH\u0002J\u001a\u0010%\u001a\u00020&*\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser;", "", "srcFile", "Ljava/io/File;", "buildType", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "methodList", "", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionMethod;", "viewComponentName", "", "messager", "Ljavax/annotation/processing/Messager;", "(Ljava/io/File;Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;Ljava/util/List;Ljava/lang/String;Ljavax/annotation/processing/Messager;)V", "compileJte", "rootDir", "isLiveReload", "", "resourceDirPath", "Ljava/nio/file/Path;", "resourceHtmlFile", "packagePath", "getCompileDirectory", "getGeneratedSourcesDir", "language", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$Language;", "getHtmxAttribute", "Lkotlin/Pair;", "method", "getLanguage", "getResourceDirPath", "getResourceFile", "resourceDir", "getRootDirAndPackagePath", "parseFile", "parseSrcHtmlFile", "parseViewActionHtmlLine", "writeAll", "", "parsedHtml", "BuildType", "Language", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewComponentParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentParser.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1855#2,2:215\n1549#2:217\n1620#2,3:218\n1#3:221\n*S KotlinDebug\n*F\n+ 1 ViewComponentParser.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser\n*L\n107#1:215,2\n159#1:217\n159#1:218,3\n*E\n"})
public final class ViewComponentParser {
    @NotNull
    private final File srcFile;
    @NotNull
    private final BuildType buildType;
    @NotNull
    private final List<ViewActionMethod> methodList;
    @NotNull
    private final String viewComponentName;
    @Nullable
    private final Messager messager;

    public ViewComponentParser(@NotNull File srcFile, @NotNull BuildType buildType, @NotNull List<ViewActionMethod> methodList, @NotNull String viewComponentName, @Nullable Messager messager) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)((Object)buildType), (String)"buildType");
        Intrinsics.checkNotNullParameter(methodList, (String)"methodList");
        Intrinsics.checkNotNullParameter((Object)viewComponentName, (String)"viewComponentName");
        this.srcFile = srcFile;
        this.buildType = buildType;
        this.methodList = methodList;
        this.viewComponentName = viewComponentName;
        this.messager = messager;
    }

    public /* synthetic */ ViewComponentParser(File file, BuildType buildType, List list, String string, Messager messager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            messager = null;
        }
        this(file, buildType, list, string, messager);
    }

    @Nullable
    public final String parseFile(boolean isLiveReload) {
        List<String> parsedHtml = this.parseSrcHtmlFile();
        Pair<String, String> pair = this.getRootDirAndPackagePath(this.srcFile, this.messager);
        String rootDir = (String)pair.component1();
        String packagePath = (String)pair.component2();
        Path resourceDirPath = this.getResourceDirPath(rootDir, packagePath);
        File resourceHtmlFile = this.getResourceFile(resourceDirPath);
        this.writeAll(resourceHtmlFile, parsedHtml);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)resourceHtmlFile), (Object)"jte") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)resourceHtmlFile), (Object)"kte")) {
            return this.compileJte(rootDir, isLiveReload, resourceDirPath, resourceHtmlFile, packagePath);
        }
        return null;
    }

    private final String compileJte(String rootDir, boolean isLiveReload, Path resourceDirPath, File resourceHtmlFile, String packagePath) {
        JteViewComponentCompiler compiler = new JteViewComponentCompiler();
        String string = FileSystems.getDefault().getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().separator");
        String it = StringsKt.replace$default((String)packagePath, (String)string, (String)".", (boolean)false, (int)4, null);
        boolean bl = false;
        String string2 = it.substring(0, it.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String packageName = string2;
        Language language = this.getLanguage(resourceHtmlFile);
        if (!isLiveReload) {
            Path classDir = this.getGeneratedSourcesDir(rootDir, language);
            Path path = resourceDirPath.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resourceDirPath.toAbsolutePath()");
            String string3 = this.srcFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"srcFile.name");
            String file = compiler.generate(path, string3, CollectionsKt.listOf((Object)((Object)classDir.toAbsolutePath()).toString()), packageName);
            resourceHtmlFile.delete();
            return file;
        }
        resourceHtmlFile.delete();
        return null;
    }

    private final String getCompileDirectory(File resourceHtmlFile, String rootDir) {
        if (this.buildType == BuildType.GRADLE) {
            Language language = this.getLanguage(resourceHtmlFile);
            String[] stringArray = new String[]{"build", "classes", language.getDirectoryName(), "main"};
            return ((Object)FileSystems.getDefault().getPath(rootDir, stringArray).toAbsolutePath()).toString();
        }
        String[] stringArray = new String[]{"target", "classes"};
        return ((Object)FileSystems.getDefault().getPath(rootDir, stringArray).toAbsolutePath()).toString();
    }

    private final Language getLanguage(File resourceHtmlFile) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)resourceHtmlFile), (Object)"kte") ? Language.KOTLIN : Language.JAVA;
    }

    private final void writeAll(File $this$writeAll, List<String> parsedHtml) {
        File file = $this$writeAll;
        Charset charset = Charsets.UTF_8;
        File file2 = file;
        int n = 8192;
        Object object = file2;
        PrintWriter writer = new PrintWriter((object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
        Iterable $this$forEach$iv = parsedHtml;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            writer.println(it);
        }
        writer.flush();
        writer.close();
    }

    private final Path getResourceDirPath(String rootDir, String packagePath) {
        Path path;
        if (this.buildType == BuildType.GRADLE) {
            String[] stringArray = new String[]{"build", "resources", "main", packagePath};
            Path path2 = FileSystems.getDefault().getPath(rootDir, stringArray);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n        FileSystems.ge\u2026main\", packagePath)\n    }");
        } else {
            String[] stringArray = new String[]{"target", "classes", packagePath};
            Path path3 = FileSystems.getDefault().getPath(rootDir, stringArray);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"{\n        FileSystems.ge\u2026sses\", packagePath)\n    }");
        }
        return path;
    }

    private final Path getGeneratedSourcesDir(String rootDir, Language language) {
        Path path;
        if (this.buildType == BuildType.GRADLE && language == Language.KOTLIN) {
            String[] stringArray = new String[]{"build", "generated", "source", "kapt", "main"};
            Path path2 = FileSystems.getDefault().getPath(rootDir, stringArray);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n            FileSystem\u2026\"kapt\", \"main\")\n        }");
        } else if (this.buildType == BuildType.GRADLE && language == Language.JAVA) {
            String[] stringArray = new String[]{"build", "generated", "sources", "annotationProcessor", "java", "main"};
            Path path3 = FileSystems.getDefault().getPath(rootDir, stringArray);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"{\n            FileSystem\u2026\"java\", \"main\")\n        }");
        } else {
            String[] stringArray = new String[]{"target", "generated-sources", "annotations"};
            Path path4 = FileSystems.getDefault().getPath(rootDir, stringArray);
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"{\n            FileSystem\u2026 \"annotations\")\n        }");
        }
        return path;
    }

    private final File getResourceFile(Path resourceDir) {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(resourceDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        File resourceHtmlFile = resourceDir.resolve(this.srcFile.getName()).toFile();
        if (resourceHtmlFile.exists()) {
            resourceHtmlFile.delete();
        }
        resourceHtmlFile.createNewFile();
        Intrinsics.checkNotNullExpressionValue((Object)resourceHtmlFile, (String)"resourceHtmlFile");
        return resourceHtmlFile;
    }

    private final Pair<String, String> getRootDirAndPackagePath(File srcFile, Messager messager) {
        List list;
        String[] stringArray;
        String seperator = FileSystems.getDefault().getSeparator();
        String srcMain = "src" + seperator + "main" + seperator;
        String string = srcFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcFile.path");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)(srcMain + "kotlin"), (boolean)false, (int)2, null)) {
            String string2 = srcFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"srcFile.path");
            stringArray = new String[]{srcMain + "kotlin"};
            list = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            String string3 = srcFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"srcFile.path");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)(srcMain + "java"), (boolean)false, (int)2, null)) {
                String string4 = srcFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"srcFile.path");
                stringArray = new String[]{srcMain + "java"};
                list = StringsKt.split$default((CharSequence)string4, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                Messager messager2 = messager;
                if (messager2 != null) {
                    messager2.printMessage(Diagnostic.Kind.ERROR, "No src main found");
                }
                throw new ViewComponentProcessingException("No src main found", null);
            }
        }
        List list2 = list;
        Object e = list2.get(0);
        CharSequence charSequence = (CharSequence)list2.get(1);
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)srcFile.getName(), (String)"srcFile.name");
        return TuplesKt.to(e, StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> parseSrcHtmlFile() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = FilesKt.readLines$default((File)this.srcFile, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String newLine;
            void htmlLine;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.contains$default((CharSequence)((CharSequence)htmlLine), (CharSequence)"<body", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)htmlLine, (String)"<body", (String)("<body id=\"" + this.viewComponentName + "\""), (boolean)false, (int)4, null) : (StringsKt.contains$default((CharSequence)((CharSequence)htmlLine), (CharSequence)"view:action", (boolean)false, (int)2, null) ? (newLine = this.parseViewActionHtmlLine((String)htmlLine)) : htmlLine));
        }
        return (List)destination$iv$iv;
    }

    private final String parseViewActionHtmlLine(String $this$parseViewActionHtmlLine) {
        Object v7;
        String methodName;
        String afterViewActionAttrVal;
        String viewActionAttrValue;
        String beforeViewAction;
        block7: {
            String string;
            String[] stringArray = new String[]{"view:action=\""};
            beforeViewAction = (String)StringsKt.split$default((CharSequence)$this$parseViewActionHtmlLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            String[] stringArray2 = new String[]{"view:action=\""};
            CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)$this$parseViewActionHtmlLine, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray2 = new String[]{"\""};
            viewActionAttrValue = (String)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0);
            String[] stringArray3 = new String[]{"view:action=\""};
            CharSequence charSequence2 = (CharSequence)StringsKt.split$default((CharSequence)$this$parseViewActionHtmlLine, (String[])stringArray3, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray3 = new String[]{"\""};
            afterViewActionAttrVal = (String)StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray3, (boolean)false, (int)0, (int)6, null).get(1);
            if (StringsKt.contains$default((CharSequence)viewActionAttrValue, (CharSequence)"?", (boolean)false, (int)2, null)) {
                if (StringsKt.startsWith$default((String)viewActionAttrValue, (String)"|", (boolean)false, (int)2, null)) {
                    String string2 = viewActionAttrValue.substring(1, StringsKt.indexOf$default((CharSequence)viewActionAttrValue, (String)"?", (int)0, (boolean)false, (int)6, null));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    String string3 = viewActionAttrValue.substring(0, StringsKt.indexOf$default((CharSequence)viewActionAttrValue, (String)"?", (int)0, (boolean)false, (int)6, null));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                }
            } else {
                string = viewActionAttrValue;
            }
            methodName = string;
            Iterable iterable = this.methodList;
            for (Object t : iterable) {
                ViewActionMethod it = (ViewActionMethod)t;
                boolean bl = false;
                String string4 = it.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String string5 = methodName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!Intrinsics.areEqual((Object)string4, (Object)string5)) continue;
                v7 = t;
                break block7;
            }
            v7 = null;
        }
        ViewActionMethod viewActionMethod = v7;
        if (viewActionMethod == null) {
            String it = $this$parseViewActionHtmlLine;
            boolean bl = false;
            Messager messager = this.messager;
            if (messager != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, "viewAction method " + methodName + " does not exist");
            }
            throw new ViewComponentProcessingException("viewAction method " + methodName + " does not exist", null);
        }
        ViewActionMethod method = viewActionMethod;
        Pair<String, String> pair = this.getHtmxAttribute(this.viewComponentName, method, this.messager);
        String htmxAttr = (String)pair.component1();
        String path = (String)pair.component2();
        String htmxAttrVal = StringsKt.replace((String)viewActionAttrValue, (String)methodName, (String)path, (boolean)true);
        return beforeViewAction + htmxAttr + "\"" + htmxAttrVal + "\" hx-target=\"#" + this.viewComponentName + "\"" + afterViewActionAttrVal;
    }

    private final Pair<String, String> getHtmxAttribute(String viewComponentName, ViewActionMethod method, Messager messager) {
        Pair pair;
        String action = Intrinsics.areEqual((Object)method.getPath(), (Object)"") ? "/" + viewComponentName + "/" + method.getName() : method.getPath();
        Class<?> clazz = method.getClazz();
        if (Intrinsics.areEqual(clazz, GetViewAction.class)) {
            String string = action.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)"hx-get=", (Object)string);
        } else if (Intrinsics.areEqual(clazz, PostViewAction.class)) {
            String string = action.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)"hx-post=", (Object)string);
        } else if (Intrinsics.areEqual(clazz, PutViewAction.class)) {
            String string = action.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)"hx-put=", (Object)string);
        } else if (Intrinsics.areEqual(clazz, PatchViewAction.class)) {
            String string = action.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)"hx-patch=", (Object)string);
        } else if (Intrinsics.areEqual(clazz, DeleteViewAction.class)) {
            String string = action.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)"hx-delete=", (Object)string);
        } else {
            ViewComponentParser it = this;
            boolean bl = false;
            Messager messager2 = messager;
            if (messager2 != null) {
                messager2.printMessage(Diagnostic.Kind.ERROR, "No annotation found on " + viewComponentName);
            }
            throw new ViewComponentProcessingException("No annotation found on " + viewComponentName, null);
        }
        return pair;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "", "(Ljava/lang/String;I)V", "MAVEN", "GRADLE", "spring-view-component-core"})
    public static final class BuildType
    extends Enum<BuildType> {
        public static final /* enum */ BuildType MAVEN = new BuildType();
        public static final /* enum */ BuildType GRADLE = new BuildType();
        private static final /* synthetic */ BuildType[] $VALUES;

        public static BuildType[] values() {
            return (BuildType[])$VALUES.clone();
        }

        public static BuildType valueOf(String value) {
            return Enum.valueOf(BuildType.class, value);
        }

        static {
            $VALUES = buildTypeArray = new BuildType[]{BuildType.MAVEN, BuildType.GRADLE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$Language;", "", "directoryName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDirectoryName", "()Ljava/lang/String;", "KOTLIN", "JAVA", "spring-view-component-core"})
    public static final class Language
    extends Enum<Language> {
        @NotNull
        private final String directoryName;
        public static final /* enum */ Language KOTLIN = new Language("kotlin");
        public static final /* enum */ Language JAVA = new Language("java");
        private static final /* synthetic */ Language[] $VALUES;

        private Language(String directoryName) {
            this.directoryName = directoryName;
        }

        @NotNull
        public final String getDirectoryName() {
            return this.directoryName;
        }

        public static Language[] values() {
            return (Language[])$VALUES.clone();
        }

        public static Language valueOf(String value) {
            return Enum.valueOf(Language.class, value);
        }

        static {
            $VALUES = languageArray = new Language[]{Language.KOTLIN, Language.JAVA};
        }
    }
}

