/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core;

import de.tschuehly.spring.viewcomponent.core.component.ViewComponent;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"de.tschuehly.spring.viewcomponent.core"})
@EnableConfigurationProperties(value={ViewComponentProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration;", "", "()V", "LocalDevConfig", "spring-view-component-core"})
public class ViewComponentAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"spring.view-component.local-development"})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$LocalDevConfig;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "viewComponentFileSystemWatcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "spring-view-component-core"})
    @SourceDebugExtension(value={"SMAP\nViewComponentAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentAutoConfiguration.kt\nde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$LocalDevConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1549#2:54\n1620#2,3:55\n*S KotlinDebug\n*F\n+ 1 ViewComponentAutoConfiguration.kt\nde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$LocalDevConfig\n*L\n33#1:54\n33#1:55,3\n*E\n"})
    public static class LocalDevConfig {
        @NotNull
        private final Logger logger;

        public LocalDevConfig() {
            Logger logger = LoggerFactory.getLogger(LocalDevConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
        }

        @NotNull
        public Logger getLogger() {
            return this.logger;
        }

        /*
         * WARNING - void declaration
         */
        @Bean
        @NotNull
        public FileSystemWatcher viewComponentFileSystemWatcher(@NotNull ApplicationContext applicationContext, @NotNull ViewComponentProperties viewComponentProperties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
            FileSystemWatcher fileSystemWatcher = new FileSystemWatcher();
            Iterable $this$map$iv = applicationContext.getBeansWithAnnotation(ViewComponent.class).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
            }
            String buildDir = (String)CollectionsKt.first((List)((List)destination$iv$iv));
            File viewComponentDirectory = new File(viewComponentProperties.getViewComponentRoot());
            File templateRoot = new File(viewComponentProperties.getStandaloneTemplateRoot());
            fileSystemWatcher.addSourceDirectory(viewComponentDirectory);
            fileSystemWatcher.addSourceDirectory(templateRoot);
            this.getLogger().info("Watching for template changes at: " + viewComponentDirectory.getAbsoluteFile().getPath());
            this.getLogger().info("Watching for template changes at: " + templateRoot.getAbsoluteFile().getPath());
            fileSystemWatcher.addListener((FileChangeListener)new ViewComponentChangeListener(applicationContext));
            fileSystemWatcher.start();
            return fileSystemWatcher;
        }
    }
}

