/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.jte;

import de.tschuehly.spring.viewcomponent.core.ViewComponentAutoConfiguration;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentException;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.jte.JteViewContextAspect;
import de.tschuehly.spring.viewcomponent.jte.ViewComponentCodeResolver;
import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.springframework.boot.autoconfigure.JteViewResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={ViewComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ViewComponentProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/tschuehly/spring/viewcomponent/jte/JteViewComponentAutoConfiguration;", "", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "(Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;)V", "jteTemplateEngine", "Lgg/jte/TemplateEngine;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "jteViewComponentResolver", "Lgg/jte/springframework/boot/autoconfigure/JteViewResolver;", "templateEngine", "jteViewContextAspect", "Lde/tschuehly/spring/viewcomponent/jte/JteViewContextAspect;", "spring-view-component-jte"})
public class JteViewComponentAutoConfiguration {
    @NotNull
    private final ViewComponentProperties viewComponentProperties;

    public JteViewComponentAutoConfiguration(@NotNull ViewComponentProperties viewComponentProperties) {
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        this.viewComponentProperties = viewComponentProperties;
    }

    @Bean
    @NotNull
    public JteViewContextAspect jteViewContextAspect(@NotNull TemplateEngine templateEngine) {
        Intrinsics.checkNotNullParameter((Object)templateEngine, (String)"templateEngine");
        return new JteViewContextAspect(templateEngine, this.viewComponentProperties);
    }

    @Bean
    @NotNull
    public JteViewResolver jteViewComponentResolver(@NotNull TemplateEngine templateEngine) {
        Intrinsics.checkNotNullParameter((Object)templateEngine, (String)"templateEngine");
        if (!StringUtils.hasText((String)this.viewComponentProperties.getJteTemplateSuffix())) {
            throw new ViewComponentException("You need to set jteTemplateSuffix");
        }
        return new JteViewResolver(templateEngine, this.viewComponentProperties.getJteTemplateSuffix());
    }

    @Bean
    @NotNull
    public TemplateEngine jteTemplateEngine(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (this.viewComponentProperties.getLocalDevelopment()) {
            TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new ViewComponentCodeResolver(applicationContext, this.viewComponentProperties.getJteTemplateDirectories()), (Path)Paths.get("jte-classes", new String[0]), (ContentType)ContentType.Html, (ClassLoader)applicationContext.getClassLoader());
            Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"create(...)");
            return templateEngine;
        }
        TemplateEngine templateEngine = TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
        Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"createPrecompiled(...)");
        return templateEngine;
    }
}

