/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.jte;

import de.tschuehly.spring.viewcomponent.core.component.ViewComponent;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentChangeListener;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import gg.jte.CodeResolver;
import gg.jte.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/tschuehly/spring/viewcomponent/jte/ViewComponentCodeResolver;", "Lgg/jte/CodeResolver;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "templateDirectories", "", "", "(Lorg/springframework/context/ApplicationContext;Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getBuildType", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "filePath", "getLastModified", "", "file", "Ljava/io/File;", "name", "resolve", "resolveFile", "resolveRequired", "spring-view-component-jte"})
@SourceDebugExtension(value={"SMAP\nViewComponentCodeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentCodeResolver.kt\nde/tschuehly/spring/viewcomponent/jte/ViewComponentCodeResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n526#2:94\n511#2,6:95\n1549#3:101\n1620#3,3:102\n223#3,2:105\n*S KotlinDebug\n*F\n+ 1 ViewComponentCodeResolver.kt\nde/tschuehly/spring/viewcomponent/jte/ViewComponentCodeResolver\n*L\n39#1:94\n39#1:95,6\n60#1:101\n60#1:102,3\n64#1:105,2\n*E\n"})
public final class ViewComponentCodeResolver
implements CodeResolver {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final List<String> templateDirectories;
    private final Logger logger;

    public ViewComponentCodeResolver(@NotNull ApplicationContext applicationContext, @NotNull List<String> templateDirectories) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(templateDirectories, (String)"templateDirectories");
        this.applicationContext = applicationContext;
        this.templateDirectories = templateDirectories;
        this.logger = LoggerFactory.getLogger(ViewComponentCodeResolver.class);
    }

    @Nullable
    public String resolve(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            string = this.resolveRequired(name);
        }
        catch (TemplateNotFoundException e) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String resolveRequired(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File path = this.resolveFile(name);
        try {
            Class<?> clazz;
            void $this$filterTo$iv$iv;
            Map map = this.applicationContext.getBeansWithAnnotation(ViewComponent.class);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansWithAnnotation(...)");
            Map $this$filter$iv = map;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                String string = ((String)k).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String string2 = FilesKt.getNameWithoutExtension((File)path).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Object bean = CollectionsKt.first((Iterable)destination$iv$iv.values());
            if (AopUtils.isAopProxy((Object)bean) && bean instanceof Advised) {
                Object object = ((Advised)bean).getTargetSource().getTarget();
                Intrinsics.checkNotNull((Object)object);
                clazz = object.getClass();
            } else {
                clazz = bean.getClass();
            }
            Class<?> javaClass = clazz;
            String string = javaClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            ViewComponentParser.BuildType buildType = this.getBuildType(string);
            List methodList = ViewComponentChangeListener.Companion.getViewActionMethods(javaClass);
            String string3 = javaClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSimpleName(...)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            ViewComponentParser parser = new ViewComponentParser(path, buildType, methodList, string4, null, 16, null);
            return CollectionsKt.joinToString$default((Iterable)parser.parseSrcHtmlFile(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File resolveFile(String name) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.templateDirectories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)it, new String[0]).resolve(name).toFile().getAbsoluteFile());
        }
        List files = (List)destination$iv$iv;
        try {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = files;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    File it = (File)element$iv2;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            Intrinsics.checkNotNullExpressionValue(t, (String)"first(...)");
            return (File)t;
        }
        catch (NoSuchElementException e) {
            String message = name + " not found (tried to load file at " + files + "})";
            this.logger.debug(message);
            throw new TemplateNotFoundException(message);
        }
    }

    private final ViewComponentParser.BuildType getBuildType(String filePath) {
        if (StringsKt.contains$default((CharSequence)filePath, (CharSequence)"target", (boolean)false, (int)2, null)) {
            return ViewComponentParser.BuildType.MAVEN;
        }
        if (StringsKt.contains$default((CharSequence)filePath, (CharSequence)"build", (boolean)false, (int)2, null)) {
            return ViewComponentParser.BuildType.GRADLE;
        }
        throw new ViewComponentProcessingException("No build or target folder found", null);
    }

    public long getLastModified(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getLastModified(this.resolveFile(name));
    }

    private final long getLastModified(File file) {
        return file.lastModified();
    }
}

