/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.thymeleaf;

import de.tschuehly.spring.viewcomponent.core.ViewComponentAutoConfiguration;
import de.tschuehly.spring.viewcomponent.core.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.thymeleaf.ThymeleafViewComponentDialect;
import de.tschuehly.spring.viewcomponent.thymeleaf.ThymeleafViewContextContainerMethodReturnValueHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@Import(value={ViewComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ViewComponentProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u0014"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentAutoConfiguration;", "", "()V", "fileViewComponentTemplateResolver", "Lorg/thymeleaf/templateresolver/FileTemplateResolver;", "templateEngine", "Lorg/thymeleaf/spring6/SpringTemplateEngine;", "properties", "Lorg/springframework/boot/autoconfigure/thymeleaf/ThymeleafProperties;", "templateResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/thymeleaf/templateresolver/ITemplateResolver;", "dialects", "Lorg/thymeleaf/dialect/IDialect;", "thymeleafViewContextContainerMethodReturnValueHandler", "Lorg/springframework/web/method/support/HandlerMethodReturnValueHandler;", "thymeleafViewResolver", "Lorg/thymeleaf/spring6/view/ThymeleafViewResolver;", "viewComponentTemplateResolver", "Lorg/thymeleaf/templateresolver/ClassLoaderTemplateResolver;", "spring-view-component-thymeleaf"})
public class ThymeleafViewComponentAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SpringTemplateEngine.class})
    @NotNull
    public SpringTemplateEngine templateEngine(@NotNull ThymeleafProperties properties, @NotNull ObjectProvider<ITemplateResolver> templateResolvers, @NotNull ObjectProvider<IDialect> dialects) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(templateResolvers, (String)"templateResolvers");
        Intrinsics.checkNotNullParameter(dialects, (String)"dialects");
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setEnableSpringELCompiler(properties.isEnableSpringElCompiler());
        engine.setRenderHiddenMarkersBeforeCheckboxes(properties.isRenderHiddenMarkersBeforeCheckboxes());
        templateResolvers.orderedStream().forEach(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$0((Function1)new Function1<ITemplateResolver, Unit>(engine){
            final /* synthetic */ SpringTemplateEngine $engine;
            {
                this.$engine = $engine;
                super(1);
            }

            public final void invoke(ITemplateResolver templateResolver) {
                this.$engine.addTemplateResolver(templateResolver);
            }
        }, arg_0));
        dialects.orderedStream().forEach(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$1((Function1)new Function1<IDialect, Unit>(engine){
            final /* synthetic */ SpringTemplateEngine $engine;
            {
                this.$engine = $engine;
                super(1);
            }

            public final void invoke(@Nullable IDialect dialect) {
                this.$engine.addDialect(dialect);
            }
        }, arg_0));
        engine.addDialect((IDialect)new ThymeleafViewComponentDialect());
        return engine;
    }

    @Bean
    @ConditionalOnProperty(value={"viewcomponent.localDevelopment"})
    @NotNull
    public FileTemplateResolver fileViewComponentTemplateResolver() {
        FileTemplateResolver fileViewComponentTemplateResolver = new FileTemplateResolver();
        if (new File("src/main/kotlin").isDirectory()) {
            fileViewComponentTemplateResolver.setPrefix("src/main/kotlin/");
        }
        if (new File("src/main/java").isDirectory()) {
            fileViewComponentTemplateResolver.setPrefix("src/main/java/");
        }
        fileViewComponentTemplateResolver.setSuffix(".html");
        fileViewComponentTemplateResolver.setTemplateMode(TemplateMode.HTML);
        fileViewComponentTemplateResolver.setCacheable(false);
        fileViewComponentTemplateResolver.setCharacterEncoding("UTF-8");
        fileViewComponentTemplateResolver.setOrder(Integer.valueOf(1));
        fileViewComponentTemplateResolver.setCheckExistence(true);
        return fileViewComponentTemplateResolver;
    }

    @Bean
    @NotNull
    public ClassLoaderTemplateResolver viewComponentTemplateResolver() {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix("");
        templateResolver.setSuffix(".html");
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setCharacterEncoding("UTF-8");
        templateResolver.setOrder(Integer.valueOf(1));
        templateResolver.setCheckExistence(true);
        return templateResolver;
    }

    @Bean
    @NotNull
    public HandlerMethodReturnValueHandler thymeleafViewContextContainerMethodReturnValueHandler(@NotNull ThymeleafViewResolver thymeleafViewResolver) {
        Intrinsics.checkNotNullParameter((Object)thymeleafViewResolver, (String)"thymeleafViewResolver");
        return new ThymeleafViewContextContainerMethodReturnValueHandler(thymeleafViewResolver);
    }

    private static final void templateEngine$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void templateEngine$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

