/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.thymeleaf;

import de.tschuehly.spring.viewcomponent.core.IViewContext;
import de.tschuehly.spring.viewcomponent.thymeleaf.ThymeleafViewComponentException;
import de.tschuehly.spring.viewcomponent.thymeleaf.ViewComponentExpressionException;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.View;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.templatemode.TemplateMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor;", "Lorg/thymeleaf/processor/element/AbstractAttributeTagProcessor;", "dialectPrefix", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Ljava/lang/String;Lorg/springframework/context/ApplicationContext;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "doProcess", "", "context", "Lorg/thymeleaf/context/ITemplateContext;", "tag", "Lorg/thymeleaf/model/IProcessableElementTag;", "attributeName", "Lorg/thymeleaf/engine/AttributeName;", "attributeValue", "structureHandler", "Lorg/thymeleaf/processor/element/IElementTagStructureHandler;", "Companion", "spring-view-component-thymeleaf"})
@SourceDebugExtension(value={"SMAP\nThymeleafViewComponentTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThymeleafViewComponentTagProcessor.kt\nde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class ThymeleafViewComponentTagProcessor
extends AbstractAttributeTagProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    private final Logger logger;
    @NotNull
    public static final String ATTR_NAME = "component";
    public static final int PRECEDENCE = 10000;

    public ThymeleafViewComponentTagProcessor(@NotNull String dialectPrefix, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)dialectPrefix, (String)"dialectPrefix");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 10000, true);
        this.applicationContext = applicationContext;
        this.logger = LoggerFactory.getLogger(ThymeleafViewComponentTagProcessor.class);
    }

    /*
     * WARNING - void declaration
     */
    protected void doProcess(@NotNull ITemplateContext context, @NotNull IProcessableElementTag tag, @NotNull AttributeName attributeName, @NotNull String attributeValue, @NotNull IElementTagStructureHandler structureHandler) {
        String string;
        Object object;
        View viewName;
        IViewContext iViewContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        Intrinsics.checkNotNullParameter((Object)structureHandler, (String)"structureHandler");
        IStandardExpression expression = EngineEventUtils.computeAttributeExpression((ITemplateContext)context, (IProcessableElementTag)tag, (AttributeName)attributeName, (String)attributeValue);
        WebEngineContext webContext = (WebEngineContext)context;
        try {
            Object object2 = expression.execute((IExpressionContext)webContext);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.IViewContext");
            iViewContext = (IViewContext)object2;
        }
        catch (ClassCastException e) {
            throw new ViewComponentExpressionException("Could not execute expression: \"" + expression.getStringRepresentation() + "\" as ViewContext, did you forget the brackets? ${" + expression.getStringRepresentation() + "}, did you pass \"" + expression.getStringRepresentation() + "\" as ViewContextProperty?");
        }
        catch (Exception e) {
            this.logger.error("Could not execute expression: \"" + expression.getStringRepresentation() + "\"");
            throw new ThymeleafViewComponentException(e.getMessage(), e.getCause());
        }
        IViewContext viewContext = iViewContext;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Object object3 = servletRequestAttributes != null ? servletRequestAttributes.getResponse() : null;
        Intrinsics.checkNotNull((Object)object3);
        HttpServletResponse response = object3;
        ContentCachingResponseWrapper wrapper = new ContentCachingResponseWrapper(response);
        Object object4 = this.applicationContext.getBean(ThymeleafViewResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getBean(...)");
        ThymeleafViewResolver thymeleafViewResolver = (ThymeleafViewResolver)object4;
        View view = thymeleafViewResolver.resolveViewName(IViewContext.Companion.getViewComponentTemplateWithoutSuffix(viewContext), webContext.getLocale());
        if (view == null) {
            throw new ThymeleafViewComponentException("No ViewName", null);
        }
        View view2 = viewName = view;
        String string2 = viewContext.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            View view3 = view2;
            boolean bl = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            String string6 = string5;
            view2 = view3;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
            object = string3;
            int n = 1;
            String string7 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = string3;
        }
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)viewContext));
        ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Object object5 = servletRequestAttributes2 != null ? servletRequestAttributes2.getRequest() : null;
        Intrinsics.checkNotNull((Object)object5);
        view2.render(map, object5, (HttpServletResponse)wrapper);
        IModelFactory iModelFactory = webContext.getModelFactory();
        byte[] byArray = wrapper.getContentAsByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContentAsByteArray(...)");
        object = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        IText viewComponentBody = iModelFactory.createText((CharSequence)new String((byte[])object, charset2));
        structureHandler.replaceWith((CharSequence)viewComponentBody, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor$Companion;", "", "()V", "ATTR_NAME", "", "PRECEDENCE", "", "spring-view-component-thymeleaf"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

