/*
 * Decompiled with CFR 0.152.
 */
package de.tschumacher.simplestatemachine;

import de.tschumacher.simplestatemachine.SimpleStateMachine;
import de.tschumacher.simplestatemachine.configuration.SimpleStateMachineConfig;
import de.tschumacher.simplestatemachine.configuration.state.StateConfiguration;
import de.tschumacher.simplestatemachine.exception.TransitionNotAllowedException;
import de.tschumacher.simplestatemachine.handler.StateChangeHandler;

public class DefaultSimpleStateMachine<State, Context, ContextService>
implements SimpleStateMachine<State, Context, ContextService> {
    private final SimpleStateMachineConfig<State, Context, ContextService> config;
    private State actualState;

    public DefaultSimpleStateMachine(SimpleStateMachineConfig<State, Context, ContextService> config, State actualState) {
        this.config = config;
        this.actualState = actualState;
    }

    @Override
    public Context change(State newState, Context context, ContextService contextService) {
        StateConfiguration<State, Context, ContextService> actualStateConfig = this.config.fetch(this.actualState);
        if (actualStateConfig == null || !actualStateConfig.transitionAllowed(newState)) {
            throw new TransitionNotAllowedException();
        }
        this.actualState = newState;
        StateChangeHandler<Context, ContextService> handler = actualStateConfig.handler(newState);
        if (handler != null) {
            return handler.handle(context, contextService);
        }
        return context;
    }

    @Override
    public Context change(State newState) {
        return this.change(newState, null, null);
    }

    @Override
    public Context change(State newState, Context context) {
        return this.change(newState, context, null);
    }

    @Override
    public boolean transitionAllowed(State newState) {
        StateConfiguration<State, Context, ContextService> actualStateConfig = this.config.fetch(this.actualState);
        return actualStateConfig != null && actualStateConfig.transitionAllowed(newState);
    }
}

