/*
 * Decompiled with CFR 0.152.
 */
package de.tschumacher.simplestatemachine;

import de.tschumacher.simplestatemachine.SimpleStateMachine;
import de.tschumacher.simplestatemachine.configuration.SimpleStateMachineConfig;
import de.tschumacher.simplestatemachine.configuration.state.StateConfiguration;
import de.tschumacher.simplestatemachine.domain.StateChange;
import de.tschumacher.simplestatemachine.exception.TransitionNotAllowedException;
import de.tschumacher.simplestatemachine.handler.StateChangeHandler;

public class DefaultSimpleStateMachine<State, Context>
implements SimpleStateMachine<State, Context> {
    private final SimpleStateMachineConfig<State, Context> config;
    private State actualState;

    public DefaultSimpleStateMachine(SimpleStateMachineConfig<State, Context> config, State actualState) {
        this.config = config;
        this.actualState = actualState;
    }

    @Override
    public Context change(State newState) {
        return this.change(newState, null);
    }

    @Override
    public Context change(State newState, Context context) {
        StateChange<State> stateChange = new StateChange<State>(this.actualState, newState);
        StateConfiguration<State, Context> actualStateConfig = this.config.fetch(this.actualState);
        if (actualStateConfig == null || !actualStateConfig.transitionAllowed(newState)) {
            throw new TransitionNotAllowedException();
        }
        this.actualState = newState;
        StateChangeHandler<State, Context> handler = actualStateConfig.handler(newState);
        if (handler != null) {
            return handler.handle(stateChange, context);
        }
        return context;
    }

    @Override
    public boolean transitionAllowed(State newState) {
        StateConfiguration<State, Context> actualStateConfig = this.config.fetch(this.actualState);
        return actualStateConfig != null && actualStateConfig.transitionAllowed(newState);
    }
}

