/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Abort;
import channels.ArrayMessageBuffer;
import channels.ArrayMessageBuffer$;
import channels.Connection;
import channels.JavaHttp$;
import channels.JioOutputStreamAdapter;
import channels.LatentConnection;
import channels.MessageBuffer;
import channels.Receive;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpHandler;
import de.rmgk.delay;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import rdts.base.LocalUid;
import rdts.base.Uid;
import rdts.base.Uid$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class JavaHttp {
    public static String replicaIdHeader() {
        return JavaHttp$.MODULE$.replicaIdHeader();
    }

    public static class IncorrectSetupException
    extends Exception {
    }

    public static class SSEClient
    implements LatentConnection<MessageBuffer> {
        private final HttpClient client;
        private final URI uri;
        private final LocalUid replicaId;
        private final ExecutionContext ec;

        public SSEClient(HttpClient client, URI uri, LocalUid replicaId, ExecutionContext ec) {
            this.client = client;
            this.uri = uri;
            this.replicaId = replicaId;
            this.ec = ec;
        }

        @Override
        public delay.Async<Abort, Connection<MessageBuffer>> prepare(Receive<MessageBuffer> receiver) {
            return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                try {
                    HttpRequest sseRequest = HttpRequest.newBuilder().GET().uri(this.uri).setHeader(JavaHttp$.MODULE$.replicaIdHeader(), this.replicaId.uid().delegate()).setHeader("Accept", "text/event-stream").build();
                    Predef$.MODULE$.println((Object)"sending client request");
                    delay.Async async = new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                        delay.Callback callback = arg_0 -> this.$anonfun$4$$anonfun$1$$anonfun$1(receiver, cb, arg_0);
                        this.client.sendAsync(sseRequest, HttpResponse.BodyHandlers.ofInputStream()).whenComplete((arg_0, arg_1) -> JavaHttp$.channels$JavaHttp$SSEClient$$_$$anonfun$4$$anonfun$1$$anonfun$2(callback, arg_0, arg_1));
                    });
                    ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e)) {
                        delay.Callback Callback_this = cb;
                        Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                    }
                    throw throwable;
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        private final /* synthetic */ void $anonfun$4$$anonfun$1$$anonfun$1(Receive receiver$9, delay.Callback cb$4, Try res) {
            try {
                res = var4_4 = (HttpResponse)res.get();
                rec = (InputStream)res.body();
                Predef$.MODULE$.println((Object)"acquired body");
                conn = new SSEClientConnection(this.client, this.uri, this.replicaId);
                this.ec.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, channels$JavaHttp$SSEClient$$_$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(java.io.InputStream channels.Receive channels.JavaHttp$SSEClientConnection ), ()V)((InputStream)rec, (Receive)receiver$9, (SSEClientConnection)conn));
                Predef$.MODULE$.println((Object)"succeeding client");
                Callback_this = cb$4;
                Callback_this.complete((Try)Success$.MODULE$.apply((Object)conn));
            }
            catch (Throwable var9_9) {
                block4: {
                    e = var10_10 = var9_9;
                    if (!NonFatal$.MODULE$.apply(e)) break block4;
                    var12_12 = res;
                    if (!(var12_12 instanceof Failure)) ** GOTO lbl-1000
                    v0 = exception = ((Failure)var12_12).exception();
                    var14_14 = e;
                    if (v0 == null ? var14_14 != null : v0.equals(var14_14) == false) {
                        e.addSuppressed(exception);
                        v1 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = other = var12_12;
                    }
                    Callback_this = cb$4;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw var9_9;
            }
        }
    }

    public static class SSEClientConnection
    implements Connection<MessageBuffer> {
        private final HttpClient client;
        private final URI uri;
        private final LocalUid localUid;

        public SSEClientConnection(HttpClient client, URI uri, LocalUid localUid) {
            this.client = client;
            this.uri = uri;
            this.localUid = localUid;
        }

        @Override
        public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
            return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                try {
                    HttpRequest sseRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(message.asArray())).setHeader(JavaHttp$.MODULE$.replicaIdHeader(), this.localUid.uid().delegate()).uri(this.uri).build();
                    delay.Async async = new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                        delay.Callback callback = arg_0 -> JavaHttp$.channels$JavaHttp$SSEClientConnection$$_$$anonfun$3$$anonfun$1$$anonfun$1(cb, arg_0);
                        this.client.sendAsync(sseRequest, HttpResponse.BodyHandlers.discarding()).whenComplete((arg_0, arg_1) -> JavaHttp$.channels$JavaHttp$SSEClientConnection$$_$$anonfun$3$$anonfun$1$$anonfun$2(callback, arg_0, arg_1));
                    });
                    ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e)) {
                        delay.Callback Callback_this = cb;
                        Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                    }
                    throw throwable;
                }
            });
        }

        @Override
        public void close() {
        }
    }

    public static class SSEServer
    implements LatentConnection<MessageBuffer> {
        private final Function1<HttpHandler, BoxedUnit> addHandler;
        private Map<Uid, delay.Callback<MessageBuffer>> connections;

        public SSEServer(Function1<HttpHandler, BoxedUnit> addHandler) {
            this.addHandler = addHandler;
            this.connections = Predef$.MODULE$.Map().empty();
        }

        public Map<Uid, delay.Callback<MessageBuffer>> connections() {
            return this.connections;
        }

        public void connections_$eq(Map<Uid, delay.Callback<MessageBuffer>> x$1) {
            this.connections = x$1;
        }

        @Override
        public delay.Async<Abort, Connection<MessageBuffer>> prepare(Receive<MessageBuffer> receiver) {
            return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> this.addHandler.apply(exchange -> {
                Uid uid;
                Headers requestHeaders = exchange.getRequestHeaders();
                exchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
                exchange.getResponseHeaders().add("Access-Control-Allow-Methods", "POST, GET");
                exchange.getResponseHeaders().add("Access-Control-Allow-Headers", "x-replica-id");
                Option option = Option$.MODULE$.apply(requestHeaders.get(JavaHttp$.MODULE$.replicaIdHeader())).flatMap(JavaHttp$::channels$JavaHttp$SSEServer$$_$_$$anonfun$2);
                if (None$.MODULE$.equals(option)) {
                    Predef$.MODULE$.println((Object)"no replica ID on request?");
                    uid = Uid$.MODULE$.zero();
                } else if (option instanceof Some) {
                    String rid = (String)((Some)option).value();
                    uid = Uid$.MODULE$.predefined(rid);
                } else {
                    throw new MatchError((Object)option);
                }
                Uid uid2 = uid;
                if (Option$.MODULE$.apply(requestHeaders.get("Accept")).flatMap(JavaHttp$::channels$JavaHttp$SSEServer$$_$prepare$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1).contains((Object)"text/event-stream")) {
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.add("Content-Type", "text/event-stream");
                    responseHeaders.add("Connection", "keep-alive");
                    exchange.sendResponseHeaders(200, 0L);
                    OutputStream outstream = exchange.getResponseBody();
                    outstream.flush();
                    SSEServerConnection conn = new SSEServerConnection(new JioOutputStreamAdapter(outstream));
                    SSEServer sSEServer = this;
                    synchronized (sSEServer) {
                        Predef$.MODULE$.println((Object)("made connection for " + uid2));
                        this.connections_$eq((Map<Uid, delay.Callback<MessageBuffer>>)((Map)this.connections().updated((Object)uid2, receiver.messageHandler(conn))));
                    }
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)conn));
                    return;
                }
                String string = exchange.getRequestMethod();
                String string2 = "POST";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Option option2;
                    SSEServer sSEServer = this;
                    synchronized (sSEServer) {
                        option2 = this.connections().get((Object)uid2);
                    }
                    Option option3 = option2;
                    if (None$.MODULE$.equals(option3)) {
                        Predef$.MODULE$.println((Object)"received message without connection \u2026");
                        delay.Callback Callback_this = cb;
                        IncorrectSetupException ex$proxy1 = new IncorrectSetupException();
                        Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex$proxy1));
                        return;
                    }
                    if (option3 instanceof Some) {
                        delay.Callback cb;
                        delay.Callback Callback_this = cb = (delay.Callback)((Some)option3).value();
                        ArrayMessageBuffer value$proxy1 = ArrayMessageBuffer$.MODULE$.apply(exchange.getRequestBody().readAllBytes());
                        Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy1));
                        exchange.sendResponseHeaders(200, 0L);
                        exchange.close();
                        return;
                    }
                    throw new MatchError((Object)option3);
                }
                exchange.sendResponseHeaders(200, 0L);
                exchange.close();
            }));
        }
    }

    public static class SSEServerConnection
    implements Connection<MessageBuffer> {
        private final JioOutputStreamAdapter out;

        public SSEServerConnection(JioOutputStreamAdapter out) {
            this.out = out;
        }

        @Override
        public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
            return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                try {
                    delay.Sync async = new delay.Sync((Function1)(JProcedure1 & Serializable)x -> this.out.send(message));
                    ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e)) {
                        delay.Callback Callback_this = cb;
                        Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                    }
                    throw throwable;
                }
            });
        }

        @Override
        public void close() {
            this.out.outputStream().close();
        }
    }
}

