/*
 * Decompiled with CFR 0.152.
 */
package channels.tls;

import channels.tls.X509Util$;
import crypto.PublicIdentity;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import scala.Array$;
import scala.reflect.ClassTag$;

public class P2PX509TrustManager
implements X509TrustManager {
    private void verifyP2PCertificate(X509Certificate certificate) {
        if (!"Ed25519".equals(certificate.getSigAlgName())) {
            throw new CertificateException("Only Ed25519 is supported as signature algo");
        }
        if (certificate.getVersion() != 3) {
            throw new CertificateException("Only X509v3 Certificates are supported");
        }
        PublicIdentity id = X509Util$.MODULE$.certificateToPublicIdentity(certificate);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        if (chain.length != 1) {
            throw new CertificateException("Only single entry certificate chain is supported");
        }
        this.verifyP2PCertificate(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        if (chain.length != 1) {
            throw new CertificateException("Only single entry certificate chain is supported");
        }
        this.verifyP2PCertificate(chain[0]);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(X509Certificate.class));
    }
}

