/*
 * Decompiled with CFR 0.152.
 */
package channels.tls;

import channels.tls.PrivateIdentity$;
import channels.tls.X509Util$;
import crypto.CertificatePem;
import crypto.Ed25519Util$;
import crypto.PrivateKeyPem;
import crypto.PublicIdentity;
import crypto.PublicIdentity$;
import java.io.Serializable;
import java.security.KeyPair;
import org.bouncycastle.cert.X509CertificateHolder;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PrivateIdentity
implements Product,
Serializable {
    private final KeyPair identityKey;
    private final KeyPair tlsKey;
    private final X509CertificateHolder certificateHolder;

    public static PrivateIdentity apply(KeyPair keyPair, KeyPair keyPair2, X509CertificateHolder x509CertificateHolder) {
        return PrivateIdentity$.MODULE$.apply(keyPair, keyPair2, x509CertificateHolder);
    }

    public static PrivateIdentity fromProduct(Product product) {
        return PrivateIdentity$.MODULE$.fromProduct(product);
    }

    public static PrivateIdentity unapply(PrivateIdentity privateIdentity) {
        return PrivateIdentity$.MODULE$.unapply(privateIdentity);
    }

    public PrivateIdentity(KeyPair identityKey, KeyPair tlsKey, X509CertificateHolder certificateHolder) {
        this.identityKey = identityKey;
        this.tlsKey = tlsKey;
        this.certificateHolder = certificateHolder;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PrivateIdentity)) return false;
        PrivateIdentity privateIdentity = (PrivateIdentity)object;
        KeyPair keyPair = this.identityKey();
        KeyPair keyPair2 = privateIdentity.identityKey();
        if (keyPair == null) {
            if (keyPair2 != null) {
                return false;
            }
        } else if (!keyPair.equals(keyPair2)) return false;
        KeyPair keyPair3 = this.tlsKey();
        KeyPair keyPair4 = privateIdentity.tlsKey();
        if (keyPair3 == null) {
            if (keyPair4 != null) {
                return false;
            }
        } else if (!keyPair3.equals(keyPair4)) return false;
        X509CertificateHolder x509CertificateHolder = this.certificateHolder();
        X509CertificateHolder x509CertificateHolder2 = privateIdentity.certificateHolder();
        if (x509CertificateHolder == null) {
            if (x509CertificateHolder2 != null) {
                return false;
            }
        } else if (!x509CertificateHolder.equals(x509CertificateHolder2)) return false;
        if (!privateIdentity.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PrivateIdentity;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "PrivateIdentity";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "identityKey";
            }
            case 1: {
                return "tlsKey";
            }
            case 2: {
                return "certificateHolder";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public KeyPair identityKey() {
        return this.identityKey;
    }

    public KeyPair tlsKey() {
        return this.tlsKey;
    }

    public X509CertificateHolder certificateHolder() {
        return this.certificateHolder;
    }

    public CertificatePem tlsCertPem() {
        return X509Util$.MODULE$.toPem(this.certificateHolder());
    }

    public PrivateKeyPem tlsKeyPem() {
        return Ed25519Util$.MODULE$.privateKeyToPem(this.tlsKey().getPrivate());
    }

    public PublicIdentity getPublic() {
        return PublicIdentity$.MODULE$.apply(Ed25519Util$.MODULE$.publicKeyToPublicKeyBytesBase64Encoded(this.identityKey().getPublic()));
    }

    public PrivateIdentity copy(KeyPair identityKey, KeyPair tlsKey, X509CertificateHolder certificateHolder) {
        return new PrivateIdentity(identityKey, tlsKey, certificateHolder);
    }

    public KeyPair copy$default$1() {
        return this.identityKey();
    }

    public KeyPair copy$default$2() {
        return this.tlsKey();
    }

    public X509CertificateHolder copy$default$3() {
        return this.certificateHolder();
    }

    public KeyPair _1() {
        return this.identityKey();
    }

    public KeyPair _2() {
        return this.tlsKey();
    }

    public X509CertificateHolder _3() {
        return this.certificateHolder();
    }
}

