/*
 * Decompiled with CFR 0.152.
 */
package channels.tls;

import channels.tls.PrivateIdentity;
import crypto.CertificatePem;
import crypto.CertificatePem$;
import crypto.Ed25519Util$;
import crypto.PublicIdentity;
import crypto.PublicIdentity$;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcEdECContentSignerBuilder;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;

public final class X509Util$
implements Serializable {
    private static final AlgorithmIdentifier algoIdEd25519;
    public static final X509Util$ MODULE$;

    private X509Util$() {
    }

    static {
        MODULE$ = new X509Util$();
        if (Security.getProvider("BC") == null) {
            int n = Security.addProvider((Provider)new BouncyCastleProvider());
        }
        algoIdEd25519 = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509Util$.class);
    }

    public X509CertificateHolder generateCustomP2PX509Certificate(PrivateIdentity privateIdentity) {
        return this.generateCustomP2PX509Certificate(privateIdentity.identityKey(), privateIdentity.tlsKey());
    }

    public X509CertificateHolder generateCustomP2PX509Certificate(KeyPair identityKeyPair, KeyPair certificateKeyPair) {
        if (!((List)new .colon.colon((Object)"Ed25519", (List)new .colon.colon((Object)"EdDSA", (List)Nil$.MODULE$))).contains((Object)identityKeyPair.getPublic().getAlgorithm())) {
            throw new IllegalArgumentException("Only Ed25519 keys are accepted as the identityKeyPair");
        }
        byte[] identityBytes = Ed25519Util$.MODULE$.publicKeyToRawPublicKeyBytes(identityKeyPair.getPublic());
        if (identityBytes.length != 32) {
            throw new IllegalArgumentException("Only Ed25519 keys are accepted as the identityKeyPair");
        }
        String identityBase64 = Base64.getEncoder().encodeToString(identityBytes);
        X500Name identityName = new X500NameBuilder().addRDN(BCStyle.UNIQUE_IDENTIFIER, identityBase64).build();
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneId.of("GMT"));
        ZonedDateTime validFrom = currentTime.minusHours(1L);
        ZonedDateTime validUntil = currentTime.plusYears(1L);
        Tuple2 tuple2 = Ed25519Util$.MODULE$.keyPairToKeyParameters(identityKeyPair);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Ed25519PrivateKeyParameters signerPrivateKeyParam = (Ed25519PrivateKeyParameters)tuple2._2();
        Ed25519PrivateKeyParameters signerPrivateKeyParam2 = signerPrivateKeyParam;
        ContentSigner signer = new BcEdECContentSignerBuilder(algoIdEd25519).build((AsymmetricKeyParameter)signerPrivateKeyParam2);
        return new X509v3CertificateBuilder(identityName, BigInteger.valueOf(System.currentTimeMillis()), Date.from(validFrom.toInstant()), Date.from(validUntil.toInstant()), identityName, new SubjectPublicKeyInfo(algoIdEd25519, Ed25519Util$.MODULE$.publicKeyToRawPublicKeyBytes(certificateKeyPair.getPublic()))).build(signer);
    }

    public PublicIdentity certificateToPublicIdentity(X509Certificate certificate) throws CertificateException {
        certificate.checkValidity();
        X500Principal subject = certificate.getSubjectX500Principal();
        X500Principal issuer = certificate.getIssuerX500Principal();
        if (!subject.equals(issuer)) {
            throw new CertificateException("certificate not self issued");
        }
        Object[] uniqueIdRDNs = JcaX500NameUtil.getSubject((X509Certificate)certificate).getRDNs(BCStyle.UNIQUE_IDENTIFIER);
        Object object = Predef$.MODULE$.refArrayOps(uniqueIdRDNs);
        if (ArrayOps$.MODULE$.isEmpty$extension(object) || uniqueIdRDNs[0].size() != 1 || !(uniqueIdRDNs[0].getFirst().getValue() instanceof DERUTF8String)) {
            throw new CertificateException("Subject does not contain a UNIQUE_IDENTIFIER");
        }
        String subjectUniqueIdentifier = ((DERUTF8String)uniqueIdRDNs[0].getFirst().getValue()).toString();
        byte[] pubKeyBytes = Base64.getDecoder().decode(subjectUniqueIdentifier);
        PublicKey pubKey = Ed25519Util$.MODULE$.rawPublicKeyBytesToPublicKey(pubKeyBytes);
        try {
            certificate.verify(pubKey);
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        return PublicIdentity$.MODULE$.apply(subjectUniqueIdentifier);
    }

    public CertificatePem toPem(X509CertificateHolder certHolder) {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        pemWriter.writeObject((Object)cert);
        pemWriter.close();
        return CertificatePem$.MODULE$.apply(writer.toString());
    }

    public X509Certificate toJavaCertificate(X509CertificateHolder certHolder) {
        return new JcaX509CertificateConverter().getCertificate(certHolder);
    }
}

