/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.MessageBuffer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class JioOutputStreamAdapter {
    private final DataOutputStream outputStream;

    public JioOutputStreamAdapter(OutputStream out) {
        this.outputStream = new DataOutputStream(new BufferedOutputStream(out));
    }

    public DataOutputStream outputStream() {
        return this.outputStream;
    }

    public void send(MessageBuffer data) {
        JioOutputStreamAdapter jioOutputStreamAdapter = this;
        synchronized (jioOutputStreamAdapter) {
            byte[] outArray = data.asArray();
            this.outputStream().writeInt(outArray.length);
            this.outputStream().write(outArray);
            this.outputStream().flush();
        }
    }
}

