/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Abort;
import channels.ArrayMessageBuffer;
import channels.ArrayMessageBuffer$;
import channels.Connection;
import channels.ConnectionInfo;
import channels.ConnectionInfo$;
import channels.LatentConnection;
import channels.MessageBuffer;
import channels.Receive;
import channels.tls.P2PX509TrustManager;
import channels.tls.PrivateIdentity;
import channels.tls.X509Util$;
import crypto.PublicIdentity;
import de.rmgk.delay;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.pem.util.PemUtils;
import rdts.base.Uid;
import rdts.base.Uid$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class P2PTls {
    private final PrivateIdentity identity;
    public final SSLFactory channels$P2PTls$$sslFactory;

    public P2PTls(PrivateIdentity identity) {
        this.identity = identity;
        ByteArrayInputStream certPemFile = new ByteArrayInputStream(identity.tlsCertPem().getBytes());
        ByteArrayInputStream keyPemFile = new ByteArrayInputStream(identity.tlsKeyPem().getBytes());
        X509ExtendedKeyManager keyManager = PemUtils.loadIdentityMaterial((InputStream)certPemFile, (InputStream)keyPemFile);
        P2PX509TrustManager trustManager = new P2PX509TrustManager();
        this.channels$P2PTls$$sslFactory = SSLFactory.builder().withCiphers(new String[]{"TLS_CHACHA20_POLY1305_SHA256"}).withProtocols(new String[]{"TLSv1.3"}).withIdentityMaterial((X509KeyManager)keyManager).withTrustMaterial((X509TrustManager)trustManager).withNeedClientAuthentication().build();
    }

    private PrivateIdentity identity() {
        return this.identity;
    }

    public P2PTlsListener latentListener(int listenPort, ExecutionContext ec) {
        return new P2PTlsListener(this, listenPort, ec);
    }

    public LatentConnection<MessageBuffer> latentConnect(String host, int port, ExecutionContext ec) {
        return receiver -> new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            try {
                SSLSocket socket = (SSLSocket)this.channels$P2PTls$$sslFactory.getSslSocketFactory().createSocket(host, port);
                delay.Async async = new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> ((Function1)this.channels$P2PTls$$startHandshake(socket).handleInCtx().apply(ctx)).apply(arg_0 -> this.$anonfun$1$$anonfun$1$$anonfun$1(socket, receiver, ec, cb, arg_0)));
                ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw throwable;
            }
        });
    }

    public delay.Async<Abort, PublicIdentity> channels$P2PTls$$startHandshake(SSLSocket socket) {
        return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            socket.addHandshakeCompletedListener(ev -> {
                PublicIdentity peerIdentity = X509Util$.MODULE$.certificateToPublicIdentity((X509Certificate)ev.getPeerCertificates()[0]);
                delay.Callback Callback_this = cb;
                Callback_this.complete((Try)Success$.MODULE$.apply((Object)peerIdentity));
            });
            try {
                socket.startHandshake();
            }
            catch (IOException e) {
                delay.Callback Callback_this = cb;
                Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)e));
            }
        });
    }

    private static final /* synthetic */ void $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(P2PTlsConnection conn$1) {
        conn$1.receiveLoopBlocking();
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void $anonfun$1$$anonfun$1$$anonfun$1(SSLSocket socket$3, Receive receiver$5, ExecutionContext ec$6, delay.Callback cb$1, Try res) {
        try {
            remotePublicId = var6_6 = (PublicIdentity)res.get();
            conn = new P2PTlsConnection(socket$3, Uid$.MODULE$.apply(remotePublicId.id()), receiver$5);
            ec$6.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(channels.P2PTls$P2PTlsConnection ), ()V)((P2PTlsConnection)conn));
            Callback_this = cb$1;
            Callback_this.complete((Try)Success$.MODULE$.apply((Object)conn));
        }
        catch (Throwable var10_10) {
            block4: {
                e = var11_11 = var10_10;
                if (!NonFatal$.MODULE$.apply(e)) break block4;
                var13_13 = res;
                if (!(var13_13 instanceof Failure)) ** GOTO lbl-1000
                v0 = exception = ((Failure)var13_13).exception();
                var15_15 = e;
                if (v0 == null ? var15_15 != null : v0.equals(var15_15) == false) {
                    e.addSuppressed(exception);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = other = var13_13;
                }
                Callback_this = cb$1;
                Callback_this.complete((Try)Failure$.MODULE$.apply(e));
            }
            throw var10_10;
        }
    }

    public static final /* synthetic */ void channels$P2PTls$P2PTlsListener$$_$_$$anonfun$2(P2PTlsConnection conn$2) {
        conn$2.receiveLoopBlocking();
    }

    public class P2PTlsConnection
    implements Connection<MessageBuffer> {
        private final SSLSocket socket;
        private final DataOutputStream outputStream;
        private final DataInputStream inputStream;
        private final delay.Callback<MessageBuffer> receivedMessageCallback;
        private final Option<Uid> authenticatedPeerReplicaId;

        public P2PTlsConnection(SSLSocket socket, Uid peerReplicaId, Receive<MessageBuffer> receiver) {
            Socket socket2;
            this.socket = socket;
            this.outputStream = new DataOutputStream(socket.getOutputStream());
            this.inputStream = new DataInputStream(socket.getInputStream());
            this.receivedMessageCallback = receiver.messageHandler(this);
            this.authenticatedPeerReplicaId = Some$.MODULE$.apply((Object)peerReplicaId);
            try {
                socket2 = socket.setOption(StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(true));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Predef$.MODULE$.println((Object)"TCP nodelay not supported on this socket");
                socket2 = BoxedUnit.UNIT;
            }
        }

        private SSLSocket socket() {
            return this.socket;
        }

        @Override
        public Option<Uid> authenticatedPeerReplicaId() {
            return this.authenticatedPeerReplicaId;
        }

        @Override
        public ConnectionInfo info() {
            SocketAddress socketAddress = this.socket().getLocalSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                return ConnectionInfo$.MODULE$.apply((Option<String>)Option$.MODULE$.apply((Object)isa.getHostName()), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)isa.getPort())));
            }
            return ConnectionInfo$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }

        @Override
        public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
            return new delay.Sync((Function1)(JProcedure1 & Serializable)x -> {
                DataOutputStream dataOutputStream = this.outputStream;
                synchronized (dataOutputStream) {
                    byte[] bytes = message.asArray();
                    int messageLength = bytes.length;
                    this.outputStream.writeInt(bytes.length);
                    this.outputStream.write(bytes);
                }
            });
        }

        public void receiveLoopBlocking() {
            DataInputStream dataInputStream = this.inputStream;
            synchronized (dataInputStream) {
                while (true) {
                    int len = this.inputStream.readInt();
                    byte[] bytes = this.inputStream.readNBytes(len);
                    delay.Callback<MessageBuffer> Callback_this = this.receivedMessageCallback;
                    ArrayMessageBuffer value$proxy2 = ArrayMessageBuffer$.MODULE$.apply(bytes);
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy2));
                }
            }
        }

        @Override
        public void close() {
            this.socket().close();
        }
    }

    public class P2PTlsListener
    implements LatentConnection<MessageBuffer> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(P2PTlsListener.class.getDeclaredField("serverSocket$lzy1"));
        private final int _listenPort;
        private final ExecutionContext executionContext;
        private volatile Object serverSocket$lzy1;
        private final /* synthetic */ P2PTls $outer;

        public P2PTlsListener(P2PTls $outer, int _listenPort, ExecutionContext executionContext) {
            this._listenPort = _listenPort;
            this.executionContext = executionContext;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(_listenPort >= 0 && _listenPort <= 65535);
        }

        private SSLServerSocket serverSocket() {
            Object object = this.serverSocket$lzy1;
            if (object instanceof SSLServerSocket) {
                return (SSLServerSocket)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (SSLServerSocket)this.serverSocket$lzyINIT1();
        }

        private Object serverSocket$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.serverSocket$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        SSLServerSocket sSLServerSocket = null;
                        try {
                            sSLServerSocket = (SSLServerSocket)this.$outer.channels$P2PTls$$sslFactory.getSslServerSocketFactory().createServerSocket(this._listenPort);
                            object2 = sSLServerSocket == null ? LazyVals.NullValue$.MODULE$ : sSLServerSocket;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.serverSocket$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return sSLServerSocket;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int listenPort() {
            return this.serverSocket().getLocalPort();
        }

        @Override
        public delay.Async<Abort, Connection<MessageBuffer>> prepare(Receive<MessageBuffer> receiver) {
            return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                try {
                    this.serverSocket();
                    this.executionContext.execute(() -> {
                        while (!ctx.closeRequest()) {
                            SSLSocket socket = (SSLSocket)this.serverSocket().accept();
                            if (socket == null) continue;
                            delay.Callback callback = cb;
                            ((Function1)this.$outer.channels$P2PTls$$startHandshake(socket).handleInCtx().apply(ctx)).apply(arg_0 -> this.prepare$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(callback, socket, receiver, arg_0));
                        }
                    });
                }
                catch (IOException ioException) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ioException));
                }
            });
        }

        public final /* synthetic */ P2PTls channels$P2PTls$P2PTlsListener$$$outer() {
            return this.$outer;
        }

        /*
         * Unable to fully structure code
         */
        private final /* synthetic */ void prepare$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(delay.Callback cb$4, SSLSocket socket$6, Receive receiver$8, Try res) {
            try {
                var5_5 = (PublicIdentity)res.get();
                Callback_this = cb$4;
                conn = new P2PTlsConnection(socket$6, Uid$.MODULE$.apply(var5_5.id()), receiver$8);
                this.executionContext.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, channels$P2PTls$P2PTlsListener$$_$_$$anonfun$2(channels.P2PTls$P2PTlsConnection ), ()V)((P2PTlsConnection)conn));
                value$proxy1 = conn;
                Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy1));
            }
            catch (Throwable var9_9) {
                block4: {
                    e = var10_10 = var9_9;
                    if (!NonFatal$.MODULE$.apply(e)) break block4;
                    var12_12 = res;
                    if (!(var12_12 instanceof Failure)) ** GOTO lbl-1000
                    v0 = exception = ((Failure)var12_12).exception();
                    var14_14 = e;
                    if (v0 == null ? var14_14 != null : v0.equals(var14_14) == false) {
                        e.addSuppressed(exception);
                        v1 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = other = var12_12;
                    }
                    Callback_this = cb$4;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw var9_9;
            }
        }
    }
}

