/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Connection;
import channels.ConnectionInfo;
import channels.ConnectionInfo$;
import channels.MessageBuffer;
import de.rmgk.delay;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class UDPDatagramWrapper
implements Connection<MessageBuffer> {
    private final SocketAddress target;
    private final DatagramSocket datagramSocket;
    private final ConnectionInfo info;

    public UDPDatagramWrapper(SocketAddress target, DatagramSocket datagramSocket) {
        ConnectionInfo connectionInfo;
        this.target = target;
        this.datagramSocket = datagramSocket;
        SocketAddress socketAddress = datagramSocket.getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            connectionInfo = ConnectionInfo$.MODULE$.apply((Option<String>)Option$.MODULE$.apply((Object)isa.getHostString()), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)isa.getPort())));
        } else {
            SocketAddress other = socketAddress;
            connectionInfo = ConnectionInfo$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
        this.info = connectionInfo;
    }

    @Override
    public ConnectionInfo info() {
        return this.info;
    }

    @Override
    public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
        return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            try {
                byte[] outArray = message.asArray();
                DatagramPacket sendPacket = new DatagramPacket(outArray, outArray.length, this.target);
                delay.Sync async = new delay.Sync((Function1)(JProcedure1 & Serializable)x -> this.datagramSocket.send(sendPacket));
                ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw throwable;
            }
        });
    }

    @Override
    public void close() {
        this.datagramSocket.close();
    }
}

