/*
 * Decompiled with CFR 0.152.
 */
package channels.jettywebsockets;

import channels.ArrayMessageBuffer;
import channels.ArrayMessageBuffer$;
import channels.Connection;
import channels.MessageBuffer;
import channels.Receive;
import channels.jettywebsockets.Jetty$package$;
import channels.jettywebsockets.JettySessionWrapper;
import de.rmgk.delay;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class JettyWsHandler
extends Session.Listener$.Abstract {
    private final Receive<MessageBuffer> incoming;
    private final delay.Callback<Connection<MessageBuffer>> connectionEstablished;
    private volatile delay.Callback<MessageBuffer> internalCallback;

    public JettyWsHandler(Receive<MessageBuffer> incoming, delay.Callback<Connection<MessageBuffer>> connectionEstablished) {
        this.incoming = incoming;
        this.connectionEstablished = connectionEstablished;
    }

    public void onWebSocketOpen(Session session) {
        super.onWebSocketOpen(session);
        JettySessionWrapper sessionWrapper = new JettySessionWrapper(session);
        this.internalCallback = this.incoming.messageHandler(sessionWrapper);
        delay.Callback<Connection<MessageBuffer>> Callback_this = this.connectionEstablished;
        Callback_this.complete((Try)Success$.MODULE$.apply((Object)sessionWrapper));
        session.demand();
    }

    public void onWebSocketBinary(ByteBuffer buffer, Callback callback) {
        Jetty$package$.MODULE$.println("received binary data");
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        delay.Callback<MessageBuffer> Callback_this = this.internalCallback;
        ArrayMessageBuffer value$proxy2 = ArrayMessageBuffer$.MODULE$.apply(data);
        Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy2));
        callback.succeed();
        this.getSession().demand();
    }

    public void onWebSocketText(String message) {
        Jetty$package$.MODULE$.println("received unexpected text data: " + message);
        this.getSession().demand();
    }

    public void onWebSocketClose(int statusCode, String reason) {
        Jetty$package$.MODULE$.println("closing message because " + reason);
    }

    public void onWebSocketError(Throwable cause) {
        Jetty$package$.MODULE$.println("received explicit error " + cause);
        delay.Callback<MessageBuffer> Callback_this = this.internalCallback;
        Callback_this.complete((Try)Failure$.MODULE$.apply(cause));
    }

    public void onWebSocketPing(ByteBuffer payload) {
        this.getSession().sendPong(payload, Callback.from(() -> this.getSession().demand(), str -> Jetty$package$.MODULE$.println(str)));
    }
}

