/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Abort;
import channels.AcceptAttachment;
import channels.AcceptAttachment$;
import channels.ArrayMessageBuffer;
import channels.ArrayMessageBuffer$;
import channels.Connection;
import channels.LatentConnection;
import channels.MessageBuffer;
import channels.Receive;
import channels.ReceiveAttachment;
import channels.ReceiveAttachment$;
import de.rmgk.delay;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class NioTCP {
    private final Selector selector = Selector.open();

    public Selector selector() {
        return this.selector;
    }

    public void loopSelection(Abort abort) {
        while (!abort.closeRequest()) {
            this.selector().select();
            this.runSelection();
        }
    }

    public void runSelection() {
        this.selector().selectedKeys().forEach(x$1 -> {
            SelectionKey selectionKey = x$1;
            SelectionKey key = selectionKey;
            if (key.isReadable()) {
                SocketChannel clientChannel = (SocketChannel)key.channel();
                ReceiveAttachment attachment = (ReceiveAttachment)key.attachment();
                try {
                    int len = this.readN(4, clientChannel).getInt();
                    byte[] bytes = new byte[len];
                    ByteBuffer targetBuffer = this.readN(len, clientChannel).get(bytes);
                    delay.Callback<MessageBuffer> Callback_this = attachment.callback();
                    ArrayMessageBuffer value$proxy1 = ArrayMessageBuffer$.MODULE$.apply(bytes);
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy1));
                }
                catch (IOException ex) {
                    clientChannel.close();
                    key.cancel();
                    delay.Callback<MessageBuffer> Callback_this = attachment.callback();
                    Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex));
                }
                return;
            }
            SelectionKey key2 = selectionKey;
            if (key2.isAcceptable()) {
                ServerSocketChannel serverChannel = (ServerSocketChannel)key2.channel();
                AcceptAttachment attachment = (AcceptAttachment)key2.attachment();
                SocketChannel clientChannel = serverChannel.accept();
                try {
                    delay.Callback<Connection<MessageBuffer>> Callback_this = attachment.callback();
                    NioTCPConnection value$proxy2 = this.handleConnection(clientChannel, attachment.incoming());
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy2));
                }
                catch (SocketException exception) {
                    delay.Callback<Connection<MessageBuffer>> Callback_this = attachment.callback();
                    Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)exception));
                }
                return;
            }
            throw new MatchError((Object)selectionKey);
        });
        this.selector().selectedKeys().clear();
    }

    public NioTCPConnection handleConnection(SocketChannel clientChannel, Receive<MessageBuffer> incoming) {
        this.configureChannel(clientChannel);
        NioTCPConnection conn = new NioTCPConnection(this, clientChannel);
        delay.Callback<MessageBuffer> callback = incoming.messageHandler(conn);
        clientChannel.register(this.selector(), 1, ReceiveAttachment$.MODULE$.apply(callback));
        this.selector().wakeup();
        return conn;
    }

    public ByteBuffer readN(int n, SocketChannel clientChannel) {
        int result;
        ByteBuffer buffer = ByteBuffer.allocate(n);
        for (int bytesRead = 0; bytesRead < n; bytesRead += result) {
            result = clientChannel.read(buffer);
            if (result != -1) continue;
            throw new IOException("nothing read???");
        }
        buffer.flip();
        return buffer;
    }

    public LatentConnection<MessageBuffer> connect(Function0<SocketChannel> bindsocket) {
        return new LatentConnection<MessageBuffer>(bindsocket, this){
            private final Function0 bindsocket$1;
            private final /* synthetic */ NioTCP $outer;
            {
                this.bindsocket$1 = bindsocket$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public delay.Async prepare(Receive incoming) {
                return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                    try {
                        delay.Callback Callback_this = cb;
                        NioTCPConnection value$proxy3 = this.$outer.handleConnection((SocketChannel)this.bindsocket$1.apply(), incoming);
                        Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy3));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable throwable3;
                            Throwable exception = throwable3 = (Throwable)option.get();
                            delay.Callback Callback_this = cb;
                            Callback_this.complete((Try)Failure$.MODULE$.apply(exception));
                        }
                        throw throwable;
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{prepare$$anonfun$1(channels.Receive java.lang.Object ), prepare$$anonfun$1$$anonfun$1(channels.Receive de.rmgk.delay$Callback )}, serializedLambda);
            }
        };
    }

    public Function0<SocketChannel> defaultSocketChannel(SocketAddress socketAddress) {
        return (Function0 & Serializable)() -> {
            StandardProtocolFamily standardProtocolFamily;
            SocketAddress socketAddress = socketAddress;
            if (socketAddress instanceof UnixDomainSocketAddress) {
                standardProtocolFamily = StandardProtocolFamily.UNIX;
            } else {
                SocketAddress other = socketAddress;
                standardProtocolFamily = StandardProtocolFamily.INET;
            }
            StandardProtocolFamily pf = standardProtocolFamily;
            SocketChannel channel = SocketChannel.open(pf);
            channel.connect(socketAddress);
            this.configureChannel(channel);
            return channel;
        };
    }

    private Object configureChannel(SocketChannel channel) {
        NetworkChannel networkChannel;
        channel.configureBlocking(false);
        try {
            networkChannel = channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(true));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Predef$.MODULE$.println((Object)"TCP nodelay not supported on this socket");
            networkChannel = BoxedUnit.UNIT;
        }
        return networkChannel;
    }

    public Function0<ServerSocketChannel> defaultServerSocketChannel(SocketAddress socketAddress) {
        return (Function0 & Serializable)() -> {
            StandardProtocolFamily standardProtocolFamily;
            SocketAddress socketAddress = socketAddress;
            if (socketAddress instanceof UnixDomainSocketAddress) {
                standardProtocolFamily = StandardProtocolFamily.UNIX;
            } else {
                SocketAddress other = socketAddress;
                standardProtocolFamily = StandardProtocolFamily.INET;
            }
            StandardProtocolFamily pf = standardProtocolFamily;
            ServerSocketChannel socket = ServerSocketChannel.open(pf);
            socket.configureBlocking(false);
            socket.bind(socketAddress);
            return socket;
        };
    }

    public LatentConnection<MessageBuffer> listen(Function0<ServerSocketChannel> bindsocket) {
        return new LatentConnection<MessageBuffer>(bindsocket, this){
            private final Function0 bindsocket$2;
            private final /* synthetic */ NioTCP $outer;
            {
                this.bindsocket$2 = bindsocket$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public delay.Async prepare(Receive incoming) {
                return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                    try {
                        ServerSocketChannel serverChannel = (ServerSocketChannel)this.bindsocket$2.apply();
                        delay.Callback callback = cb;
                        serverChannel.register(this.$outer.selector(), 16, AcceptAttachment$.MODULE$.apply((delay.Callback<Connection<MessageBuffer>>)callback, incoming));
                        this.$outer.selector().wakeup();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            delay.Callback Callback_this = cb;
                            Callback_this.complete((Try)Failure$.MODULE$.apply(ex));
                        }
                        throw throwable;
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{prepare$$anonfun$2(channels.Receive channels.Abort ), prepare$$anonfun$2$$anonfun$1(channels.Receive de.rmgk.delay$Callback )}, serializedLambda);
            }
        };
    }

    public class NioTCPConnection
    implements Connection<MessageBuffer> {
        private final SocketChannel clientChannel;
        private final /* synthetic */ NioTCP $outer;

        public NioTCPConnection(NioTCP $outer, SocketChannel clientChannel) {
            this.clientChannel = clientChannel;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
            return new delay.Sync((Function1)(JProcedure1 & Serializable)x -> {
                byte[] bytes = message.asArray();
                int messageLength = bytes.length;
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                sizeBuffer.putInt(messageLength);
                sizeBuffer.flip();
                ByteBuffer[] buffers = new ByteBuffer[]{sizeBuffer, buffer};
                while (buffer.hasRemaining()) {
                    long res = this.clientChannel.write(buffers);
                }
            });
        }

        @Override
        public void close() {
            this.clientChannel.close();
        }

        public final /* synthetic */ NioTCP channels$NioTCP$NioTCPConnection$$$outer() {
            return this.$outer;
        }
    }
}

