/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Abort;
import channels.ArrayMessageBuffer;
import channels.ArrayMessageBuffer$;
import channels.Connection;
import channels.LatentConnection;
import channels.MessageBuffer;
import channels.NioTCP$AcceptAttachment$;
import channels.NioTCP$ReceiveAttachment$;
import channels.NoMoreDataException;
import channels.Receive;
import de.rmgk.delay;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

public class NioTCP {
    private final Selector selector = Selector.open();

    public Selector selector() {
        return this.selector;
    }

    public void loopSelection(Abort abort) {
        while (!abort.closeRequest()) {
            this.selector().select();
            this.runSelection();
        }
    }

    public void runSelection() {
        this.selector().selectedKeys().forEach(x$1 -> {
            SelectionKey selectionKey = x$1;
            SelectionKey key = selectionKey;
            if (key.isReadable()) {
                SocketChannel clientChannel = (SocketChannel)key.channel();
                ReceiveAttachment attachment = (ReceiveAttachment)key.attachment();
                try {
                    int len = this.readN(4, clientChannel).getInt();
                    byte[] bytes = new byte[len];
                    ByteBuffer targetBuffer = this.readN(len, clientChannel).get(bytes);
                    delay.Callback<MessageBuffer> Callback_this = attachment.callback();
                    ArrayMessageBuffer value$proxy1 = ArrayMessageBuffer$.MODULE$.apply(bytes);
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy1));
                }
                catch (IOException ex) {
                    clientChannel.close();
                    key.cancel();
                    delay.Callback<MessageBuffer> Callback_this = attachment.callback();
                    Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)ex));
                }
                return;
            }
            SelectionKey key2 = selectionKey;
            if (key2.isAcceptable()) {
                ServerSocketChannel serverChannel = (ServerSocketChannel)key2.channel();
                AcceptAttachment attachment = (AcceptAttachment)key2.attachment();
                SocketChannel clientChannel = serverChannel.accept();
                try {
                    delay.Callback<Connection<MessageBuffer>> Callback_this = attachment.callback();
                    NioTCPConnection value$proxy2 = this.handleConnection(clientChannel, attachment.incoming());
                    Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy2));
                }
                catch (SocketException exception) {
                    delay.Callback<Connection<MessageBuffer>> Callback_this = attachment.callback();
                    Callback_this.complete((Try)Failure$.MODULE$.apply((Throwable)exception));
                }
                return;
            }
            throw new MatchError((Object)selectionKey);
        });
        this.selector().selectedKeys().clear();
    }

    public NioTCPConnection handleConnection(SocketChannel clientChannel, Receive<MessageBuffer> incoming) {
        this.configureChannel(clientChannel);
        NioTCPConnection conn = new NioTCPConnection(this, clientChannel);
        delay.Callback<MessageBuffer> callback = incoming.messageHandler(conn);
        clientChannel.register(this.selector(), 1, NioTCP$ReceiveAttachment$.MODULE$.apply(callback));
        this.selector().wakeup();
        return conn;
    }

    public ByteBuffer readN(int n, SocketChannel clientChannel) {
        int result;
        ByteBuffer buffer = ByteBuffer.allocate(n);
        for (int bytesRead = 0; bytesRead < n; bytesRead += result) {
            result = clientChannel.read(buffer);
            if (result != -1) continue;
            throw new NoMoreDataException("remaining channel is empty");
        }
        buffer.flip();
        return buffer;
    }

    public LatentConnection<MessageBuffer> connect(Function0<SocketChannel> bindsocket) {
        return new LatentConnection<MessageBuffer>(bindsocket, this){
            private final Function0 bindsocket$1;
            private final /* synthetic */ NioTCP $outer;
            {
                this.bindsocket$1 = bindsocket$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public delay.Async prepare(Receive incoming) {
                return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                    try {
                        delay.Callback Callback_this = cb;
                        NioTCPConnection value$proxy3 = this.$outer.handleConnection((SocketChannel)this.bindsocket$1.apply(), incoming);
                        Callback_this.complete((Try)Success$.MODULE$.apply((Object)value$proxy3));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable throwable3;
                            Throwable exception = throwable3 = (Throwable)option.get();
                            delay.Callback Callback_this = cb;
                            Callback_this.complete((Try)Failure$.MODULE$.apply(exception));
                        }
                        throw throwable;
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{prepare$$anonfun$1(channels.Receive java.lang.Object ), prepare$$anonfun$1$$anonfun$1(channels.Receive de.rmgk.delay$Callback )}, serializedLambda);
            }
        };
    }

    public Function0<SocketChannel> defaultSocketChannel(SocketAddress socketAddress) {
        return (Function0 & Serializable)() -> {
            StandardProtocolFamily standardProtocolFamily;
            SocketAddress socketAddress = socketAddress;
            if (socketAddress instanceof UnixDomainSocketAddress) {
                standardProtocolFamily = StandardProtocolFamily.UNIX;
            } else {
                SocketAddress other = socketAddress;
                standardProtocolFamily = StandardProtocolFamily.INET;
            }
            StandardProtocolFamily pf = standardProtocolFamily;
            SocketChannel channel = SocketChannel.open(pf);
            channel.connect(socketAddress);
            this.configureChannel(channel);
            return channel;
        };
    }

    private Object configureChannel(SocketChannel channel) {
        Object object;
        channel.configureBlocking(false);
        try {
            object = channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(true));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public Function0<ServerSocketChannel> defaultServerSocketChannel(SocketAddress socketAddress) {
        return (Function0 & Serializable)() -> {
            StandardProtocolFamily standardProtocolFamily;
            SocketAddress socketAddress = socketAddress;
            if (socketAddress instanceof UnixDomainSocketAddress) {
                standardProtocolFamily = StandardProtocolFamily.UNIX;
            } else {
                SocketAddress other = socketAddress;
                standardProtocolFamily = StandardProtocolFamily.INET;
            }
            StandardProtocolFamily pf = standardProtocolFamily;
            ServerSocketChannel socket = ServerSocketChannel.open(pf);
            socket.configureBlocking(false);
            socket.bind(socketAddress);
            return socket;
        };
    }

    public LatentConnection<MessageBuffer> listen(Function0<ServerSocketChannel> bindsocket) {
        return new LatentConnection<MessageBuffer>(bindsocket, this){
            private final Function0 bindsocket$2;
            private final /* synthetic */ NioTCP $outer;
            {
                this.bindsocket$2 = bindsocket$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public delay.Async prepare(Receive incoming) {
                return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
                    try {
                        ServerSocketChannel serverChannel = (ServerSocketChannel)this.bindsocket$2.apply();
                        delay.Callback callback = cb;
                        serverChannel.register(this.$outer.selector(), 16, NioTCP$AcceptAttachment$.MODULE$.apply((delay.Callback<Connection<MessageBuffer>>)callback, incoming));
                        this.$outer.selector().wakeup();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            delay.Callback Callback_this = cb;
                            Callback_this.complete((Try)Failure$.MODULE$.apply(ex));
                        }
                        throw throwable;
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{prepare$$anonfun$2(channels.Receive channels.Abort ), prepare$$anonfun$2$$anonfun$1(channels.Receive de.rmgk.delay$Callback )}, serializedLambda);
            }
        };
    }

    public static class AcceptAttachment
    implements Product,
    Serializable {
        private final delay.Callback<Connection<MessageBuffer>> callback;
        private final Receive<MessageBuffer> incoming;

        public static AcceptAttachment apply(delay.Callback<Connection<MessageBuffer>> callback, Receive<MessageBuffer> receive) {
            return NioTCP$AcceptAttachment$.MODULE$.apply(callback, receive);
        }

        public static AcceptAttachment fromProduct(Product product) {
            return NioTCP$AcceptAttachment$.MODULE$.fromProduct(product);
        }

        public static AcceptAttachment unapply(AcceptAttachment acceptAttachment) {
            return NioTCP$AcceptAttachment$.MODULE$.unapply(acceptAttachment);
        }

        public AcceptAttachment(delay.Callback<Connection<MessageBuffer>> callback, Receive<MessageBuffer> incoming) {
            this.callback = callback;
            this.incoming = incoming;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1727766122, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AcceptAttachment)) return false;
            AcceptAttachment acceptAttachment = (AcceptAttachment)object;
            delay.Callback<Connection<MessageBuffer>> callback = this.callback();
            delay.Callback<Connection<MessageBuffer>> callback2 = acceptAttachment.callback();
            if (callback == null) {
                if (callback2 != null) {
                    return false;
                }
            } else if (!callback.equals(callback2)) return false;
            Receive<MessageBuffer> receive = this.incoming();
            Receive<MessageBuffer> receive2 = acceptAttachment.incoming();
            if (receive == null) {
                if (receive2 != null) {
                    return false;
                }
            } else if (!receive.equals(receive2)) return false;
            if (!acceptAttachment.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AcceptAttachment;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AcceptAttachment";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "callback";
            }
            if (1 == n2) {
                return "incoming";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public delay.Callback<Connection<MessageBuffer>> callback() {
            return this.callback;
        }

        public Receive<MessageBuffer> incoming() {
            return this.incoming;
        }

        public AcceptAttachment copy(delay.Callback<Connection<MessageBuffer>> callback, Receive<MessageBuffer> incoming) {
            return new AcceptAttachment(callback, incoming);
        }

        public delay.Callback<Connection<MessageBuffer>> copy$default$1() {
            return this.callback();
        }

        public Receive<MessageBuffer> copy$default$2() {
            return this.incoming();
        }

        public delay.Callback<Connection<MessageBuffer>> _1() {
            return this.callback();
        }

        public Receive<MessageBuffer> _2() {
            return this.incoming();
        }
    }

    public static class EndOfChannelException
    extends Exception {
        public EndOfChannelException(String msg) {
            super(msg);
        }
    }

    public class NioTCPConnection
    implements Connection<MessageBuffer> {
        private final SocketChannel clientChannel;
        private final /* synthetic */ NioTCP $outer;

        public NioTCPConnection(NioTCP $outer, SocketChannel clientChannel) {
            this.clientChannel = clientChannel;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public delay.Async<Object, BoxedUnit> send(MessageBuffer message) {
            return new delay.Sync((Function1)(JProcedure1 & Serializable)x -> {
                byte[] bytes = message.asArray();
                int messageLength = bytes.length;
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                sizeBuffer.putInt(messageLength);
                sizeBuffer.flip();
                ByteBuffer[] buffers = new ByteBuffer[]{sizeBuffer, buffer};
                while (buffer.hasRemaining()) {
                    long res = this.clientChannel.write(buffers);
                }
            });
        }

        @Override
        public void close() {
            this.clientChannel.close();
        }

        public final /* synthetic */ NioTCP channels$NioTCP$NioTCPConnection$$$outer() {
            return this.$outer;
        }
    }

    public static class ReceiveAttachment
    implements Product,
    Serializable {
        private final delay.Callback<MessageBuffer> callback;

        public static ReceiveAttachment apply(delay.Callback<MessageBuffer> callback) {
            return NioTCP$ReceiveAttachment$.MODULE$.apply(callback);
        }

        public static ReceiveAttachment fromProduct(Product product) {
            return NioTCP$ReceiveAttachment$.MODULE$.fromProduct(product);
        }

        public static ReceiveAttachment unapply(ReceiveAttachment receiveAttachment) {
            return NioTCP$ReceiveAttachment$.MODULE$.unapply(receiveAttachment);
        }

        public ReceiveAttachment(delay.Callback<MessageBuffer> callback) {
            this.callback = callback;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -691639452, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReceiveAttachment)) return false;
            ReceiveAttachment receiveAttachment = (ReceiveAttachment)object;
            delay.Callback<MessageBuffer> callback = this.callback();
            delay.Callback<MessageBuffer> callback2 = receiveAttachment.callback();
            if (callback == null) {
                if (callback2 != null) {
                    return false;
                }
            } else if (!callback.equals(callback2)) return false;
            if (!receiveAttachment.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReceiveAttachment;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReceiveAttachment";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "callback";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public delay.Callback<MessageBuffer> callback() {
            return this.callback;
        }

        public ReceiveAttachment copy(delay.Callback<MessageBuffer> callback) {
            return new ReceiveAttachment(callback);
        }

        public delay.Callback<MessageBuffer> copy$default$1() {
            return this.callback();
        }

        public delay.Callback<MessageBuffer> _1() {
            return this.callback();
        }
    }
}

