/*
 * Decompiled with CFR 0.152.
 */
package replication;

import java.io.Serializable;
import rdts.base.Uid;
import rdts.time.ArrayRanges;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import rdts.time.Dots$;
import replication.CachedMessage;
import replication.DotTree;
import replication.DotTreeNode;
import replication.ProtocolMessage;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DeltaTreeContext<State> {
    private final Uid selfUid;
    private final DotTree tree;
    private List<CachedMessage<ProtocolMessage.Payload<State>>> payloads;
    private Map<Dot, List<Object>> dotToPayload;

    public DeltaTreeContext(Uid selfUid) {
        this.selfUid = selfUid;
        this.tree = new DotTree();
        this.payloads = package$.MODULE$.List().empty();
        this.dotToPayload = Predef$.MODULE$.Map().empty();
        Map knowledgeOfPeers = Predef$.MODULE$.Map().empty();
    }

    public DotTree tree() {
        return this.tree;
    }

    public boolean addNode(Dot dot, Dot causalPredecessor) {
        return this.tree().addNode(dot, causalPredecessor);
    }

    public Option<Dot> getLeaf(Uid uid) {
        return this.tree().getLeafDot(uid);
    }

    public Option<Dot> getSelfLeaf() {
        return this.tree().getLeafDot(this.selfUid);
    }

    public Dots addNonRedundant(Dots dots, Dots initialCausalPredecessors) {
        ObjectRef nonRedundantDots = ObjectRef.create((Object)Dots$.MODULE$.empty());
        ObjectRef currentPeer = ObjectRef.create((Object)this.selfUid);
        ObjectRef causalPredecessor = ObjectRef.create((Object)Dot$.MODULE$.zero());
        dots.iterator().filter((Function1 & Serializable)dot -> {
            Uid uid = dot.place();
            Uid uid2 = this.selfUid;
            return uid == null ? uid2 != null : !uid.equals(uid2);
        }).foreach((Function1)(JProcedure1 & Serializable)dot -> {
            Uid uid = dot.place();
            Uid uid2 = (Uid)currentPeer$1.elem;
            if ((uid == null ? uid2 != null : !uid.equals(uid2)) && dot.time() > 0L) {
                currentPeer$1.elem = dot.place();
                Option option = initialCausalPredecessors.max((Uid)currentPeer$1.elem);
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(this.selfUid + ": No causal predecessor given for dot " + dot + ", initial causal predecessors: " + initialCausalPredecessors);
                    }
                    throw new MatchError((Object)option);
                }
                Dot value = (Dot)((Some)option).value();
                causalPredecessor$2.elem = value;
            } else {
                Uid uid3 = dot.place();
                Uid uid4 = (Uid)currentPeer$1.elem;
                if (uid3 == null ? uid4 != null : !uid3.equals(uid4)) {
                    currentPeer$1.elem = dot.place();
                    causalPredecessor$2.elem = dot;
                }
            }
            if (this.tree().addNode((Dot)dot, (Dot)causalPredecessor$2.elem)) {
                nonRedundantDots$1.elem = ((Dots)nonRedundantDots$1.elem).add(dot);
                causalPredecessor$2.elem = dot;
                return;
            }
        });
        return (Dots)nonRedundantDots.elem;
    }

    private void addDotToPayload(int index, Dot dot) {
        List list;
        Option option = this.dotToPayload.get((Object)dot);
        if (option instanceof Some) {
            List indices = (List)((Some)option).value();
            list = (List)indices.$colon$plus((Object)BoxesRunTime.boxToInteger((int)index));
        } else if (None$.MODULE$.equals(option)) {
            list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)index), (List)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        List newIndices = list;
        Dot dot2 = (Dot)Predef$.MODULE$.ArrowAssoc((Object)dot);
        this.dotToPayload = (Map)this.dotToPayload.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)dot2, (Object)newIndices));
    }

    public void storeMessage(Dots dots, CachedMessage<ProtocolMessage.Payload<State>> message) {
        this.payloads = (List)this.payloads.$colon$plus(message);
        int index = this.payloads.size() - 1;
        dots.internal().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Uid uid = (Uid)x$1._1();
            ArrayRanges arrayRanges = (ArrayRanges)x$1._2();
            Object object = Predef$.MODULE$.longArrayOps(arrayRanges.inner());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JFunction1.mcVJ.sp & Serializable)time -> this.addDotToPayload(index, Dot$.MODULE$.apply(uid, time)));
        });
    }

    public void storeOutgoingMessage(Dot dot, CachedMessage<ProtocolMessage.Payload<State>> message) {
        this.tree().addNewLeaf(dot, this.selfUid);
        this.payloads = (List)this.payloads.$colon$plus(message);
        this.addDotToPayload(this.payloads.size() - 1, dot);
    }

    public Dots getUnknownDotsForPeer(Uid peer, Dots known) {
        return this.tree().getUnknownDotsForPeer(peer, known);
    }

    public List<CachedMessage<ProtocolMessage.Payload<State>>> getPayloads(Dots dots) {
        Set indices = ((IterableOnceOps)((IterableOps)this.dotToPayload.filter((Function1 & Serializable)x$1 -> {
            Dot dot = (Dot)x$1._1();
            List list = (List)x$1._2();
            return dots.contains(dot);
        })).flatMap((Function1 & Serializable)x$1 -> {
            Dot dot = (Dot)x$1._1();
            List list = (List)x$1._2();
            return list;
        })).toSet();
        return ((List)this.payloads.zipWithIndex()).collect((PartialFunction)new Serializable(indices){
            private final Set indices$1;
            {
                this.indices$1 = indices$2;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                CachedMessage msgs = (CachedMessage)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.indices$1.contains((Object)BoxesRunTime.boxToInteger((int)i));
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                CachedMessage msgs = (CachedMessage)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (this.indices$1.contains((Object)BoxesRunTime.boxToInteger((int)i))) {
                    return msgs;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public List<CachedMessage<ProtocolMessage.Payload<State>>> getAllPayloads() {
        return this.payloads;
    }

    public Dots getSelfContext() {
        return this.tree().collapse();
    }

    public Dot getNextDot() {
        Option<Dot> option = this.getSelfLeaf();
        if (option instanceof Some) {
            Dot leaf = (Dot)((Some)option).value();
            return leaf.advance();
        }
        if (None$.MODULE$.equals(option)) {
            return Dot$.MODULE$.apply(this.selfUid, 0L);
        }
        throw new MatchError(option);
    }

    public String toString() {
        return String.valueOf(this.tree());
    }

    public String toTreeLikeString() {
        return this.tree().toTreeLikeString();
    }

    public void updateKnowledgeOfPeer(Uid peerUid, Dots lastKnownDots) {
        BooleanRef updatedKnowledge = BooleanRef.create((boolean)false);
        lastKnownDots.peers().foreach((Function1)(JProcedure1 & Serializable)knownPeerUid -> {
            Option lastKnownDot = lastKnownDots.clockOf(knownPeerUid);
            if (this.tree().updateKnowledgeOfPeer(peerUid, (Dot)lastKnownDot.get())) {
                updatedKnowledge$1.elem = true;
                return;
            }
        });
        if (updatedKnowledge.elem) {
            this.tree().collapseGeneralKnowledge();
            return;
        }
    }

    public Dots getSelfKnowledge() {
        return this.tree().getCausalBarriersAsDots();
    }

    public List<Dot> getPredecessors(Dot dot) {
        DotTreeNode dotTreeNode;
        Option<DotTreeNode> option = this.tree().getNodeOfDot(dot);
        if (option instanceof Some && (dotTreeNode = (DotTreeNode)((Some)option).value()) instanceof DotTreeNode.Node) {
            DotTreeNode.Node node = (DotTreeNode.Node)dotTreeNode;
            return this.tree().getPredecessors(node.predecessorNode(), (List<Dot>)package$.MODULE$.List().empty());
        }
        return package$.MODULE$.List().empty();
    }

    public List<Dot> getPredecessors(Uid uid) {
        Option<DotTreeNode.Node> option = this.tree().getLeaf(uid);
        if (option instanceof Some) {
            DotTreeNode.Node node = (DotTreeNode.Node)((Some)option).value();
            return this.tree().getPredecessors(node, (List<Dot>)package$.MODULE$.List().empty());
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }
}

