/*
 * Decompiled with CFR 0.152.
 */
package replication;

import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.Uid;
import rdts.time.Dot;
import rdts.time.Dot$;
import rdts.time.Dots;
import rdts.time.Dots$;
import replication.DotTreeNode;
import replication.DotTreeNode$Node$;
import replication.DotTreeNode$RootNode$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class DotTree {
    private final DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.apply(Dots$.MODULE$.empty(), DotTreeNode$RootNode$.MODULE$.$lessinit$greater$default$2());
    private Map<Uid, DotTreeNode.Node> causalBarriers = Predef$.MODULE$.Map().empty();
    private Map<Uid, DotTreeNode.Node> leaves = Predef$.MODULE$.Map().empty();

    public DotTreeNode.RootNode rootNode() {
        return this.rootNode;
    }

    public Map<Uid, DotTreeNode.Node> causalBarriers() {
        return this.causalBarriers;
    }

    public void causalBarriers_$eq(Map<Uid, DotTreeNode.Node> x$1) {
        this.causalBarriers = x$1;
    }

    public Map<Uid, DotTreeNode.Node> leaves() {
        return this.leaves;
    }

    public void leaves_$eq(Map<Uid, DotTreeNode.Node> x$1) {
        this.leaves = x$1;
    }

    public Option<Dot> getLeafDot(Uid uid) {
        Option option = this.leaves().get((Object)uid);
        if (option instanceof Some) {
            DotTreeNode.Node treeNode = (DotTreeNode.Node)((Some)option).value();
            return Option$.MODULE$.apply((Object)treeNode.dot());
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Option<DotTreeNode.Node> getLeaf(Uid uid) {
        return this.leaves().get((Object)uid);
    }

    private Option<DotTreeNode> getNodeOfDot(Dot dot, DotTreeNode currentNode) {
        DotTreeNode dotTreeNode;
        while (true) {
            if ((dotTreeNode = currentNode) instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.unapply((DotTreeNode.RootNode)dotTreeNode);
                Dots dots = rootNode._1();
                Set<DotTreeNode.Node> set = rootNode._2();
                Dots dots2 = dots;
                if (dots2.contains(dot)) {
                    return Option$.MODULE$.apply((Object)currentNode);
                }
                return None$.MODULE$;
            }
            if (!(dotTreeNode instanceof DotTreeNode.Node)) break;
            DotTreeNode.Node node = (DotTreeNode.Node)dotTreeNode;
            DotTreeNode.Node node2 = DotTreeNode$Node$.MODULE$.unapply(node);
            Dot dot2 = node2._1();
            DotTreeNode dotTreeNode2 = node2._2();
            Dot dot3 = node2._3();
            Option<DotTreeNode.Node> option = node2._4();
            Set<Uid> set = node2._5();
            Dot startNodeDot = dot2;
            DotTreeNode predecessor = dotTreeNode2;
            DotTreeNode.Node node3 = node;
            Dot dot4 = startNodeDot;
            Dot dot5 = dot;
            if (!(dot4 != null ? !dot4.equals(dot5) : dot5 != null)) {
                return Option$.MODULE$.apply((Object)currentNode);
            }
            currentNode = predecessor;
        }
        throw new MatchError((Object)dotTreeNode);
    }

    public Option<DotTreeNode> getNodeOfDot(Dot dot) {
        Option<DotTreeNode.Node> option = this.getLeaf(dot.place());
        if (option instanceof Some) {
            DotTreeNode.Node leaf = (DotTreeNode.Node)((Some)option).value();
            return this.getNodeOfDot(dot, leaf);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public boolean addNode(Dot dot, Dot causalPredecessor) {
        if (this.getNodeOfDot(dot).isDefined()) {
            return false;
        }
        Option leafNodeOption = this.getLeaf(dot.place());
        if (leafNodeOption.isEmpty()) {
            Dot dot2 = dot;
            Dot dot3 = causalPredecessor;
            if (!(dot2 != null ? !dot2.equals(dot3) : dot3 != null) && dot.time() == 0L) {
                DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, this.rootNode(), causalPredecessor, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                this.rootNode().successors_$eq((Set<DotTreeNode.Node>)((Set)this.rootNode().successors().$plus((Object)node)));
                Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)node))));
                Uid uid2 = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                this.causalBarriers_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.causalBarriers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid2, (Object)node))));
                return true;
            }
        }
        if (leafNodeOption.isDefined()) {
            Dot dot4 = dot;
            Dot dot5 = causalPredecessor;
            if (!(dot4 != null ? !dot4.equals(dot5) : dot5 != null) && dot.time() == 0L) {
                DotTreeNode.Node leafNode = (DotTreeNode.Node)leafNodeOption.get();
                Dot dot6 = leafNode.causalPredecessor();
                Dot dot7 = dot;
                if (!(dot6 != null ? !dot6.equals(dot7) : dot7 != null)) {
                    DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, this.rootNode(), causalPredecessor, (Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)leafNode), DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                    this.rootNode().successors_$eq((Set<DotTreeNode.Node>)((Set)this.rootNode().successors().$plus((Object)node)));
                    leafNode.predecessorNode_$eq(node);
                    Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                    this.causalBarriers_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.causalBarriers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)leafNode))));
                    return true;
                }
                return false;
            }
        }
        Dot dot8 = dot;
        Dot dot9 = causalPredecessor;
        if (!(dot8 == null ? dot9 != null : !dot8.equals(dot9)) || dot.time() == 0L) {
            return false;
        }
        Option<DotTreeNode> causalPredecessorNodeOption = this.getNodeOfDot(causalPredecessor);
        Option<DotTreeNode> option = causalPredecessorNodeOption;
        if (option instanceof Some) {
            DotTreeNode dotTreeNode = (DotTreeNode)((Some)option).value();
            if (dotTreeNode instanceof DotTreeNode.Node) {
                DotTreeNode.Node node = (DotTreeNode.Node)dotTreeNode;
                DotTreeNode.Node node2 = DotTreeNode$Node$.MODULE$.unapply(node);
                Dot dot10 = node2._1();
                DotTreeNode dotTreeNode2 = node2._2();
                Dot dot11 = node2._3();
                Option<DotTreeNode.Node> option2 = node2._4();
                Set<Uid> set = node2._5();
                if (option2 instanceof Some) {
                    DotTreeNode.Node node3;
                    DotTreeNode.Node successorNode = node3 = (DotTreeNode.Node)((Some)option2).value();
                    DotTreeNode.Node causalPredecessorNode = node;
                    Dot dot12 = successorNode.dot();
                    Dot dot13 = dot;
                    if (!(dot12 != null ? !dot12.equals(dot13) : dot13 != null)) {
                        return false;
                    }
                    DotTreeNode.Node successorNode2 = node3;
                    DotTreeNode.Node causalPredecessorNode2 = node;
                    Dot dot14 = successorNode2.dot();
                    Dot dot15 = dot;
                    if (dot14 == null ? dot15 != null : !dot14.equals(dot15)) {
                        DotTreeNode.Node node4 = DotTreeNode$Node$.MODULE$.apply(dot, causalPredecessorNode2, causalPredecessor, (Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)successorNode2), DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                        causalPredecessorNode2.successorNode_$eq((Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)node4));
                        successorNode2.predecessorNode_$eq(node4);
                        this.shiftCausalBarrier(dot.place());
                        return true;
                    }
                }
                if (None$.MODULE$.equals(option2)) {
                    DotTreeNode.Node causalPredecessorNode = node;
                    DotTreeNode.Node node5 = DotTreeNode$Node$.MODULE$.apply(dot, causalPredecessorNode, causalPredecessor, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                    causalPredecessorNode.successorNode_$eq((Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)node5));
                    Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                    this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)node5))));
                    this.shiftCausalBarrier(dot.place());
                    return true;
                }
            }
            if (dotTreeNode instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = (DotTreeNode.RootNode)dotTreeNode;
                DotTreeNode.RootNode rootNode2 = DotTreeNode$RootNode$.MODULE$.unapply(rootNode);
                Dots dots = rootNode2._1();
                Set<DotTreeNode.Node> set = rootNode2._2();
                Dots dots2 = dots;
                DotTreeNode.RootNode causalPredecessorNode = rootNode;
                if (dots2.contains(dot)) {
                    return false;
                }
                Dots dots3 = dots;
                DotTreeNode.RootNode causalPredecessorNode3 = rootNode;
                if (!dots3.contains(dot)) {
                    Option option3 = leafNodeOption;
                    if (option3 instanceof Some) {
                        DotTreeNode.Node leafNode = (DotTreeNode.Node)((Some)option3).value();
                        DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, causalPredecessorNode3, causalPredecessor, (Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)leafNode), DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                        leafNode.predecessorNode_$eq(node);
                    } else if (None$.MODULE$.equals(option3)) {
                        DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, causalPredecessorNode3, causalPredecessor, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                        Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                        this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)node))));
                    } else {
                        throw new MatchError(option3);
                    }
                    this.shiftCausalBarrier(dot.place());
                    return true;
                }
            }
        }
        if (None$.MODULE$.equals(option)) {
            if (leafNodeOption.exists((Function1 & Serializable)leaf -> leaf.dot().time() < dot.time())) {
                DotTreeNode.Node leaf2 = (DotTreeNode.Node)leafNodeOption.get();
                DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, leaf2, causalPredecessor, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                leaf2.successorNode_$eq((Option<DotTreeNode.Node>)Option$.MODULE$.apply((Object)node));
                Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
                this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)node))));
                return true;
            }
            if (leafNodeOption.exists((Function1 & Serializable)leaf -> leaf.dot().time() > dot.time())) {
                Option startNode = leafNodeOption;
                while (startNode.isDefined()) {
                    DotTreeNode dotTreeNode;
                    Option option4 = startNode;
                    if (option4 instanceof Some && (dotTreeNode = (DotTreeNode)((Some)option4).value()) instanceof DotTreeNode.Node) {
                        DotTreeNode.Node node = (DotTreeNode.Node)dotTreeNode;
                        DotTreeNode.Node node6 = DotTreeNode$Node$.MODULE$.unapply(node);
                        Dot dot16 = node6._1();
                        DotTreeNode dotTreeNode3 = node6._2();
                        Dot dot17 = node6._3();
                        Option<DotTreeNode.Node> option5 = node6._4();
                        Set<Uid> set = node6._5();
                        Dot currentDot = dot16;
                        if (option5 instanceof Some) {
                            DotTreeNode.Node successorNode = (DotTreeNode.Node)((Some)option5).value();
                            DotTreeNode.Node node7 = node;
                            if (currentDot.time() < dot.time()) {
                                DotTreeNode.Node newNode = DotTreeNode$Node$.MODULE$.apply(dot, node7, causalPredecessor, (Option<DotTreeNode.Node>)Option$.MODULE$.apply((Object)successorNode), DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
                                node7.successorNode_$eq((Option<DotTreeNode.Node>)Some$.MODULE$.apply((Object)newNode));
                                successorNode.predecessorNode_$eq(newNode);
                                startNode = None$.MODULE$;
                                continue;
                            }
                        }
                        Dot currentDot2 = dot16;
                        DotTreeNode causalPredecessorNode = dotTreeNode3;
                        if (currentDot2.time() > dot.time()) {
                            startNode = Option$.MODULE$.apply((Object)causalPredecessorNode);
                            continue;
                        }
                    }
                    return false;
                }
                return true;
            }
            DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(dot, this.rootNode(), causalPredecessor, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
            this.rootNode().successors_$eq((Set<DotTreeNode.Node>)((Set)this.rootNode().successors().$plus((Object)node)));
            Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)dot.place());
            this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)node))));
            return true;
        }
        return false;
    }

    public void shiftCausalBarrier(Uid branch) {
        ObjectRef currentNode = ObjectRef.create((Object)((DotTreeNode.Node)this.causalBarriers().apply((Object)branch)));
        while (((DotTreeNode.Node)currentNode.elem).successorNode().exists((Function1 & Serializable)successor -> {
            Dot dot = successor.causalPredecessor();
            Dot dot2 = ((DotTreeNode.Node)currentNode$1.elem).dot();
            return !(dot != null ? !dot.equals(dot2) : dot2 != null);
        })) {
            currentNode.elem = (DotTreeNode.Node)((DotTreeNode.Node)currentNode.elem).successorNode().get();
        }
        Uid uid = (Uid)Predef$.MODULE$.ArrowAssoc((Object)branch);
        this.causalBarriers_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.causalBarriers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid, (Object)((DotTreeNode.Node)currentNode.elem)))));
    }

    public void addNewLeaf(Dot newLeaf, Uid uid) {
        Tuple2 tuple2;
        Option<DotTreeNode.Node> option = this.getLeaf(uid);
        if (option instanceof Some) {
            DotTreeNode.Node leaf = (DotTreeNode.Node)((Some)option).value();
            tuple2 = Tuple2$.MODULE$.apply((Object)leaf.dot(), (Object)leaf);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = Tuple2$.MODULE$.apply(this.rootNode().dots().clockOf(uid).getOrElse(() -> DotTree.$anonfun$1(uid)), (Object)this.rootNode());
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple22 = tuple2;
        Dot predecessorDot = (Dot)tuple22._1();
        DotTreeNode predecessorNode = (DotTreeNode)tuple22._2();
        DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.apply(newLeaf, predecessorNode, predecessorDot, (Option<DotTreeNode.Node>)None$.MODULE$, DotTreeNode$Node$.MODULE$.$lessinit$greater$default$5());
        Uid uid2 = (Uid)Predef$.MODULE$.ArrowAssoc((Object)uid);
        this.leaves_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.leaves().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid2, (Object)node))));
        Uid uid3 = (Uid)Predef$.MODULE$.ArrowAssoc((Object)uid);
        this.causalBarriers_$eq((Map<Uid, DotTreeNode.Node>)((Map)this.causalBarriers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uid3, (Object)node))));
    }

    private Dots collectBranch(Dots dots, DotTreeNode node) {
        DotTreeNode dotTreeNode;
        while (true) {
            if ((dotTreeNode = node) instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.unapply((DotTreeNode.RootNode)dotTreeNode);
                Dots dots2 = rootNode._1();
                Set<DotTreeNode.Node> set = rootNode._2();
                return dots;
            }
            if (!(dotTreeNode instanceof DotTreeNode.Node)) break;
            DotTreeNode.Node node2 = DotTreeNode$Node$.MODULE$.unapply((DotTreeNode.Node)dotTreeNode);
            Dot dot = node2._1();
            DotTreeNode dotTreeNode2 = node2._2();
            Dot dot2 = node2._3();
            Option<DotTreeNode.Node> option = node2._4();
            Set<Uid> set = node2._5();
            Dot dot3 = dot;
            DotTreeNode predecessor = dotTreeNode2;
            Dots dots3 = dots.add(dot3);
            DotTreeNode dotTreeNode3 = predecessor;
            dots = dots3;
            node = dotTreeNode3;
        }
        throw new MatchError((Object)dotTreeNode);
    }

    public Dots collapse() {
        return (Dots)this.leaves().foldLeft((Object)this.rootNode().dots(), (Function2 & Serializable)(dots, leaf) -> this.collectBranch((Dots)dots, (DotTreeNode)leaf._2()));
    }

    public Dots getLeavesAsDots() {
        return (Dots)this.leaves().foldLeft((Object)Dots$.MODULE$.empty(), (Function2 & Serializable)(dots, leaf) -> dots.add(((DotTreeNode.Node)leaf._2()).dot()));
    }

    public Dots getCausalBarriersAsDots() {
        return (Dots)this.causalBarriers().foldLeft((Object)Dots$.MODULE$.empty(), (Function2 & Serializable)(dots, causalBarrier) -> dots.add(((DotTreeNode.Node)causalBarrier._2()).dot()));
    }

    public String toString() {
        ObjectRef string = ObjectRef.create((Object)"leaves:\n");
        this.leaves().foreach((Function1)(JProcedure1 & Serializable)leaf -> {
            string$1.elem = (String)string$1.elem + ("\t" + leaf._1() + " -> " + leaf._2() + "\n");
        });
        string.elem = (String)string.elem + ("root: " + this.rootNode());
        return (String)string.elem;
    }

    public String toTreeLikeString() {
        ObjectRef string = ObjectRef.create((Object)("root: " + this.rootNode().dots() + "\n"));
        this.rootNode().successors().foreach((Function1)(JProcedure1 & Serializable)node -> {
            string$2.elem = (String)string$2.elem + DotTree.inner$1(node);
        });
        return (String)string.elem;
    }

    public final List<Dot> getPredecessors(DotTreeNode node, List<Dot> predecessors) {
        DotTreeNode dotTreeNode;
        while (true) {
            DotTreeNode predecessor;
            if ((dotTreeNode = node) instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.unapply((DotTreeNode.RootNode)dotTreeNode);
                Dots dots = rootNode._1();
                Set<DotTreeNode.Node> set = rootNode._2();
                Dots dots2 = dots;
                return predecessors;
            }
            if (!(dotTreeNode instanceof DotTreeNode.Node)) break;
            DotTreeNode.Node node2 = DotTreeNode$Node$.MODULE$.unapply((DotTreeNode.Node)dotTreeNode);
            Dot dot = node2._1();
            DotTreeNode dotTreeNode2 = node2._2();
            Dot dot2 = node2._3();
            Option<DotTreeNode.Node> option = node2._4();
            Set<Uid> set = node2._5();
            Dot dot3 = dot;
            DotTreeNode dotTreeNode3 = predecessor = dotTreeNode2;
            List list = (List)predecessors.$colon$plus((Object)dot3);
            node = dotTreeNode3;
            predecessors = list;
        }
        throw new MatchError((Object)dotTreeNode);
    }

    public Dot getNextDot(Uid uid) {
        Option<DotTreeNode.Node> option = this.getLeaf(uid);
        if (option instanceof Some) {
            DotTreeNode.Node node = (DotTreeNode.Node)((Some)option).value();
            return node.dot().advance();
        }
        if (None$.MODULE$.equals(option)) {
            return Dot$.MODULE$.apply(uid, 0L);
        }
        throw new MatchError(option);
    }

    private Dots getCompleteBranchWithoutRoot(DotTreeNode currentNode, Dots slice) {
        DotTreeNode dotTreeNode;
        while (true) {
            DotTreeNode predecessor;
            if ((dotTreeNode = currentNode) instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.unapply((DotTreeNode.RootNode)dotTreeNode);
                Dots dots = rootNode._1();
                Set<DotTreeNode.Node> set = rootNode._2();
                Dots dots2 = dots;
                return slice;
            }
            if (!(dotTreeNode instanceof DotTreeNode.Node)) break;
            DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.unapply((DotTreeNode.Node)dotTreeNode);
            Dot dot = node._1();
            DotTreeNode dotTreeNode2 = node._2();
            Dot dot2 = node._3();
            Option<DotTreeNode.Node> option = node._4();
            Set<Uid> set = node._5();
            Dot dot3 = dot;
            DotTreeNode dotTreeNode3 = predecessor = dotTreeNode2;
            Dots dots = slice.add(dot3);
            currentNode = dotTreeNode3;
            slice = dots;
        }
        throw new MatchError((Object)dotTreeNode);
    }

    private Dots getSliceOfBranch(DotTreeNode startNode, Dot stop, Dots slice) {
        DotTreeNode dotTreeNode;
        while (true) {
            DotTreeNode predecessor;
            if ((dotTreeNode = startNode) instanceof DotTreeNode.RootNode) {
                DotTreeNode.RootNode rootNode = DotTreeNode$RootNode$.MODULE$.unapply((DotTreeNode.RootNode)dotTreeNode);
                Dots dots = rootNode._1();
                Set<DotTreeNode.Node> set = rootNode._2();
                Dots dots2 = dots;
                if (dots2.contains(stop)) {
                    Lattice Lattice_this = Dots$.MODULE$.lattice();
                    return (Dots)Lattice_this.merge((Object)slice, (Object)dots2);
                }
                throw new IllegalStateException("Dot " + stop + " not yet known to this replica");
            }
            if (!(dotTreeNode instanceof DotTreeNode.Node)) break;
            DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.unapply((DotTreeNode.Node)dotTreeNode);
            Dot dot = node._1();
            DotTreeNode dotTreeNode2 = node._2();
            Dot dot2 = node._3();
            Option<DotTreeNode.Node> option = node._4();
            Set<Uid> set = node._5();
            Dot dot3 = dot;
            DotTreeNode predecessor2 = dotTreeNode2;
            Dot dot4 = dot3;
            Dot dot5 = stop;
            if (!(dot4 != null ? !dot4.equals(dot5) : dot5 != null)) {
                return slice;
            }
            Dot dot6 = dot;
            DotTreeNode dotTreeNode3 = predecessor = dotTreeNode2;
            Dots dots = slice.add(dot6);
            startNode = dotTreeNode3;
            slice = dots;
        }
        throw new MatchError((Object)dotTreeNode);
    }

    public Dots getUnknownDotsForPeer(Uid peer2, Dots known) {
        Set knownPeers = this.leaves().keySet();
        Set knownPeersOfPeer = known.peers();
        Map leavesOfPeer = Predef$.MODULE$.Map().empty();
        ObjectRef unknownPeersByPeer = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef unknownDotsByPeer = ObjectRef.create((Object)Dots$.MODULE$.empty());
        this.leaves().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Uid uid = (Uid)x$1._1();
            DotTreeNode.Node node = (DotTreeNode.Node)x$1._2();
            Option option = known.clockOf(uid);
            if (option instanceof Some) {
                Dot dot;
                Dot leafKnownPeer = dot = (Dot)((Some)option).value();
                if (node.dot().time() < leafKnownPeer.time()) {
                    throw new IllegalStateException("Knowledge of peer augments local knowledge on branch of peer: " + uid + ". Last known dot locally: " + node + " vs dot known by peer: " + leafKnownPeer);
                }
                Dot leafKnownPeer2 = dot;
                if (node.dot().time() > leafKnownPeer2.time()) {
                    unknownDotsByPeer$1.elem = this.getSliceOfBranch(node, leafKnownPeer2, (Dots)unknownDotsByPeer$1.elem);
                    return;
                }
                Dot leafKnownPeer3 = dot;
                return;
            }
            if (None$.MODULE$.equals(option)) {
                unknownPeersByPeer$1.elem = (Set)((Set)unknownPeersByPeer$1.elem).$plus((Object)uid);
                return;
            }
            throw new MatchError((Object)option);
        });
        BooleanRef addRoot = BooleanRef.create((boolean)false);
        ((Set)unknownPeersByPeer.elem).foreach((Function1)(JProcedure1 & Serializable)peer -> {
            addRoot$1.elem = this.rootNode().dots().max(peer).isDefined();
            unknownDotsByPeer$2.elem = this.getCompleteBranchWithoutRoot((DotTreeNode)this.getLeaf((Uid)peer).get(), (Dots)unknownDotsByPeer$2.elem);
        });
        if (addRoot.elem) {
            Lattice Lattice_this = Dots$.MODULE$.lattice();
            Dots left$proxy1 = (Dots)unknownDotsByPeer.elem;
            Dots right$proxy1 = this.rootNode().dots();
            unknownDotsByPeer.elem = (Dots)Lattice_this.merge((Object)left$proxy1, (Object)right$proxy1);
        }
        return (Dots)unknownDotsByPeer.elem;
    }

    public Dots getCausalBarriers() {
        return (Dots)this.causalBarriers().values().foldLeft((Object)Dots$.MODULE$.empty(), (Function2 & Serializable)(dots, node) -> dots.add(node.dot()));
    }

    public boolean updateKnowledgeOfPeer(Uid peerUid, Dot lastKnownDot) {
        DotTreeNode dotTreeNode;
        Option<DotTreeNode> option = this.getNodeOfDot(lastKnownDot);
        if (option instanceof Some && (dotTreeNode = (DotTreeNode)((Some)option).value()) instanceof DotTreeNode.Node) {
            DotTreeNode.Node node = DotTreeNode$Node$.MODULE$.unapply((DotTreeNode.Node)dotTreeNode);
            Dot dot = node._1();
            DotTreeNode dotTreeNode2 = node._2();
            Dot dot2 = node._3();
            Option<DotTreeNode.Node> option2 = node._4();
            Set<Uid> set = node._5();
            DotTreeNode.Node node2 = (DotTreeNode.Node)dotTreeNode;
            node2.knownBy_$eq((Set<Uid>)((Set)node2.knownBy().$plus((Object)peerUid)));
            DotTreeNode predecessor = node2.predecessorNode();
            while (true) {
                DotTreeNode dotTreeNode3 = predecessor;
                DotTreeNode.RootNode rootNode = this.rootNode();
                if (!(dotTreeNode3 == null ? rootNode != null : !dotTreeNode3.equals(rootNode))) break;
                DotTreeNode.Node node3 = (DotTreeNode.Node)predecessor;
                node3.knownBy_$eq((Set<Uid>)((Set)node3.knownBy().$plus((Object)peerUid)));
                predecessor = ((DotTreeNode.Node)predecessor).predecessorNode();
            }
            return true;
        }
        return false;
    }

    public void collapseGeneralKnowledge() {
        int numberOfKnownPeers = this.leaves().keySet().size() - 1;
        this.rootNode().successors().foreach((Function1)(JProcedure1 & Serializable)startNode -> {
            Option<DotTreeNode.Node> currentNode = Option$.MODULE$.apply(startNode);
            while (currentNode.exists((Function1 & Serializable)node -> node.knownBy().size() == numberOfKnownPeers && node.successorNode().exists((Function1 & Serializable)successorNode -> {
                Dot dot = successorNode.causalPredecessor();
                Dot dot2 = node.dot();
                return !(dot != null ? !dot.equals(dot2) : dot2 != null);
            }))) {
                Option<DotTreeNode.Node> nextNode = ((DotTreeNode.Node)currentNode.get()).successorNode();
                this.rootNode().successors_$eq((Set<DotTreeNode.Node>)((Set)this.rootNode().successors().$minus(currentNode.get())));
                this.rootNode().addDot(((DotTreeNode.Node)currentNode.get()).dot());
                this.rootNode().successors_$eq((Set<DotTreeNode.Node>)((Set)this.rootNode().successors().$plus(nextNode.get())));
                ((DotTreeNode.Node)nextNode.get()).predecessorNode_$eq(this.rootNode());
                currentNode = nextNode;
            }
        });
    }

    private static final Dot $anonfun$1(Uid uid$1) {
        return Dot$.MODULE$.apply(uid$1, 0L);
    }

    private static final String inner$1(DotTreeNode.Node node) {
        Option<DotTreeNode.Node> option = node.successorNode();
        if (option instanceof Some) {
            DotTreeNode.Node successorNode = (DotTreeNode.Node)((Some)option).value();
            return "-> " + node.dot() + " " + DotTree.inner$1(successorNode);
        }
        if (None$.MODULE$.equals(option)) {
            return "-> " + node.dot() + " -> None\n";
        }
        throw new MatchError(option);
    }
}

