/*
 * Decompiled with CFR 0.152.
 */
package replication;

import java.io.Serializable;
import rdts.base.Uid;
import rdts.time.Dot;
import rdts.time.Dots;
import replication.ProtocolMessage$;
import replication.ProtocolMessage$Payload$;
import replication.ProtocolMessage$Ping$;
import replication.ProtocolMessage$Pong$;
import replication.ProtocolMessage$Request$;
import scala.Product;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public interface ProtocolMessage<T> {
    public static int ordinal(ProtocolMessage<?> protocolMessage) {
        return ProtocolMessage$.MODULE$.ordinal(protocolMessage);
    }

    public static class Payload<T>
    implements ProtocolMessage<T>,
    Product,
    Serializable {
        private final Set<Uid> senders;
        private final Dots dots;
        private final T data;
        private final Dots causalPredecessors;
        private final Dots lastKnownDots;

        public static <T> Payload<T> apply(Set<Uid> set, Dots dots, T t) {
            return ProtocolMessage$Payload$.MODULE$.apply(set, dots, t);
        }

        public static <T> Payload<T> apply(Set<Uid> set, Dots dots, T t, Dots dots2, Dots dots3) {
            return ProtocolMessage$Payload$.MODULE$.apply(set, dots, t, dots2, dots3);
        }

        public static <T> Payload<T> apply(Uid uid, Dots dots, T t) {
            return ProtocolMessage$Payload$.MODULE$.apply(uid, dots, t);
        }

        public static <T> Payload<T> apply(Uid uid, Dots dots, T t, Dots dots2) {
            return ProtocolMessage$Payload$.MODULE$.apply(uid, dots, t, dots2);
        }

        public static Payload<?> fromProduct(Product product) {
            return ProtocolMessage$Payload$.MODULE$.fromProduct(product);
        }

        public static <T> Payload<T> unapply(Payload<T> payload) {
            return ProtocolMessage$Payload$.MODULE$.unapply(payload);
        }

        public Payload(Set<Uid> senders, Dots dots, T data, Dots causalPredecessors, Dots lastKnownDots) {
            this.senders = senders;
            this.dots = dots;
            this.data = data;
            this.causalPredecessors = causalPredecessors;
            this.lastKnownDots = lastKnownDots;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 215499585, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Payload)) return false;
            Payload payload = (Payload)object;
            Set<Uid> set = this.senders();
            Set<Uid> set2 = payload.senders();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Dots dots = this.dots();
            Dots dots2 = payload.dots();
            if (dots == null) {
                if (dots2 != null) {
                    return false;
                }
            } else if (!dots.equals(dots2)) return false;
            if (!BoxesRunTime.equals(this.data(), payload.data())) return false;
            Dots dots3 = this.causalPredecessors();
            Dots dots4 = payload.causalPredecessors();
            if (dots3 == null) {
                if (dots4 != null) {
                    return false;
                }
            } else if (!dots3.equals(dots4)) return false;
            Dots dots5 = this.lastKnownDots();
            Dots dots6 = payload.lastKnownDots();
            if (dots5 == null) {
                if (dots6 != null) {
                    return false;
                }
            } else if (!dots5.equals(dots6)) return false;
            if (!payload.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Payload;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Payload";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "senders";
                }
                case 1: {
                    return "dots";
                }
                case 2: {
                    return "data";
                }
                case 3: {
                    return "causalPredecessors";
                }
                case 4: {
                    return "lastKnownDots";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Uid> senders() {
            return this.senders;
        }

        public Dots dots() {
            return this.dots;
        }

        public T data() {
            return this.data;
        }

        public Dots causalPredecessors() {
            return this.causalPredecessors;
        }

        public Dots lastKnownDots() {
            return this.lastKnownDots;
        }

        public Payload<T> addSender(Uid s) {
            return this.copy((Set<Uid>)((Set)this.senders().$plus((Object)s)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Payload<T> addLastKnownDot(Dot lastKnownDot) {
            Dots dots = this.lastKnownDots().add(lastKnownDot);
            Set<Uid> set = this.copy$default$1();
            Dots dots2 = this.copy$default$2();
            T t = this.copy$default$3();
            Dots dots3 = this.copy$default$4();
            return this.copy(set, dots2, t, dots3, dots);
        }

        public <T> Payload<T> copy(Set<Uid> senders, Dots dots, T data, Dots causalPredecessors, Dots lastKnownDots) {
            return new Payload<T>(senders, dots, data, causalPredecessors, lastKnownDots);
        }

        public <T> Set<Uid> copy$default$1() {
            return this.senders();
        }

        public <T> Dots copy$default$2() {
            return this.dots();
        }

        public <T> T copy$default$3() {
            return this.data();
        }

        public <T> Dots copy$default$4() {
            return this.causalPredecessors();
        }

        public <T> Dots copy$default$5() {
            return this.lastKnownDots();
        }

        public Set<Uid> _1() {
            return this.senders();
        }

        public Dots _2() {
            return this.dots();
        }

        public T _3() {
            return this.data();
        }

        public Dots _4() {
            return this.causalPredecessors();
        }

        public Dots _5() {
            return this.lastKnownDots();
        }
    }

    public static class Ping
    implements ProtocolMessage<Nothing$>,
    Product,
    Serializable {
        private final long time;

        public static Ping apply(long l) {
            return ProtocolMessage$Ping$.MODULE$.apply(l);
        }

        public static Ping fromProduct(Product product) {
            return ProtocolMessage$Ping$.MODULE$.fromProduct(product);
        }

        public static Ping unapply(Ping ping) {
            return ProtocolMessage$Ping$.MODULE$.unapply(ping);
        }

        public Ping(long time) {
            this.time = time;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2487698);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.time()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ping)) return false;
            Ping ping = (Ping)object;
            if (this.time() != ping.time()) return false;
            if (!ping.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Ping;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Ping";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "time";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long time() {
            return this.time;
        }

        public Ping copy(long time) {
            return new Ping(time);
        }

        public long copy$default$1() {
            return this.time();
        }

        public long _1() {
            return this.time();
        }
    }

    public static class Pong
    implements ProtocolMessage<Nothing$>,
    Product,
    Serializable {
        private final long time;

        public static Pong apply(long l) {
            return ProtocolMessage$Pong$.MODULE$.apply(l);
        }

        public static Pong fromProduct(Product product) {
            return ProtocolMessage$Pong$.MODULE$.fromProduct(product);
        }

        public static Pong unapply(Pong pong) {
            return ProtocolMessage$Pong$.MODULE$.unapply(pong);
        }

        public Pong(long time) {
            this.time = time;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2493464);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.time()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pong)) return false;
            Pong pong = (Pong)object;
            if (this.time() != pong.time()) return false;
            if (!pong.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pong;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Pong";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "time";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long time() {
            return this.time;
        }

        public Pong copy(long time) {
            return new Pong(time);
        }

        public long copy$default$1() {
            return this.time();
        }

        public long _1() {
            return this.time();
        }
    }

    public static class Request
    implements ProtocolMessage<Nothing$>,
    Product,
    Serializable {
        private final Uid sender;
        private final Dots knows;

        public static Request apply(Uid uid, Dots dots) {
            return ProtocolMessage$Request$.MODULE$.apply(uid, dots);
        }

        public static Request fromProduct(Product product) {
            return ProtocolMessage$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return ProtocolMessage$Request$.MODULE$.unapply(request);
        }

        public Request(Uid sender, Dots knows) {
            this.sender = sender;
            this.knows = knows;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1878821404, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            Uid uid = this.sender();
            Uid uid2 = request.sender();
            if (uid == null) {
                if (uid2 != null) {
                    return false;
                }
            } else if (!uid.equals(uid2)) return false;
            Dots dots = this.knows();
            Dots dots2 = request.knows();
            if (dots == null) {
                if (dots2 != null) {
                    return false;
                }
            } else if (!dots.equals(dots2)) return false;
            if (!request.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sender";
            }
            if (1 == n2) {
                return "knows";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Uid sender() {
            return this.sender;
        }

        public Dots knows() {
            return this.knows;
        }

        public Request copy(Uid sender, Dots knows) {
            return new Request(sender, knows);
        }

        public Uid copy$default$1() {
            return this.sender();
        }

        public Dots copy$default$2() {
            return this.knows();
        }

        public Uid _1() {
            return this.sender();
        }

        public Dots _2() {
            return this.knows();
        }
    }
}

