/*
 * Decompiled with CFR 0.152.
 */
package channels;

import channels.Connection;
import channels.JioInputStreamAdapter;
import channels.JioOutputStreamAdapter;
import channels.MessageBuffer;
import channels.Receive;
import de.rmgk.delay;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class JIOStreamConnection
implements Connection<MessageBuffer> {
    private final Function0<BoxedUnit> doClose;
    private final JioInputStreamAdapter inputStream;
    private final JioOutputStreamAdapter outputStream;

    public JIOStreamConnection(InputStream in, OutputStream out, Function0<BoxedUnit> doClose) {
        this.doClose = doClose;
        this.inputStream = new JioInputStreamAdapter(in);
        this.outputStream = new JioOutputStreamAdapter(out);
    }

    public JioInputStreamAdapter inputStream() {
        return this.inputStream;
    }

    public JioOutputStreamAdapter outputStream() {
        return this.outputStream;
    }

    @Override
    public delay.Async<Object, BoxedUnit> send(MessageBuffer data) {
        return new delay.Async((Function1 & Serializable)ctx -> (JProcedure1 & Serializable)cb -> {
            try {
                delay.Sync async = new delay.Sync((Function1)(JProcedure1 & Serializable)x -> this.outputStream().send(data));
                ((Function1)async.handleInCtx().apply(ctx)).apply(cb);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    delay.Callback Callback_this = cb;
                    Callback_this.complete((Try)Failure$.MODULE$.apply(e));
                }
                throw throwable;
            }
        });
    }

    @Override
    public void close() {
        this.doClose.apply$mcV$sp();
    }

    public void loopHandler(Receive<MessageBuffer> handler) {
        this.inputStream().loopReceive(handler.messageHandler(this));
    }
}

