/*
 * Decompiled with CFR 0.152.
 */
package container;

import de.tud.cs.peaks.osgi.framework.api.IAnalysisService;
import de.tud.cs.peaks.osgi.framework.api.data.IAnalysisConfig;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.instrument.IllegalClassFormatException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.felix.service.command.Descriptor;
import org.knopflerfish.service.console.CommandGroupAdapter;
import org.knopflerfish.service.console.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.FrameworkWiring;

class HostService
extends CommandGroupAdapter {
    public static final String USAGE_SOOTKEEPER = "";
    public static final String[] HELP_SOOTKEEPER = new String[]{""};
    public static final String SOOTKEEPER_NAME = "sootkeeper";
    private final BundleContext context;
    private final Map<String, String> analyses;
    private final Map<String, String> hiddenAnalyses;
    private String[] previous;

    HostService(BundleContext context) {
        super(SOOTKEEPER_NAME, USAGE_SOOTKEEPER);
        this.context = context;
        this.analyses = new HashMap<String, String>();
        this.hiddenAnalyses = new HashMap<String, String>();
    }

    public void listAnalyses() {
        this.findAnalyses();
        System.out.println("Available analyses:");
        for (String analysis : this.analyses.keySet()) {
            System.out.print('\t');
            System.out.println(analysis);
        }
    }

    private void findAnalyses() {
        this.analyses.clear();
        try {
            ServiceReference[] serviceReferences;
            for (ServiceReference serviceReference : serviceReferences = this.context.getAllServiceReferences(null, null)) {
                Object service = this.context.getService(serviceReference);
                if (service instanceof IAnalysisService) {
                    String shortName = ((IAnalysisService)service).getName();
                    String className = service.getClass().getName();
                    if (!((IAnalysisService)service).shouldBeHidden()) {
                        this.analyses.put(shortName, className);
                    } else {
                        this.hiddenAnalyses.put(shortName, className);
                    }
                }
                this.context.ungetService(serviceReference);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void la() {
        this.listAnalyses();
    }

    public void ra(String ... params) throws IllegalClassFormatException {
        this.runAnalysis(params);
    }

    @Descriptor(value="Runs an analysis")
    public void runAnalysis(String ... params) throws IllegalClassFormatException {
        if (params.length < 1) {
            System.out.println("Please provide an analysis name.");
            return;
        }
        this.previous = (String[])params.clone();
        this.findAnalyses();
        String analysis = params[0];
        String classNameOfService = this.analyses.get(analysis);
        if (classNameOfService == null) {
            classNameOfService = this.hiddenAnalyses.get(analysis);
        }
        if (classNameOfService == null) {
            System.out.println("Could not run: " + analysis);
            return;
        }
        ServiceReference serviceReference = this.context.getServiceReference(classNameOfService);
        IAnalysisService service = (IAnalysisService)this.context.getService(serviceReference);
        IAnalysisConfig iAnalysisConfig = service.parseConfig(Arrays.copyOfRange(params, 1, params.length));
        Future r = service.performAnalysis(iAnalysisConfig);
        this.context.ungetService(serviceReference);
    }

    public void rep() throws IllegalClassFormatException {
        if (this.previous != null) {
            this.runAnalysis(this.previous);
        } else {
            System.out.println("Use real commands first.");
        }
    }

    public void updateAnalysis(String name) {
        try {
            this.findAnalyses();
            System.out.println("Updating " + name);
            String classNameOfService = this.analyses.get(name);
            if (classNameOfService == null) {
                classNameOfService = this.hiddenAnalyses.get(name);
            }
            if (classNameOfService == null) {
                System.out.println("Could not find: " + name);
                return;
            }
            ServiceReference serviceReference = this.context.getServiceReference(classNameOfService);
            IAnalysisService service = (IAnalysisService)this.context.getService(serviceReference);
            service.getBundle().update();
            ((FrameworkWiring)this.context.getBundle(0L).adapt(FrameworkWiring.class)).refreshBundles(Collections.singleton(service.getBundle()), new FrameworkListener[]{new UpdateListener(name)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ua(String name) {
        this.updateAnalysis(name);
    }

    public void ua() {
        this.updateAnalysis();
    }

    public void updateAnalysis() {
        if (this.previous != null) {
            this.updateAnalysis(this.previous[0]);
        } else {
            System.out.println("This only works when an analysis was run previously, please provide a name");
        }
    }

    public int cmdSOOTKEEPER(Dictionary opts, Reader in, PrintWriter Out, Session session) {
        return 0;
    }

    private class UpdateListener
    implements FrameworkListener {
        private final String analysis;

        private UpdateListener(String analysis) {
            this.analysis = analysis;
        }

        public void frameworkEvent(FrameworkEvent event) {
            System.out.println("Updated " + this.analysis);
        }
    }
}

