/*
 * Decompiled with CFR 0.152.
 */
package de.tud.cs.peaks.osgi.framework.api;

import com.google.common.base.Stopwatch;
import de.tud.cs.peaks.osgi.framework.api.IAnalysisService;
import de.tud.cs.peaks.osgi.framework.api.data.IAnalysisConfig;
import de.tud.cs.peaks.osgi.framework.api.data.IAnalysisResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.IllegalClassFormatException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractAnalysisService<Result extends IAnalysisResult, Config extends IAnalysisConfig>
implements IAnalysisService<Result, Config> {
    private static final ExecutorService POOL = new ForkJoinPool();
    private final Map<IAnalysisConfig, Future<Result>> results = new ConcurrentHashMap<IAnalysisConfig, Future<Result>>();
    private final BundleContext context;
    private final Bundle bundle;
    private boolean checked = false;

    protected AbstractAnalysisService(BundleContext context) {
        this.context = context;
        this.bundle = context.getBundle();
    }

    @Override
    public final Future<Result> performAnalysis(Config config) throws IllegalClassFormatException {
        this.checkService();
        Stopwatch overall = Stopwatch.createStarted();
        if (this.results.containsKey(config)) {
            overall.stop();
            this.logTime(overall);
            System.out.println(this.getName() + " has run for " + overall.elapsed(TimeUnit.MILLISECONDS) + " ms. The result was cached.");
            return this.results.get(config);
        }
        System.out.println("In " + this.getName() + " Submitting task: " + config);
        Future<IAnalysisResult> result = POOL.submit(() -> {
            HashMap<Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>>, IAnalysisResult> results1 = new HashMap<Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>>, IAnalysisResult>();
            HashMap futureResults = new HashMap();
            for (Class<AbstractAnalysisService<IAnalysisResult, IAnalysisConfig>> clazz : this.getDependOnAnalyses()) {
                AbstractAnalysisService analysis = this.getServiceInstance(clazz);
                IAnalysisConfig analysisConfig = this.convertConfig(config, clazz);
                Future analysisResult = analysis.performAnalysis(analysisConfig);
                futureResults.put(clazz, analysisResult);
            }
            for (Map.Entry entry : futureResults.entrySet()) {
                results1.put((Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>>)entry.getKey(), (IAnalysisResult)((Future)entry.getValue()).get());
                this.ungetService((Class)entry.getKey());
            }
            Stopwatch analysisWatch = Stopwatch.createStarted();
            Object Result = this.runAnalysis(config, results1);
            overall.stop();
            analysisWatch.stop();
            this.logTime(analysisWatch);
            System.out.println(this.getName() + " has run for " + overall.elapsed(TimeUnit.MILLISECONDS) + " ms, " + analysisWatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
            return Result;
        });
        this.results.put((IAnalysisConfig)config, (Future<Result>)result);
        return result;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public boolean shouldBeHidden() {
        return false;
    }

    private synchronized <R extends IAnalysisResult, C extends IAnalysisConfig> AbstractAnalysisService<R, C> getServiceInstance(Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>> serviceClass) throws IllegalArgumentException {
        ServiceReference ref;
        if (this.context != null && (ref = this.context.getServiceReference(serviceClass.getName())) != null) {
            Object service = this.context.getService(ref);
            if (service instanceof AbstractAnalysisService) {
                return (AbstractAnalysisService)this.context.getService(ref);
            }
            throw new IllegalArgumentException(serviceClass.getName() + " is no IAnalysisService");
        }
        throw new IllegalArgumentException(serviceClass.getName() + " is not a registered service");
    }

    private synchronized void ungetService(Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>> serviceClass) throws IllegalArgumentException {
        ServiceReference ref;
        if (this.context != null && (ref = this.context.getServiceReference(serviceClass.getName())) != null) {
            Object service = this.context.getService(ref);
            if (service instanceof AbstractAnalysisService) {
                this.context.ungetService(ref);
                return;
            }
            throw new IllegalArgumentException(serviceClass.getName() + " is no IAnalysisService");
        }
        throw new IllegalArgumentException(serviceClass.getName() + " is not a registered service");
    }

    private void checkService() throws IllegalClassFormatException, IllegalStateException {
        if (this.checked) {
            return;
        }
        for (Class<AbstractAnalysisService<IAnalysisResult, IAnalysisConfig>> analysis : this.getDependOnAnalyses()) {
            ServiceReference ref = this.context.getServiceReference(analysis.getName());
            if (ref != null) continue;
            throw new IllegalStateException("Required AnalysisService " + analysis.getName() + " is not registered");
        }
        this.checked = true;
    }

    protected abstract List<Class<? extends AbstractAnalysisService<? extends IAnalysisResult, ? extends IAnalysisConfig>>> getDependOnAnalyses();

    private void logTime(Stopwatch time) {
        File f = new File("timings.txt");
        try (FileWriter fw = new FileWriter(f, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println(this.getName() + "," + time.elapsed(TimeUnit.SECONDS));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

