/*
 * Decompiled with CFR 0.152.
 */
package kofre.primitives;

import java.io.Serializable;
import kofre.base.Lattice;
import kofre.base.Lattice$;
import kofre.primitives.CausalQueue$;
import kofre.primitives.CausalQueue$QueueElement$;
import kofre.time.Dot;
import kofre.time.Dot$;
import kofre.time.Dots;
import kofre.time.VectorClock;
import kofre.time.VectorClock$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Queue;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CausalQueue<T>
implements Product,
Serializable {
    private final Queue values;
    private final VectorClock latest;
    private final Dots removed;

    public static <T> CausalQueue<T> apply(Queue<QueueElement<T>> queue, VectorClock vectorClock, Dots dots) {
        return CausalQueue$.MODULE$.apply(queue, vectorClock, dots);
    }

    public static <T> CausalQueue<T> empty() {
        return CausalQueue$.MODULE$.empty();
    }

    public static CausalQueue<?> fromProduct(Product product) {
        return CausalQueue$.MODULE$.fromProduct(product);
    }

    public static <A> Lattice<CausalQueue<A>> lattice(Ordering<A> ordering) {
        return CausalQueue$.MODULE$.lattice(ordering);
    }

    public static <T> CausalQueue<T> unapply(CausalQueue<T> causalQueue) {
        return CausalQueue$.MODULE$.unapply(causalQueue);
    }

    public CausalQueue(Queue<QueueElement<T>> values, VectorClock latest, Dots removed) {
        this.values = values;
        this.latest = latest;
        this.removed = removed;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CausalQueue)) return false;
        CausalQueue causalQueue = (CausalQueue)object;
        Queue<QueueElement<T>> queue = this.values();
        Queue<QueueElement<T>> queue2 = causalQueue.values();
        if (queue == null) {
            if (queue2 != null) {
                return false;
            }
        } else if (!queue.equals(queue2)) return false;
        VectorClock vectorClock = this.latest();
        VectorClock vectorClock2 = causalQueue.latest();
        if (vectorClock == null) {
            if (vectorClock2 != null) {
                return false;
            }
        } else if (!((Object)vectorClock).equals(vectorClock2)) return false;
        Dots dots = this.removed();
        Dots dots2 = causalQueue.removed();
        if (dots == null) {
            if (dots2 != null) {
                return false;
            }
        } else if (!((Object)dots).equals(dots2)) return false;
        if (!causalQueue.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CausalQueue;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "CausalQueue";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "values";
            }
            case 1: {
                return "latest";
            }
            case 2: {
                return "removed";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Queue<QueueElement<T>> values() {
        return this.values;
    }

    public VectorClock latest() {
        return this.latest;
    }

    public Dots removed() {
        return this.removed;
    }

    public CausalQueue<T> enqueue(T e, String replicaID) {
        VectorClock dot = this.latest().inc(replicaID);
        VectorClock time = Lattice$.MODULE$.Operators(this.latest(), VectorClock$.MODULE$.lattice()).merge(dot);
        return CausalQueue$.MODULE$.apply(this.values().enqueue(CausalQueue$QueueElement$.MODULE$.apply(e, Dot$.MODULE$.apply(replicaID, BoxesRunTime.unboxToLong((Object)dot.timestamps().apply((Object)replicaID))), time)), time, this.removed());
    }

    public CausalQueue<T> dequeue() {
        QueueElement queueElement;
        Tuple2 tuple2 = this.values().dequeue();
        if (tuple2 == null || (queueElement = (QueueElement)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        QueueElement queueElement2 = CausalQueue$QueueElement$.MODULE$.unapply(queueElement);
        Object t = queueElement2._1();
        Dot dot = queueElement2._2();
        VectorClock vectorClock = queueElement2._3();
        Dot dot2 = dot;
        Queue tail = (Queue)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dot2, (Object)tail);
        Dot dot3 = (Dot)tuple22._1();
        Queue tail2 = (Queue)tuple22._2();
        return CausalQueue$.MODULE$.apply(tail2, this.latest(), this.removed().add(dot3));
    }

    public <T> CausalQueue<T> copy(Queue<QueueElement<T>> values, VectorClock latest, Dots removed) {
        return new CausalQueue<T>(values, latest, removed);
    }

    public <T> Queue<QueueElement<T>> copy$default$1() {
        return this.values();
    }

    public <T> VectorClock copy$default$2() {
        return this.latest();
    }

    public <T> Dots copy$default$3() {
        return this.removed();
    }

    public Queue<QueueElement<T>> _1() {
        return this.values();
    }

    public VectorClock _2() {
        return this.latest();
    }

    public Dots _3() {
        return this.removed();
    }

    public static class QueueElement<T>
    implements Product,
    Serializable {
        private final Object value;
        private final Dot dot;
        private final VectorClock order;

        public static <T> QueueElement<T> apply(T t, Dot dot, VectorClock vectorClock) {
            return CausalQueue$QueueElement$.MODULE$.apply(t, dot, vectorClock);
        }

        public static QueueElement<?> fromProduct(Product product) {
            return CausalQueue$QueueElement$.MODULE$.fromProduct(product);
        }

        public static <T> QueueElement<T> unapply(QueueElement<T> queueElement) {
            return CausalQueue$QueueElement$.MODULE$.unapply(queueElement);
        }

        public QueueElement(T value, Dot dot, VectorClock order) {
            this.value = value;
            this.dot = dot;
            this.order = order;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueElement)) return false;
            QueueElement queueElement = (QueueElement)object;
            if (!BoxesRunTime.equals(this.value(), queueElement.value())) return false;
            Dot dot = this.dot();
            Dot dot2 = queueElement.dot();
            if (dot == null) {
                if (dot2 != null) {
                    return false;
                }
            } else if (!((Object)dot).equals(dot2)) return false;
            VectorClock vectorClock = this.order();
            VectorClock vectorClock2 = queueElement.order();
            if (vectorClock == null) {
                if (vectorClock2 != null) {
                    return false;
                }
            } else if (!((Object)vectorClock).equals(vectorClock2)) return false;
            if (!queueElement.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueElement;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "QueueElement";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "value";
                }
                case 1: {
                    return "dot";
                }
                case 2: {
                    return "order";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T value() {
            return (T)this.value;
        }

        public Dot dot() {
            return this.dot;
        }

        public VectorClock order() {
            return this.order;
        }

        public <T> QueueElement<T> copy(T value, Dot dot, VectorClock order) {
            return new QueueElement<T>(value, dot, order);
        }

        public <T> T copy$default$1() {
            return this.value();
        }

        public <T> Dot copy$default$2() {
            return this.dot();
        }

        public <T> VectorClock copy$default$3() {
            return this.order();
        }

        public T _1() {
            return this.value();
        }

        public Dot _2() {
            return this.dot();
        }

        public VectorClock _3() {
            return this.order();
        }
    }
}

