/*
 * Decompiled with CFR 0.152.
 */
package kofre.decompose.containers;

import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public class Network {
    private final double lossChance;
    private final double duplicateChance;
    private final double delayChance;
    private boolean reliablePhase;
    private final Map.WithDefault<String, List<byte[]>> reliablyTransferred;
    private final Map.WithDefault<String, List<byte[]>> inTransfer;

    public Network(double lossChance, double duplicateChance, double delayChance) {
        this.lossChance = lossChance;
        this.duplicateChance = duplicateChance;
        this.delayChance = delayChance;
        this.reliablePhase = false;
        this.reliablyTransferred = new Map.WithDefault((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function1 & Serializable)_$1 -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        this.inTransfer = new Map.WithDefault((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function1 & Serializable)_$2 -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
    }

    public double lossChance() {
        return this.lossChance;
    }

    public double duplicateChance() {
        return this.duplicateChance;
    }

    public double delayChance() {
        return this.delayChance;
    }

    public void startReliablePhase() {
        this.reliablePhase = true;
    }

    public void endReliablePhase() {
        this.reliablePhase = false;
    }

    private List<byte[]> selectRandom(List<byte[]> l, double removeChance) {
        return ((List)l.zip((IterableOnce)package$.MODULE$.List().fill(l.length(), Network::selectRandom$$anonfun$1))).collect((PartialFunction)new Serializable(removeChance){
            private final double removeChance$1;
            {
                this.removeChance$1 = removeChance$2;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    byte[] msg = (byte[])tuple2._1();
                    double ran = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    if (ran > this.removeChance$1) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    byte[] msg = (byte[])tuple2._1();
                    double ran = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    if (ran > this.removeChance$1) {
                        return msg;
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public List<byte[]> receiveMessages(String recipient) {
        List l = (List)this.inTransfer.apply((Object)recipient);
        List<byte[]> transferred = this.selectRandom((List<byte[]>)l, this.delayChance());
        List<byte[]> removeFromBuffer = this.selectRandom(transferred, this.duplicateChance());
        this.inTransfer.update((Object)recipient, l.diff(removeFromBuffer));
        List received = (List)((IterableOps)this.reliablyTransferred.getOrElse((Object)recipient, Network::$anonfun$1)).$plus$plus(transferred);
        this.reliablyTransferred.remove((Object)recipient);
        return received;
    }

    private void insertMessage(String recipient, byte[] message, Map<String, List<byte[]>> into) {
        into.update((Object)recipient, ((SeqOps)into.apply((Object)recipient)).$colon$plus((Object)message));
    }

    public void sendMessage(String recipient, byte[] message) {
        if (this.reliablePhase) {
            this.insertMessage(recipient, message, (Map<String, List<byte[]>>)this.reliablyTransferred);
            return;
        }
        if (Random$.MODULE$.between(0.0, 1.0) <= this.lossChance()) {
            return;
        }
        this.insertMessage(recipient, message, (Map<String, List<byte[]>>)this.inTransfer);
    }

    private static final double selectRandom$$anonfun$1() {
        return Random$.MODULE$.between(0.0, 1.0);
    }

    private static final List $anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

