/*
 * Decompiled with CFR 0.152.
 */
package kofre.datatypes.alternatives.rga;

import java.io.Serializable;
import java.util.NoSuchElementException;
import kofre.base.Lattice;
import kofre.datatypes.alternatives.rga.LatticeSequence$;
import kofre.datatypes.alternatives.rga.SetLike;
import kofre.datatypes.alternatives.rga.Vertex;
import kofre.datatypes.alternatives.rga.Vertex$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class LatticeSequence<A, VertexSet>
implements Product,
Serializable {
    private final Object vertices;
    private final Map edges;
    private final Map values;
    private final SetLike vertexSet;

    public static <A, VertexSet> LatticeSequence<A, VertexSet> apply(VertexSet VertexSet, Map<Vertex, Vertex> map, Map<Vertex, A> map2, SetLike<Vertex, VertexSet> setLike) {
        return LatticeSequence$.MODULE$.apply(VertexSet, map, map2, setLike);
    }

    public static <A, VS> Lattice<LatticeSequence<A, VS>> lattice(Lattice<VS> lattice2, SetLike<Vertex, VS> setLike) {
        return LatticeSequence$.MODULE$.lattice(lattice2, setLike);
    }

    public static <A, VertexSet> LatticeSequence<A, VertexSet> unapply(LatticeSequence<A, VertexSet> latticeSequence) {
        return LatticeSequence$.MODULE$.unapply(latticeSequence);
    }

    public LatticeSequence(VertexSet vertices, Map<Vertex, Vertex> edges, Map<Vertex, A> values, SetLike<Vertex, VertexSet> vertexSet) {
        this.vertices = vertices;
        this.edges = edges;
        this.values = values;
        this.vertexSet = vertexSet;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LatticeSequence)) return false;
        LatticeSequence latticeSequence = (LatticeSequence)object;
        if (!BoxesRunTime.equals(this.vertices(), latticeSequence.vertices())) return false;
        Map<Vertex, Vertex> map = this.edges();
        Map<Vertex, Vertex> map2 = latticeSequence.edges();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<Vertex, A> map3 = this.values();
        Map<Vertex, A> map4 = latticeSequence.values();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (!latticeSequence.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LatticeSequence;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "LatticeSequence";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "vertices";
            }
            case 1: {
                return "edges";
            }
            case 2: {
                return "values";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public VertexSet vertices() {
        return (VertexSet)this.vertices;
    }

    public Map<Vertex, Vertex> edges() {
        return this.edges;
    }

    public Map<Vertex, A> values() {
        return this.values;
    }

    public SetLike<Vertex, VertexSet> vertexSet() {
        return this.vertexSet;
    }

    public boolean contains(Vertex v) {
        Vertex vertex = v;
        Vertex vertex2 = Vertex$.MODULE$.start();
        Vertex vertex3 = vertex;
        if (!(vertex2 != null ? !((Object)vertex2).equals(vertex3) : vertex3 != null)) {
            return true;
        }
        Vertex vertex4 = Vertex$.MODULE$.end();
        Vertex vertex5 = vertex;
        if (!(vertex4 != null ? !((Object)vertex4).equals(vertex5) : vertex5 != null)) {
            return true;
        }
        if (vertex != null) {
            Vertex v2 = vertex;
            return this.vertexSet().contains(this.vertices(), v2);
        }
        throw new MatchError((Object)vertex);
    }

    public boolean before(Vertex u, Vertex v) {
        Vertex vertex = u;
        Vertex vertex2 = Vertex$.MODULE$.start();
        Vertex vertex3 = vertex;
        if (!(vertex2 != null ? !((Object)vertex2).equals(vertex3) : vertex3 != null)) {
            return true;
        }
        Vertex vertex4 = Vertex$.MODULE$.end();
        Vertex vertex5 = vertex;
        if (!(vertex4 != null ? !((Object)vertex4).equals(vertex5) : vertex5 != null)) {
            return false;
        }
        if (vertex != null) {
            Vertex u2 = vertex;
            Object object = this.edges().apply((Object)u2);
            Vertex vertex6 = v;
            return !(object == null ? vertex6 != null : !object.equals(vertex6)) || this.before((Vertex)this.edges().apply((Object)u2), v);
        }
        if (vertex == null) {
            throw new IllegalArgumentException(new StringBuilder(38).append("CRDTSequence does not contain Vertex ").append(u).append("!").toString());
        }
        throw new MatchError((Object)vertex);
    }

    public Vertex successor(Vertex v) {
        Option option = this.edges().get((Object)v);
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("CRDTSequence does not contain ").append(v).toString());
        }
        if (option instanceof Some) {
            Vertex u = (Vertex)((Some)option).value();
            if (this.contains(u)) {
                return u;
            }
            return this.successor(u);
        }
        throw new MatchError((Object)option);
    }

    public LatticeSequence<A, VertexSet> addRight(Vertex position, A a) {
        return this.addRight(position, Vertex$.MODULE$.fresh(), a);
    }

    public LatticeSequence<A, VertexSet> addRight(Vertex left, Vertex insertee, A value) {
        Vertex vertex = left;
        Vertex vertex2 = Vertex$.MODULE$.end();
        if (!(vertex != null ? !((Object)vertex).equals(vertex2) : vertex2 != null)) {
            throw new IllegalArgumentException("Cannot insert after end node!");
        }
        Vertex right = this.successor(left);
        if (right.timestamp() > insertee.timestamp()) {
            return this.addRight(right, insertee, value);
        }
        VertexSet newVertices = this.vertexSet().add(this.vertices(), insertee);
        Vertex vertex3 = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)left);
        Vertex vertex4 = (Vertex)Predef$.MODULE$.ArrowAssoc((Object)insertee);
        Map newEdges = (Map)this.edges().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex3, (Object)insertee)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vertex4, (Object)right));
        Map newValues = (Map)this.values().updated((Object)insertee, value);
        return this.copy(newVertices, (Map<Vertex, Vertex>)newEdges, newValues, this.vertexSet());
    }

    public LatticeSequence<A, VertexSet> append(A value) {
        Vertex position = this.vertexIterator().nonEmpty() ? (Vertex)this.vertexIterator().toList().last() : Vertex$.MODULE$.start();
        return this.addRight(position, value);
    }

    public LatticeSequence<A, VertexSet> prepend(A value) {
        return this.addRight(Vertex$.MODULE$.start(), value);
    }

    public List<A> toList() {
        return this.iterator().toList();
    }

    public Iterator<A> iterator() {
        return this.vertexIterator().map((Function1 & Serializable)v -> this.values().apply(v));
    }

    public Iterator<Vertex> vertexIterator() {
        return new AbstractIterator<Vertex>(this){
            private Vertex lastVertex;
            private final /* synthetic */ LatticeSequence $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lastVertex = Vertex$.MODULE$.start();
            }

            public Vertex lastVertex() {
                return this.lastVertex;
            }

            public void lastVertex_$eq(Vertex x$1) {
                this.lastVertex = x$1;
            }

            public boolean hasNext() {
                Vertex vertex = this.$outer.successor(this.lastVertex());
                Vertex vertex2 = Vertex$.MODULE$.end();
                Vertex vertex3 = vertex;
                return vertex2 != null ? !((Object)vertex2).equals(vertex3) : vertex3 != null;
            }

            public Vertex next() {
                Vertex vertex = this.$outer.successor(this.lastVertex());
                if (vertex != null) {
                    Vertex v = vertex;
                    this.lastVertex_$eq(v);
                    return v;
                }
                if (vertex == null) {
                    throw new NoSuchElementException("Requesting iterator value after Vertex.end!");
                }
                throw new MatchError((Object)vertex);
            }
        };
    }

    public <A, VertexSet> LatticeSequence<A, VertexSet> copy(VertexSet vertices, Map<Vertex, Vertex> edges, Map<Vertex, A> values, SetLike<Vertex, VertexSet> vertexSet) {
        return new LatticeSequence<A, VertexSet>(vertices, edges, values, vertexSet);
    }

    public <A, VertexSet> VertexSet copy$default$1() {
        return this.vertices();
    }

    public <A, VertexSet> Map<Vertex, Vertex> copy$default$2() {
        return this.edges();
    }

    public <A, VertexSet> Map<Vertex, A> copy$default$3() {
        return this.values();
    }

    public VertexSet _1() {
        return this.vertices();
    }

    public Map<Vertex, Vertex> _2() {
        return this.edges();
    }

    public Map<Vertex, A> _3() {
        return this.values();
    }
}

