/*
 * Decompiled with CFR 0.152.
 */
package rdts.protocols.raft;

import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.Lattice$;
import rdts.base.LocalUid;
import rdts.base.Uid;
import rdts.base.Uid$;
import rdts.datatypes.ReplicatedSet;
import rdts.datatypes.ReplicatedSet$;
import rdts.protocols.raft.RaftState;
import rdts.protocols.raft.RaftState$;
import rdts.protocols.raft.RaftToken;
import rdts.protocols.raft.RaftToken$;
import rdts.protocols.raft.RaftTokens$;
import rdts.syntax.DeltaBuffer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import scala.util.hashing.MurmurHash3$;

public class RaftTokens
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RaftTokens.class.getDeclaredField("given_LocalUid$lzy1"));
    private final Uid replicaID;
    private final RaftState<RaftToken> tokenAgreement;
    private final DeltaBuffer<ReplicatedSet<RaftToken>> want;
    private final DeltaBuffer<ReplicatedSet<RaftToken>> tokenFreed;
    private volatile Object given_LocalUid$lzy1;

    public static RaftTokens apply(Uid uid, RaftState<RaftToken> raftState, DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer, DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2) {
        return RaftTokens$.MODULE$.apply(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public static RaftTokens fromProduct(Product product) {
        return RaftTokens$.MODULE$.fromProduct(product);
    }

    public static RaftTokens init(Uid uid) {
        return RaftTokens$.MODULE$.init(uid);
    }

    public static RaftTokens unapply(RaftTokens raftTokens) {
        return RaftTokens$.MODULE$.unapply(raftTokens);
    }

    public RaftTokens(Uid replicaID, RaftState<RaftToken> tokenAgreement, DeltaBuffer<ReplicatedSet<RaftToken>> want, DeltaBuffer<ReplicatedSet<RaftToken>> tokenFreed) {
        this.replicaID = replicaID;
        this.tokenAgreement = tokenAgreement;
        this.want = want;
        this.tokenFreed = tokenFreed;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -282341566, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RaftTokens)) return false;
        RaftTokens raftTokens = (RaftTokens)object;
        Uid uid = this.replicaID();
        Uid uid2 = raftTokens.replicaID();
        if (uid == null) {
            if (uid2 != null) {
                return false;
            }
        } else if (!((Object)uid).equals(uid2)) return false;
        RaftState<RaftToken> raftState = this.tokenAgreement();
        RaftState<RaftToken> raftState2 = raftTokens.tokenAgreement();
        if (raftState == null) {
            if (raftState2 != null) {
                return false;
            }
        } else if (!((Object)raftState).equals(raftState2)) return false;
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.want();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = raftTokens.want();
        if (deltaBuffer == null) {
            if (deltaBuffer2 != null) {
                return false;
            }
        } else if (!((Object)deltaBuffer).equals(deltaBuffer2)) return false;
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer3 = this.tokenFreed();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer4 = raftTokens.tokenFreed();
        if (deltaBuffer3 == null) {
            if (deltaBuffer4 != null) {
                return false;
            }
        } else if (!((Object)deltaBuffer3).equals(deltaBuffer4)) return false;
        if (!raftTokens.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RaftTokens;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "RaftTokens";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "replicaID";
            }
            case 1: {
                return "tokenAgreement";
            }
            case 2: {
                return "want";
            }
            case 3: {
                return "tokenFreed";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Uid replicaID() {
        return this.replicaID;
    }

    public RaftState<RaftToken> tokenAgreement() {
        return this.tokenAgreement;
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> want() {
        return this.want;
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> tokenFreed() {
        return this.tokenFreed;
    }

    public final LocalUid given_LocalUid() {
        Object object = this.given_LocalUid$lzy1;
        if (object instanceof LocalUid) {
            return (LocalUid)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalUid)this.given_LocalUid$lzyINIT1();
    }

    private Object given_LocalUid$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_LocalUid$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalUid localUid = null;
                    try {
                        localUid = (LocalUid)Uid$.MODULE$.toLocal().convert((Object)this.replicaID());
                        object2 = localUid == null ? LazyVals.NullValue$.MODULE$ : localUid;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_LocalUid$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localUid;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<RaftToken> owned(String value) {
        Set<RaftToken> freed = this.tokenFreed().state().elements();
        List owners = this.tokenAgreement().values().filter((Function1 & Serializable)t -> {
            String string = t.value();
            String string2 = value;
            return !(string != null ? !string.equals(string2) : string2 != null) && !freed.contains(t);
        });
        List mine = owners.filter((Function1 & Serializable)_$1 -> {
            Uid uid = _$1.owner();
            Uid uid2 = this.replicaID();
            return !(uid != null ? !((Object)uid).equals(uid2) : uid2 != null);
        });
        Option option = mine.headOption();
        Option option2 = owners.headOption();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return mine;
        }
        return package$.MODULE$.Nil();
    }

    public boolean isOwned(String value) {
        return this.owned(value).nonEmpty();
    }

    public RaftTokens acquire(String value) {
        RaftToken token = RaftToken$.MODULE$.apply(Random$.MODULE$.nextLong(), this.replicaID(), value);
        if (!this.tokenAgreement().values().iterator().$plus$plus(this::acquire$$anonfun$1).exists((Function1 & Serializable)_$2 -> _$2.same(token))) {
            DeltaBuffer<ReplicatedSet<RaftToken>> DeltaBuffer_this = this.want();
            Function1 & Serializable f$proxy1 = (Function1 & Serializable)_$3 -> _$3.add(this.given_LocalUid(), token);
            Lattice x$2$proxy1 = ReplicatedSet$.MODULE$.lattice();
            DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = DeltaBuffer_this.applyDelta((ReplicatedSet<RaftToken>)f$proxy1.apply(DeltaBuffer_this.state()), x$2$proxy1);
            Uid uid = this.copy$default$1();
            RaftState<RaftToken> raftState = this.copy$default$2();
            DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$4();
            return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
        }
        return this;
    }

    public RaftTokens free(String value) {
        DeltaBuffer<ReplicatedSet<RaftToken>> DeltaBuffer_this = this.tokenFreed();
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)_$4 -> _$4.addAll(this.given_LocalUid(), this.owned(value));
        Lattice x$2$proxy2 = ReplicatedSet$.MODULE$.lattice();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = DeltaBuffer_this.applyDelta((ReplicatedSet<RaftToken>)f$proxy2.apply(DeltaBuffer_this.state()), x$2$proxy2);
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$3();
        return this.copy(uid, raftState, deltaBuffer2, deltaBuffer);
    }

    public RaftTokens update() {
        RaftState<RaftToken> generalDuties = this.tokenAgreement().supportLeader(this.replicaID()).supportProposal(this.replicaID());
        Uid uid = this.tokenAgreement().leader();
        Uid uid2 = this.replicaID();
        if (!(uid != null ? !((Object)uid).equals(uid2) : uid2 != null)) {
            DeltaBuffer<ReplicatedSet<RaftToken>> DeltaBuffer_this = this.want();
            Function1 & Serializable f$proxy3 = (Function1 & Serializable)_$5 -> _$5.removeAll((Iterable)this.want().state().elements().filter((Function1 & Serializable)elem -> generalDuties.values().contains(elem)));
            Lattice x$2$proxy3 = ReplicatedSet$.MODULE$.lattice();
            DeltaBuffer<ReplicatedSet<RaftToken>> unwanted = DeltaBuffer_this.applyDelta((ReplicatedSet<RaftToken>)f$proxy3.apply(DeltaBuffer_this.state()), x$2$proxy3);
            Option option = unwanted.state().elements().headOption();
            if (None$.MODULE$.equals(option)) {
                return this.copy(this.copy$default$1(), generalDuties, unwanted, this.copy$default$4());
            }
            if (option instanceof Some) {
                RaftToken tok = (RaftToken)((Some)option).value();
                RaftState<RaftToken> raftState = generalDuties.propose(this.replicaID(), tok);
                Uid uid3 = this.copy$default$1();
                DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.copy$default$4();
                return this.copy(uid3, raftState, unwanted, deltaBuffer);
            }
            throw new MatchError((Object)option);
        }
        return this.copy(this.copy$default$1(), generalDuties, this.copy$default$3(), this.copy$default$4());
    }

    public RaftTokens applyWant(ReplicatedSet<RaftToken> state) {
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.want().applyDelta(state, ReplicatedSet$.MODULE$.lattice());
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens applyFree(ReplicatedSet<RaftToken> state) {
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.tokenFreed().applyDelta(state, ReplicatedSet$.MODULE$.lattice());
        Uid uid = this.copy$default$1();
        RaftState<RaftToken> raftState = this.copy$default$2();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$3();
        return this.copy(uid, raftState, deltaBuffer2, deltaBuffer);
    }

    public RaftTokens applyRaft(RaftState<RaftToken> state) {
        RaftState<RaftToken> raftState = Lattice$.MODULE$.merge(this.tokenAgreement(), state, RaftState$.MODULE$.raftLatticeInstance());
        Uid uid = this.copy$default$1();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.copy$default$3();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens lead() {
        RaftState<RaftToken> raftState = this.tokenAgreement().becomeCandidate(this.replicaID());
        Uid uid = this.copy$default$1();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer = this.copy$default$3();
        DeltaBuffer<ReplicatedSet<RaftToken>> deltaBuffer2 = this.copy$default$4();
        return this.copy(uid, raftState, deltaBuffer, deltaBuffer2);
    }

    public RaftTokens copy(Uid replicaID, RaftState<RaftToken> tokenAgreement, DeltaBuffer<ReplicatedSet<RaftToken>> want, DeltaBuffer<ReplicatedSet<RaftToken>> tokenFreed) {
        return new RaftTokens(replicaID, tokenAgreement, want, tokenFreed);
    }

    public Uid copy$default$1() {
        return this.replicaID();
    }

    public RaftState<RaftToken> copy$default$2() {
        return this.tokenAgreement();
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> copy$default$3() {
        return this.want();
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> copy$default$4() {
        return this.tokenFreed();
    }

    public Uid _1() {
        return this.replicaID();
    }

    public RaftState<RaftToken> _2() {
        return this.tokenAgreement();
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> _3() {
        return this.want();
    }

    public DeltaBuffer<ReplicatedSet<RaftToken>> _4() {
        return this.tokenFreed();
    }

    private final IterableOnce acquire$$anonfun$1() {
        return this.want().state().elements().iterator();
    }
}

