/*
 * Decompiled with CFR 0.152.
 */
package rdts.experiments;

import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.LocalUid;
import rdts.base.LocalUid$;
import rdts.base.Uid;
import rdts.base.Uid$;
import rdts.datatypes.GrowOnlyCounter;
import rdts.datatypes.PosNegCounter;
import rdts.datatypes.PosNegCounter$;
import rdts.experiments.BoundedCounter$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class BoundedCounter
implements Product,
Serializable {
    private final PosNegCounter reservations;
    private final GrowOnlyCounter allocations;
    private final Set<Uid> participants;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BoundedCounter$.class.getDeclaredField("lattice$lzy1"));

    public static BoundedCounter apply(PosNegCounter posNegCounter, GrowOnlyCounter growOnlyCounter, Set<Uid> set2) {
        return BoundedCounter$.MODULE$.apply(posNegCounter, growOnlyCounter, set2);
    }

    public static BoundedCounter fromProduct(Product product) {
        return BoundedCounter$.MODULE$.fromProduct(product);
    }

    public static BoundedCounter init(int n, Uid uid) {
        return BoundedCounter$.MODULE$.init(n, uid);
    }

    public static Lattice<BoundedCounter> lattice() {
        return BoundedCounter$.MODULE$.lattice();
    }

    public static BoundedCounter unapply(BoundedCounter boundedCounter) {
        return BoundedCounter$.MODULE$.unapply(boundedCounter);
    }

    public BoundedCounter(PosNegCounter reservations, GrowOnlyCounter allocations, Set<Uid> participants) {
        this.reservations = reservations;
        this.allocations = allocations;
        this.participants = participants;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -812871274, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundedCounter)) return false;
        BoundedCounter boundedCounter = (BoundedCounter)object;
        PosNegCounter posNegCounter = this.reservations();
        PosNegCounter posNegCounter2 = boundedCounter.reservations();
        if (posNegCounter == null) {
            if (posNegCounter2 != null) {
                return false;
            }
        } else if (!((Object)posNegCounter).equals(posNegCounter2)) return false;
        GrowOnlyCounter growOnlyCounter = this.allocations();
        GrowOnlyCounter growOnlyCounter2 = boundedCounter.allocations();
        if (growOnlyCounter == null) {
            if (growOnlyCounter2 != null) {
                return false;
            }
        } else if (!((Object)growOnlyCounter).equals(growOnlyCounter2)) return false;
        Set<Uid> set2 = this.participants();
        Set<Uid> set3 = boundedCounter.participants();
        if (set2 == null) {
            if (set3 != null) {
                return false;
            }
        } else if (!set2.equals(set3)) return false;
        if (!boundedCounter.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundedCounter;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "BoundedCounter";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "reservations";
            }
            case 1: {
                return "allocations";
            }
            case 2: {
                return "participants";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PosNegCounter reservations() {
        return this.reservations;
    }

    public GrowOnlyCounter allocations() {
        return this.allocations;
    }

    public Set<Uid> participants() {
        return this.participants;
    }

    public BoundedCounter current() {
        return this;
    }

    public BoundedCounter addParticipants(Set<Uid> part) {
        return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy(BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$1(), BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$2(), part);
    }

    public int allocated(Uid id) {
        return BoxesRunTime.unboxToInt((Object)this.allocations().inner().getOrElse((Object)id, BoundedCounter::allocated$$anonfun$1));
    }

    public int reserved(LocalUid x$1) {
        return this.reserved(LocalUid$.MODULE$.replicaId(x$1));
    }

    public int reserved(Uid id) {
        return BoxesRunTime.unboxToInt((Object)this.current().reservations().pos().inner().getOrElse((Object)id, BoundedCounter::reserved$$anonfun$1)) - BoxesRunTime.unboxToInt((Object)this.current().reservations().neg().inner().getOrElse((Object)id, BoundedCounter::reserved$$anonfun$2));
    }

    public int available(Uid id) {
        return this.reserved(id) - this.allocated(id);
    }

    public int available(LocalUid x$1) {
        return this.available(LocalUid$.MODULE$.replicaId(x$1));
    }

    public BoundedCounter allocate(int value, LocalUid x$2) {
        if (value < 0 || this.available(LocalUid$.MODULE$.replicaId(x$2)) < value) {
            return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral;
        }
        GrowOnlyCounter growOnlyCounter = this.current().allocations().add(value, x$2);
        PosNegCounter posNegCounter = BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$1();
        Set<Uid> set2 = BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$3();
        return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy(posNegCounter, growOnlyCounter, set2);
    }

    public BoundedCounter transfer(int amount, Uid target, LocalUid x$3) {
        if (amount > this.available(LocalUid$.MODULE$.replicaId(x$3))) {
            return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral;
        }
        Lattice<PosNegCounter> Lattice_this = PosNegCounter$.MODULE$.derived$Lattice();
        PosNegCounter left$proxy1 = this.current().reservations().add(amount, (LocalUid)Uid$.MODULE$.toLocal().convert((Object)target));
        PosNegCounter right$proxy1 = this.current().reservations().add(-amount, x$3);
        return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy(Lattice_this.merge(left$proxy1, right$proxy1), BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$2(), BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral.copy$default$3());
    }

    public BoundedCounter rebalance(LocalUid x$1) {
        List availableByReplica = this.current().participants().iterator().map((Function1 & Serializable)id -> {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.available((Uid)id)));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, id);
        }).toList();
        Tuple2 most = (Tuple2)availableByReplica.max(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, Uid$.MODULE$.ordering()));
        Tuple2 least = (Tuple2)availableByReplica.min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, Uid$.MODULE$.ordering()));
        Object object = most._2();
        Uid uid = LocalUid$.MODULE$.replicaId(x$1);
        if (object == null ? uid != null : !object.equals(uid)) {
            return BoundedCounter$.rdts$experiments$BoundedCounter$$$neutral;
        }
        int diff = (BoxesRunTime.unboxToInt((Object)most._1()) - BoxesRunTime.unboxToInt((Object)least._1())) / 2;
        return this.current().transfer(diff, (Uid)least._2(), x$1);
    }

    public void invariantOk() {
        if (this.current().reservations().value() != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("incorrect reservations: " + this.current().reservations().value()));
        }
        if (this.current().allocations().value() > BoxesRunTime.unboxToInt((Object)this.current().reservations().neg().inner().apply((Object)Uid$.MODULE$.predefined("initial-allocation")))) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("allocation sum " + this.current().allocations().value() + " larger than initial reservations " + this.current().reservations().neg().inner().apply((Object)Uid$.MODULE$.predefined("initial-allocation"))));
        }
    }

    public BoundedCounter copy(PosNegCounter reservations, GrowOnlyCounter allocations, Set<Uid> participants) {
        return new BoundedCounter(reservations, allocations, participants);
    }

    public PosNegCounter copy$default$1() {
        return this.reservations();
    }

    public GrowOnlyCounter copy$default$2() {
        return this.allocations();
    }

    public Set<Uid> copy$default$3() {
        return this.participants();
    }

    public PosNegCounter _1() {
        return this.reservations();
    }

    public GrowOnlyCounter _2() {
        return this.allocations();
    }

    public Set<Uid> _3() {
        return this.participants();
    }

    private static final int allocated$$anonfun$1() {
        return 0;
    }

    private static final int reserved$$anonfun$1() {
        return 0;
    }

    private static final int reserved$$anonfun$2() {
        return 0;
    }
}

