/*
 * Decompiled with CFR 0.152.
 */
package rdts.protocols.raft;

import java.io.Serializable;
import rdts.base.Lattice;
import rdts.base.Lattice$;
import rdts.base.Uid;
import rdts.base.Uid$;
import rdts.protocols.raft.RaftState$;
import rdts.protocols.raft.RaftState$Propose$;
import rdts.protocols.raft.RaftState$Vote$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;
import scala.util.hashing.MurmurHash3$;

public class RaftState<T>
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RaftState.class.getDeclaredField("values$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RaftState.class.getDeclaredField("byRound$lzy1"));
    private final Set<Uid> participants;
    private final Set<Vote> leaderVotes;
    private final Set<Propose<T>> valueProposals;
    private final int consensusSize;
    private final int currentTerm;
    private final int maxTerm;
    private final Uid leader;
    private final int nextProposal;
    private volatile Object byRound$lzy1;
    private volatile Object values$lzy1;

    public static <T> RaftState<T> apply(Set<Uid> set2, Set<Vote> set3, Set<Propose<T>> set4) {
        return RaftState$.MODULE$.apply(set2, set3, set4);
    }

    public static RaftState<?> fromProduct(Product product) {
        return RaftState$.MODULE$.fromProduct(product);
    }

    public static <T> Lattice<RaftState<T>> raftLatticeInstance() {
        return RaftState$.MODULE$.raftLatticeInstance();
    }

    public static <T> RaftState<T> unapply(RaftState<T> raftState) {
        return RaftState$.MODULE$.unapply(raftState);
    }

    public static <T> Set<Uid> $lessinit$greater$default$1() {
        return RaftState$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> Set<Vote> $lessinit$greater$default$2() {
        return RaftState$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Set<Propose<T>> $lessinit$greater$default$3() {
        return RaftState$.MODULE$.$lessinit$greater$default$3();
    }

    public RaftState(Set<Uid> participants, Set<Vote> leaderVotes, Set<Propose<T>> valueProposals) {
        int maxTerm;
        int currentTerm;
        Uid uid;
        block3: {
            Tuple3 tuple3;
            block2: {
                this.participants = participants;
                this.leaderVotes = leaderVotes;
                this.valueProposals = valueProposals;
                this.consensusSize = (participants.size() + 2) / 2;
                Map grouped = leaderVotes.groupBy((Function1 & Serializable)v -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)v.term()), (Object)v.leader()));
                Tuple2 tuple2 = (Tuple2)Try$.MODULE$.apply(() -> this.$init$$$anonfun$2(grouped)).getOrElse(RaftState::$init$$$anonfun$3);
                int cterm = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Uid cleader = (Uid)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)cterm), (Object)cleader);
                int cterm2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
                Uid cleader2 = (Uid)tuple22._2();
                int mterm = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply(() -> RaftState.$init$$$anonfun$4(grouped)).getOrElse(RaftState::$init$$$anonfun$5));
                tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)cterm2), (Object)BoxesRunTime.boxToInteger((int)mterm), (Object)cleader2);
                int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int n2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                uid = (Uid)tuple3._3();
                if (!true) break block2;
                currentTerm = n;
                if (!true) break block2;
                maxTerm = n2;
                if (uid != null) break block3;
            }
            throw new MatchError((Object)tuple3);
        }
        Uid leader = uid;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)currentTerm), (Object)BoxesRunTime.boxToInteger((int)maxTerm), (Object)leader);
        this.currentTerm = BoxesRunTime.unboxToInt((Object)tuple3._1());
        this.maxTerm = BoxesRunTime.unboxToInt((Object)tuple3._2());
        this.leader = (Uid)tuple3._3();
        this.nextProposal = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply(() -> RaftState.$init$$$anonfun$6(valueProposals)).getOrElse(RaftState::$init$$$anonfun$7));
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -2021938937, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RaftState)) return false;
        RaftState raftState = (RaftState)object;
        Set<Uid> set2 = this.participants();
        Set<Uid> set3 = raftState.participants();
        if (set2 == null) {
            if (set3 != null) {
                return false;
            }
        } else if (!set2.equals(set3)) return false;
        Set<Vote> set4 = this.leaderVotes();
        Set<Vote> set5 = raftState.leaderVotes();
        if (set4 == null) {
            if (set5 != null) {
                return false;
            }
        } else if (!set4.equals(set5)) return false;
        Set<Propose<T>> set6 = this.valueProposals();
        Set<Propose<T>> set7 = raftState.valueProposals();
        if (set6 == null) {
            if (set7 != null) {
                return false;
            }
        } else if (!set6.equals(set7)) return false;
        if (!raftState.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RaftState;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "RaftState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "participants";
            }
            case 1: {
                return "leaderVotes";
            }
            case 2: {
                return "valueProposals";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Set<Uid> participants() {
        return this.participants;
    }

    public Set<Vote> leaderVotes() {
        return this.leaderVotes;
    }

    public Set<Propose<T>> valueProposals() {
        return this.valueProposals;
    }

    public int consensusSize() {
        return this.consensusSize;
    }

    public int currentTerm() {
        return this.currentTerm;
    }

    public int maxTerm() {
        return this.maxTerm;
    }

    public Uid leader() {
        return this.leader;
    }

    public int nextProposal() {
        return this.nextProposal;
    }

    public RaftState<T> compress() {
        Set set2 = (Set)this.leaderVotes().filter((Function1 & Serializable)_$5 -> _$5.term() >= this.currentTerm());
        Set<Uid> set3 = this.copy$default$1();
        Set<Propose<T>> set4 = this.copy$default$3();
        return this.copy(set3, (Set<Vote>)set2, set4);
    }

    public RaftState<T> supportProposalDelta(Uid me) {
        Set voted = (Set)((IterableOps)this.valueProposals().filter((Function1 & Serializable)proposal -> {
            if (proposal.term() != this.currentTerm()) return false;
            Uid uid = proposal.voter();
            Uid uid2 = this.leader();
            if (uid != null) {
                if (!((Object)uid).equals(uid2)) return false;
                return true;
            }
            if (uid2 == null) return true;
            return false;
        })).map((Function1 & Serializable)proposal -> proposal.copy(proposal.copy$default$1(), me, proposal.copy$default$3(), proposal.copy$default$4()));
        return RaftState$.MODULE$.apply(RaftState$.MODULE$.$lessinit$greater$default$1(), RaftState$.MODULE$.$lessinit$greater$default$2(), voted);
    }

    public RaftState<T> supportProposal(Uid me) {
        return Lattice$.MODULE$.merge(this, this.supportProposalDelta(me), RaftState$.MODULE$.raftLatticeInstance());
    }

    public RaftState<T> proposeDelta(Uid me, T value) {
        Uid uid = me;
        Uid uid2 = this.leader();
        if (uid == null ? uid2 != null : !((Object)uid).equals(uid2)) {
            return RaftState$.MODULE$.apply(RaftState$.MODULE$.$lessinit$greater$default$1(), RaftState$.MODULE$.$lessinit$greater$default$2(), RaftState$.MODULE$.$lessinit$greater$default$3());
        }
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Propose[]{RaftState$Propose$.MODULE$.apply(this.currentTerm(), me, this.nextProposal(), value)}));
        Set<Uid> set3 = RaftState$.MODULE$.$lessinit$greater$default$1();
        Set<Vote> set4 = RaftState$.MODULE$.$lessinit$greater$default$2();
        return RaftState$.MODULE$.apply(set3, set4, set2);
    }

    public RaftState<T> propose(Uid me, T value) {
        return Lattice$.MODULE$.merge(this, this.proposeDelta(me, value), RaftState$.MODULE$.raftLatticeInstance());
    }

    public RaftState<T> becomeCandidateDelta(Uid me) {
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vote[]{RaftState$Vote$.MODULE$.apply(this.maxTerm() + 1, me, me)}));
        Set<Uid> set3 = RaftState$.MODULE$.$lessinit$greater$default$1();
        Set set4 = RaftState$.MODULE$.$lessinit$greater$default$3();
        return RaftState$.MODULE$.apply(set3, (Set<Vote>)set2, set4);
    }

    public RaftState<T> becomeCandidate(Uid me) {
        return Lattice$.MODULE$.merge(this, this.becomeCandidateDelta(me), RaftState$.MODULE$.raftLatticeInstance());
    }

    public RaftState<T> supportLeaderDelta(Uid me) {
        Set votes = (Set)this.leaderVotes().filter((Function1 & Serializable)candidate -> candidate.term() == this.maxTerm());
        if (votes.exists((Function1 & Serializable)_$6 -> {
            Uid uid = _$6.voter();
            Uid uid2 = me;
            return !(uid != null ? !((Object)uid).equals(uid2) : uid2 != null);
        })) {
            return RaftState$.MODULE$.apply(RaftState$.MODULE$.$lessinit$greater$default$1(), RaftState$.MODULE$.$lessinit$greater$default$2(), RaftState$.MODULE$.$lessinit$greater$default$3());
        }
        if (votes.isEmpty()) {
            return RaftState$.MODULE$.apply(RaftState$.MODULE$.$lessinit$greater$default$1(), RaftState$.MODULE$.$lessinit$greater$default$2(), RaftState$.MODULE$.$lessinit$greater$default$3());
        }
        Uid bestCandidate = (Uid)((Tuple2)votes.groupBy((Function1 & Serializable)_$7 -> _$7.leader()).maxBy((Function1 & Serializable)_$8 -> ((IterableOnceOps)_$8._2()).size(), (Ordering)Ordering.Int$.MODULE$))._1();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vote[]{RaftState$Vote$.MODULE$.apply(this.maxTerm(), bestCandidate, me)}));
        Set<Uid> set3 = RaftState$.MODULE$.$lessinit$greater$default$1();
        Set set4 = RaftState$.MODULE$.$lessinit$greater$default$3();
        return RaftState$.MODULE$.apply(set3, (Set<Vote>)set2, set4);
    }

    public RaftState<T> supportLeader(Uid me) {
        return Lattice$.MODULE$.merge(this, this.supportLeaderDelta(me), RaftState$.MODULE$.raftLatticeInstance());
    }

    public IndexedSeq<Set<Propose<T>>> byRound() {
        Object object = this.byRound$lzy1;
        if (object instanceof IndexedSeq) {
            return (IndexedSeq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IndexedSeq)this.byRound$lzyINIT1();
    }

    private Object byRound$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.byRound$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IndexedSeq indexedSeq = null;
                    try {
                        Map grouped = this.valueProposals().groupBy((Function1 & Serializable)_$9 -> _$9.pos());
                        indexedSeq = package$.MODULE$.Range().apply(0, this.nextProposal()).map((Function1 & Serializable)pos -> RaftState.byRound$lzyINIT1$$anonfun$1(grouped, BoxesRunTime.unboxToInt((Object)pos)));
                        object2 = indexedSeq == null ? LazyVals.NullValue$.MODULE$ : indexedSeq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.byRound$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return indexedSeq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<T> values() {
        Object object = this.values$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.values$lzyINIT1();
    }

    private Object values$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.values$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = ((StrictOptimizedLinearSeqOps)this.valueProposals().groupBy((Function1 & Serializable)p -> p.pos()).iterator().map((Function1 & Serializable)g -> Tuple2$.MODULE$.apply(g._1(), (Object)this.decision$1((Set)g._2()))).toList().sortBy((Function1 & Serializable)_$13 -> BoxesRunTime.unboxToInt((Object)_$13._1()), (Ordering)Ordering.Int$.MODULE$)).iterator().map((Function1 & Serializable)_$14 -> (Option)_$14._2()).takeWhile((Function1 & Serializable)_$15 -> _$15.isDefined()).flatten(Predef$.MODULE$.$conforms()).flatten(Predef$.MODULE$.$conforms()).toList();
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.values$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.values$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public <T> RaftState<T> copy(Set<Uid> participants, Set<Vote> leaderVotes, Set<Propose<T>> valueProposals) {
        return new RaftState<T>(participants, leaderVotes, valueProposals);
    }

    public <T> Set<Uid> copy$default$1() {
        return this.participants();
    }

    public <T> Set<Vote> copy$default$2() {
        return this.leaderVotes();
    }

    public <T> Set<Propose<T>> copy$default$3() {
        return this.valueProposals();
    }

    public Set<Uid> _1() {
        return this.participants();
    }

    public Set<Vote> _2() {
        return this.leaderVotes();
    }

    public Set<Propose<T>> _3() {
        return this.valueProposals();
    }

    private final Tuple2 $init$$$anonfun$2(Map grouped$1) {
        return (Tuple2)grouped$1.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            Tuple2 k = (Tuple2)tuple2._1();
            Set v = (Set)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)k, (Object)BoxesRunTime.boxToInteger((int)v.size()));
        }).filter((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)_$1._2()) >= this.consensusSize()).map((Function1 & Serializable)_$2 -> (Tuple2)_$2._1()).max(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, Uid$.MODULE$.ordering()));
    }

    private static final Tuple2 $init$$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)Uid$.MODULE$.zero());
    }

    private static final int $init$$$anonfun$4(Map grouped$2) {
        return BoxesRunTime.unboxToInt((Object)grouped$2.iterator().map((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)((Tuple2)_$3._1())._1())).max((Ordering)Ordering.Int$.MODULE$));
    }

    private static final int $init$$$anonfun$5() {
        return 0;
    }

    private static final int $init$$$anonfun$6(Set valueProposals$6) {
        return BoxesRunTime.unboxToInt((Object)valueProposals$6.iterator().map((Function1 & Serializable)_$4 -> _$4.pos()).max((Ordering)Ordering.Int$.MODULE$)) + 1;
    }

    private static final int $init$$$anonfun$7() {
        return 0;
    }

    private static final Set byRound$lzyINIT1$$anonfun$1$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final /* synthetic */ Set byRound$lzyINIT1$$anonfun$1(Map grouped$3, int pos) {
        return (Set)grouped$3.getOrElse((Object)BoxesRunTime.boxToInteger((int)pos), RaftState::byRound$lzyINIT1$$anonfun$1$$anonfun$1);
    }

    private static final Tuple2 $anonfun$11() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)None$.MODULE$);
    }

    private static final int $anonfun$12() {
        return -1;
    }

    private final Option decision$1(Set proposals) {
        Tuple2 tuple2 = (Tuple2)proposals.groupBy((Function1 & Serializable)_$10 -> _$10.value()).map((Function1 & Serializable)g -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((IterableOnceOps)g._2()).size()), (Object)Some$.MODULE$.apply(g._1()))).maxByOption((Function1 & Serializable)_$11 -> BoxesRunTime.unboxToInt((Object)_$11._1()), (Ordering)Ordering.Int$.MODULE$).getOrElse(RaftState::$anonfun$11);
        int size = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Option value = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)size), (Object)value);
        int size2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Option value2 = (Option)tuple22._2();
        if (size2 >= this.consensusSize()) {
            return Some$.MODULE$.apply((Object)value2);
        }
        int term = BoxesRunTime.unboxToInt((Object)proposals.headOption().fold(RaftState::$anonfun$12, (Function1 & Serializable)_$12 -> _$12.term()));
        if (term != this.currentTerm()) {
            return RaftState$.rdts$protocols$raft$RaftState$$$DecisionImpossible;
        }
        int undecided = this.participants().size() - proposals.size();
        if (undecided + size2 >= this.consensusSize()) {
            return RaftState$.rdts$protocols$raft$RaftState$$$Undecided;
        }
        return RaftState$.rdts$protocols$raft$RaftState$$$DecisionImpossible;
    }

    public static class Propose<T>
    implements Product,
    Serializable {
        private final int term;
        private final Uid voter;
        private final int pos;
        private final T value;

        public static <T> Propose<T> apply(int n, Uid uid, int n2, T t) {
            return RaftState$Propose$.MODULE$.apply(n, uid, n2, t);
        }

        public static Propose<?> fromProduct(Product product) {
            return RaftState$Propose$.MODULE$.fromProduct(product);
        }

        public static <T> Propose<T> unapply(Propose<T> propose) {
            return RaftState$Propose$.MODULE$.unapply(propose);
        }

        public Propose(int term, Uid voter, int pos, T value) {
            this.term = term;
            this.voter = voter;
            this.pos = pos;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)1355531422);
            n = Statics.mix((int)n, (int)this.term());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.voter()));
            n = Statics.mix((int)n, (int)this.pos());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Propose)) return false;
            Propose propose = (Propose)object;
            if (this.term() != propose.term()) return false;
            if (this.pos() != propose.pos()) return false;
            Uid uid = this.voter();
            Uid uid2 = propose.voter();
            if (uid == null) {
                if (uid2 != null) {
                    return false;
                }
            } else if (!((Object)uid).equals(uid2)) return false;
            if (!BoxesRunTime.equals(this.value(), propose.value())) return false;
            if (!propose.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Propose;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Propose";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "term";
                }
                case 1: {
                    return "voter";
                }
                case 2: {
                    return "pos";
                }
                case 3: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int term() {
            return this.term;
        }

        public Uid voter() {
            return this.voter;
        }

        public int pos() {
            return this.pos;
        }

        public T value() {
            return this.value;
        }

        public <T> Propose<T> copy(int term, Uid voter, int pos, T value) {
            return new Propose<T>(term, voter, pos, value);
        }

        public int copy$default$1() {
            return this.term();
        }

        public <T> Uid copy$default$2() {
            return this.voter();
        }

        public int copy$default$3() {
            return this.pos();
        }

        public <T> T copy$default$4() {
            return this.value();
        }

        public int _1() {
            return this.term();
        }

        public Uid _2() {
            return this.voter();
        }

        public int _3() {
            return this.pos();
        }

        public T _4() {
            return this.value();
        }
    }

    public static class Vote
    implements Product,
    Serializable {
        private final int term;
        private final Uid leader;
        private final Uid voter;

        public static Vote apply(int n, Uid uid, Uid uid2) {
            return RaftState$Vote$.MODULE$.apply(n, uid, uid2);
        }

        public static Vote fromProduct(Product product) {
            return RaftState$Vote$.MODULE$.fromProduct(product);
        }

        public static Vote unapply(Vote vote) {
            return RaftState$Vote$.MODULE$.unapply(vote);
        }

        public Vote(int term, Uid leader, Uid voter) {
            this.term = term;
            this.leader = leader;
            this.voter = voter;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2672394);
            n = Statics.mix((int)n, (int)this.term());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.leader()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.voter()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Vote)) return false;
            Vote vote = (Vote)object;
            if (this.term() != vote.term()) return false;
            Uid uid = this.leader();
            Uid uid2 = vote.leader();
            if (uid == null) {
                if (uid2 != null) {
                    return false;
                }
            } else if (!((Object)uid).equals(uid2)) return false;
            Uid uid3 = this.voter();
            Uid uid4 = vote.voter();
            if (uid3 == null) {
                if (uid4 != null) {
                    return false;
                }
            } else if (!((Object)uid3).equals(uid4)) return false;
            if (!vote.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Vote;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Vote";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "term";
                }
                case 1: {
                    return "leader";
                }
                case 2: {
                    return "voter";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int term() {
            return this.term;
        }

        public Uid leader() {
            return this.leader;
        }

        public Uid voter() {
            return this.voter;
        }

        public Vote copy(int term, Uid leader, Uid voter) {
            return new Vote(term, leader, voter);
        }

        public int copy$default$1() {
            return this.term();
        }

        public Uid copy$default$2() {
            return this.leader();
        }

        public Uid copy$default$3() {
            return this.voter();
        }

        public int _1() {
            return this.term();
        }

        public Uid _2() {
            return this.leader();
        }

        public Uid _3() {
            return this.voter();
        }
    }
}

