/*
 * Decompiled with CFR 0.152.
 */
package rdts.filters;

import java.io.Serializable;
import rdts.base.Bottom;
import rdts.datatypes.LastWriterWins;
import rdts.datatypes.ObserveRemoveMap;
import rdts.filters.Filter$;
import rdts.filters.InvalidPathException;
import rdts.filters.InvalidPathException$;
import rdts.filters.Permission;
import rdts.filters.Permission$;
import rdts.filters.PermissionTree;
import rdts.filters.PermissionTree$;
import rdts.filters.PermissionTree$lattice$;
import rdts.time.CausalTime;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;

public interface Filter<T> {
    public static <V> lwwFilter<V> lwwFilter(Filter<V> filter) {
        return Filter$.MODULE$.lwwFilter(filter);
    }

    public static <K, V> mapFilter<K, V> mapFilter(Filter<V> filter) {
        return Filter$.MODULE$.mapFilter(filter);
    }

    public static <A> Filter<ObserveRemoveMap.Entry<A>> observeRemoveMapEntryFilter(Filter<A> filter, Bottom<A> bottom2) {
        return Filter$.MODULE$.observeRemoveMapEntryFilter(filter, bottom2);
    }

    public static <K, V> Filter<ObserveRemoveMap<K, V>> observeRemoveMapFilter(Filter<V> filter, Bottom<V> bottom2) {
        return Filter$.MODULE$.observeRemoveMapFilter(filter, bottom2);
    }

    public static <T> Filter<T> ofTerminalValue(Bottom<T> bottom2) {
        return Filter$.MODULE$.ofTerminalValue(bottom2);
    }

    public static <T> optionFilter<T> optionFilter(Filter<T> filter) {
        return Filter$.MODULE$.optionFilter(filter);
    }

    public static <T> setFilter<T> setFilter(Filter<T> filter) {
        return Filter$.MODULE$.setFilter(filter);
    }

    public static <V> Filter<LastWriterWins<V>> terminalLwwFilter(Bottom<V> bottom2) {
        return Filter$.MODULE$.terminalLwwFilter(bottom2);
    }

    public static <T> Filter<Set<T>> terminalSetFilter() {
        return Filter$.MODULE$.terminalSetFilter();
    }

    public T filter(T var1, PermissionTree var2);

    public void validatePermissionTree(PermissionTree var1);

    public PermissionTree minimizePermissionTree(PermissionTree var1);

    public static class lwwFilter<V>
    implements Filter<LastWriterWins<V>> {
        private final Filter<V> evidence$1;

        public lwwFilter(Filter<V> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public LastWriterWins<V> filter(LastWriterWins<V> delta, PermissionTree permission) {
            PermissionTree permissionTree = permission;
            PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
            Permission permission2 = permissionTree2._1();
            Map<String, PermissionTree> map = permissionTree2._2();
            Permission permission3 = Permission$.ALLOW;
            Permission permission4 = permission2;
            if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                return delta;
            }
            Permission permission5 = Permission$.PARTIAL;
            Permission permission6 = permission2;
            if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                V v = this.evidence$1.filter(delta.read(), permission);
                CausalTime causalTime = delta.copy$default$1();
                return delta.copy(causalTime, v);
            }
            throw new MatchError((Object)permissionTree);
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            PermissionTree permissionTree2 = permissionTree;
            PermissionTree permissionTree3 = PermissionTree$.MODULE$.unapply(permissionTree2);
            Permission permission = permissionTree3._1();
            Map<String, PermissionTree> map = permissionTree3._2();
            Permission permission2 = Permission$.ALLOW;
            Permission permission3 = permission;
            if (!(permission2 != null ? !permission2.equals(permission3) : permission3 != null)) {
                return;
            }
            Permission permission4 = Permission$.PARTIAL;
            Permission permission5 = permission;
            if (!(permission4 != null ? !permission4.equals(permission5) : permission5 != null)) {
                this.evidence$1.validatePermissionTree(permissionTree);
                return;
            }
            throw new MatchError((Object)permissionTree2);
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            return this.evidence$1.minimizePermissionTree(permissionTree);
        }
    }

    public static class mapFilter<K, V>
    implements Filter<Map<K, V>> {
        private final Filter<V> evidence$1;

        public mapFilter(Filter<V> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public Map<K, V> filter(Map<K, V> delta, PermissionTree permission) {
            PermissionTree permissionTree = permission;
            PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
            Permission permission2 = permissionTree2._1();
            Map<String, PermissionTree> map = permissionTree2._2();
            Permission permission3 = Permission$.ALLOW;
            Permission permission4 = permission2;
            if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                return delta;
            }
            Permission permission5 = Permission$.PARTIAL;
            Permission permission6 = permission2;
            if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                Map<String, PermissionTree> mapOfEntryPermissions = map;
                return (Map)delta.flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    Option option = mapOfEntryPermissions.get((Object)key.toString());
                    if (None$.MODULE$.equals(option)) {
                        return None$.MODULE$;
                    }
                    if (option instanceof Some) {
                        PermissionTree entryPermission = (PermissionTree)((Some)option).value();
                        Object object = Predef$.MODULE$.ArrowAssoc(key);
                        return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, this.evidence$1.filter(value, entryPermission)));
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)permissionTree);
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            permissionTree.children().foreach((Function1 & Serializable)x$1 -> {
                Object object;
                Tuple2 tuple2 = x$1;
                String keyPath = (String)tuple2._1();
                PermissionTree pt = (PermissionTree)tuple2._2();
                try {
                    this.evidence$1.validatePermissionTree(pt);
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidPathException) {
                        List<String> list;
                        InvalidPathException invalidPathException = (InvalidPathException)throwable2;
                        InvalidPathException invalidPathException2 = InvalidPathException$.MODULE$.unapply(invalidPathException);
                        List<String> subPath = list = invalidPathException2._1();
                        InvalidPathException e = invalidPathException;
                        object = InvalidPathException$.MODULE$.apply((List<String>)subPath.$colon$colon((Object)keyPath));
                    }
                    throw throwable;
                }
                return object;
            });
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            PermissionTree minimized = PermissionTree$.MODULE$.apply(permissionTree.permission(), (Map<String, PermissionTree>)((Map)permissionTree.children().map((Function1 & Serializable)x$1 -> {
                String string = (String)x$1._1();
                PermissionTree permissionTree = (PermissionTree)x$1._2();
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.evidence$1.minimizePermissionTree(permissionTree));
            })));
            if (minimized.children().contains((Object)"*")) {
                return PermissionTree$lattice$.MODULE$.normalizeWildcards(minimized);
            }
            return minimized;
        }
    }

    public static class optionFilter<T>
    implements Filter<Option<T>> {
        private final Filter<T> evidence$1;

        public optionFilter(Filter<T> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public Option<T> filter(Option<T> delta, PermissionTree permission) {
            Option<T> option = delta;
            if (None$.MODULE$.equals(option)) {
                return delta;
            }
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                PermissionTree permissionTree = permission;
                PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
                Permission permission2 = permissionTree2._1();
                Map<String, PermissionTree> map = permissionTree2._2();
                Permission permission3 = Permission$.ALLOW;
                Permission permission4 = permission2;
                if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                    return delta;
                }
                Permission permission5 = Permission$.PARTIAL;
                Permission permission6 = permission2;
                if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                    Map<String, PermissionTree> children = map;
                    return Some$.MODULE$.apply(this.evidence$1.filter(value, permission));
                }
                throw new MatchError((Object)permissionTree);
            }
            throw new MatchError(option);
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            if (permissionTree.children().nonEmpty()) {
                this.evidence$1.validatePermissionTree(permissionTree);
                return;
            }
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            return this.evidence$1.minimizePermissionTree(permissionTree);
        }
    }

    public static class setFilter<T>
    implements Filter<Set<T>> {
        private final Filter<T> evidence$1;

        public setFilter(Filter<T> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public Set<T> filter(Set<T> delta, PermissionTree permission) {
            PermissionTree permissionTree = permission;
            PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
            Permission permission2 = permissionTree2._1();
            Map<String, PermissionTree> map = permissionTree2._2();
            Permission permission3 = Permission$.ALLOW;
            Permission permission4 = permission2;
            if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                return delta;
            }
            Permission permission5 = Permission$.PARTIAL;
            Permission permission6 = permission2;
            if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                Map<String, PermissionTree> entryPermissions = map;
                if (entryPermissions.isEmpty()) {
                    return Predef$.MODULE$.Set().empty();
                }
                Map<String, PermissionTree> entryPermissions2 = map;
                Predef$.MODULE$.require(entryPermissions2.size() == 1, Filter$::rdts$filters$Filter$setFilter$$_$filter$$anonfun$2);
                Option option = entryPermissions2.get((Object)"*");
                if (option instanceof Some) {
                    PermissionTree entryPermission = (PermissionTree)((Some)option).value();
                    return (Set)delta.map((Function1 & Serializable)entry -> this.evidence$1.filter(entry, entryPermission));
                }
                if (None$.MODULE$.equals(option)) {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)permissionTree);
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            if (permissionTree.children().isEmpty()) {
                return;
            }
            if (permissionTree.children().size() > 1) {
                throw InvalidPathException$.MODULE$.apply((List<String>)package$.MODULE$.List().empty());
            }
            Option option = permissionTree.children().get((Object)"*");
            if (option instanceof Some) {
                PermissionTree entryPermission = (PermissionTree)((Some)option).value();
                this.evidence$1.validatePermissionTree(entryPermission);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                throw InvalidPathException$.MODULE$.apply((List<String>)((List)new .colon.colon((Object)((String)permissionTree.children().keys().head()), (List)Nil$.MODULE$)));
            }
            throw new MatchError((Object)option);
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            return PermissionTree$.MODULE$.apply(permissionTree.permission(), (Map<String, PermissionTree>)((Map)permissionTree.children().map((Function1 & Serializable)x$1 -> {
                String string = (String)x$1._1();
                PermissionTree permissionTree = (PermissionTree)x$1._2();
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.evidence$1.minimizePermissionTree(permissionTree));
            })));
        }
    }
}

