/*
 * Decompiled with CFR 0.152.
 */
package rdts.filters;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import rdts.base.Bottom;
import rdts.base.Bottom$;
import rdts.filters.Filter;
import rdts.filters.FilterDerivation$;
import rdts.filters.InvalidPathException;
import rdts.filters.InvalidPathException$;
import rdts.filters.Permission;
import rdts.filters.Permission$;
import rdts.filters.PermissionTree;
import rdts.filters.PermissionTree$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;

public final class FilterDerivation {

    public static abstract class AlgebraicFilter<T>
    implements Filter<T> {
        private final Map<String, Object> elementLabels;
        private final Filter<Object>[] elementFilters;

        public AlgebraicFilter(Map<String, Object> elementLabels, Filter<Object>[] elementFilters) {
            this.elementLabels = elementLabels;
            this.elementFilters = elementFilters;
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            permissionTree.children().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                String factorLabel = (String)tuple2._1();
                PermissionTree childPermissionTree = (PermissionTree)tuple2._2();
                Option option = this.elementLabels.get((Object)factorLabel);
                if (option instanceof Some) {
                    int factorIdx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    try {
                        ((Filter)IArray.package.IArray$.MODULE$.apply((Object[])this.elementFilters, factorIdx)).validatePermissionTree(childPermissionTree);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InvalidPathException) {
                            List<String> list;
                            InvalidPathException invalidPathException = InvalidPathException$.MODULE$.unapply((InvalidPathException)throwable2);
                            List<String> path = list = invalidPathException._1();
                            throw InvalidPathException$.MODULE$.apply((List<String>)path.$colon$colon((Object)factorLabel));
                        }
                        throw throwable;
                    }
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    String string = factorLabel;
                    String string2 = "*";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        try {
                            IArray.package.IArray$.MODULE$.foreach(this.elementFilters, (Function1)((JProcedure1 & Serializable)arg_0 -> FilterDerivation$.rdts$filters$FilterDerivation$AlgebraicFilter$$_$validatePermissionTree$$anonfun$1$$anonfun$1(childPermissionTree, arg_0)));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable3 = throwable;
                            if (throwable3 instanceof InvalidPathException) {
                                List<String> list;
                                InvalidPathException invalidPathException = InvalidPathException$.MODULE$.unapply((InvalidPathException)throwable3);
                                List<String> labels = list = invalidPathException._1();
                                throw InvalidPathException$.MODULE$.apply((List<String>)labels.$colon$colon((Object)"*"));
                            }
                            throw throwable;
                        }
                        return;
                    }
                    throw InvalidPathException$.MODULE$.apply((List<String>)((List)new .colon.colon((Object)factorLabel, (List)Nil$.MODULE$)));
                }
                throw new MatchError((Object)option);
            });
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            Permission permission = permissionTree.permission();
            Permission permission2 = Permission$.ALLOW;
            if (!(permission != null ? !permission.equals(permission2) : permission2 != null)) {
                return PermissionTree$.MODULE$.allow();
            }
            Map minimizedChildren = (Map)permissionTree.children().map((Function1 & Serializable)x$1 -> {
                String string = (String)x$1._1();
                PermissionTree permissionTree = (PermissionTree)x$1._2();
                int idx = BoxesRunTime.unboxToInt((Object)this.elementLabels.apply((Object)string));
                Filter filter = (Filter)IArray.package.IArray$.MODULE$.apply((Object[])this.elementFilters, idx);
                PermissionTree minimizedChild = filter.minimizePermissionTree(permissionTree);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)minimizedChild);
            });
            if (minimizedChildren.size() == IArray.package.IArray$.MODULE$.size(this.elementFilters) && minimizedChildren.forall(FilterDerivation$::rdts$filters$FilterDerivation$AlgebraicFilter$$_$minimizePermissionTree$$anonfun$1)) {
                return PermissionTree$.MODULE$.allow();
            }
            return PermissionTree$.MODULE$.apply(Permission$.PARTIAL, (Map<String, PermissionTree>)minimizedChildren);
        }
    }

    public static class ProductTypeFilter<T>
    extends AlgebraicFilter<T> {
        private final Mirror.Product pm;
        private final Bottom<T> productBottom;
        private final Map<String, Object> factorLabels;
        public final Bottom<Object>[] rdts$filters$FilterDerivation$ProductTypeFilter$$factorBottoms;
        private final Filter<Object>[] factorFilters;

        public ProductTypeFilter(Mirror.Product pm, Bottom<T> productBottom, Map<String, Object> factorLabels, Bottom<Object>[] factorBottoms, Filter<Object>[] factorFilters) {
            this.pm = pm;
            this.productBottom = productBottom;
            this.factorLabels = factorLabels;
            this.rdts$filters$FilterDerivation$ProductTypeFilter$$factorBottoms = factorBottoms;
            this.factorFilters = factorFilters;
            super(factorLabels, factorFilters);
        }

        @Override
        public T filter(T delta, PermissionTree permissionTree) {
            PermissionTree permissionTree2 = permissionTree;
            PermissionTree permissionTree3 = PermissionTree$.MODULE$.unapply(permissionTree2);
            Permission permission = permissionTree3._1();
            Map<String, PermissionTree> map = permissionTree3._2();
            Permission permission2 = Permission$.ALLOW;
            Permission permission3 = permission;
            if (!(permission2 != null ? !permission2.equals(permission3) : permission3 != null)) {
                return delta;
            }
            Permission permission4 = Permission$.PARTIAL;
            Permission permission5 = permission;
            if (!(permission4 != null ? !permission4.equals(permission5) : permission5 != null)) {
                Map<String, PermissionTree> children = map;
                if (children.isEmpty()) {
                    return this.productBottom.empty();
                }
                Map<String, PermissionTree> children2 = map;
                Product filteredProduct = this.filterProduct((Product)delta, permissionTree);
                return (T)this.pm.fromProduct(filteredProduct);
            }
            throw new MatchError((Object)permissionTree2);
        }

        private Product filterProduct(Product product, PermissionTree permissionTree) {
            Object object;
            Option option = permissionTree.children().get((Object)"*");
            if (None$.MODULE$.equals(option)) {
                Map filteredFactors = (Map)permissionTree.children().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    String factorName = (String)tuple2._1();
                    PermissionTree permissionSubTree = (PermissionTree)tuple2._2();
                    int factorIndex = BoxesRunTime.unboxToInt((Object)this.factorLabels.apply((Object)factorName));
                    Object factorOfDelta = product.productElement(factorIndex);
                    Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)factorIndex));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, ((Filter)IArray.package.IArray$.MODULE$.apply((Object[])this.factorFilters, factorIndex)).filter(factorOfDelta, permissionSubTree));
                });
                object = new Product(filteredFactors, this){
                    private final Map filteredFactors$1;
                    private final /* synthetic */ ProductTypeFilter $outer;
                    {
                        this.filteredFactors$1 = filteredFactors$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public boolean canEqual(Object that) {
                        return false;
                    }

                    public int productArity() {
                        return IArray.package.IArray$.MODULE$.length((Object[])this.$outer.rdts$filters$FilterDerivation$ProductTypeFilter$$factorBottoms);
                    }

                    public Object productElement(int i) {
                        return this.filteredFactors$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), () -> this.productElement$$anonfun$1(i));
                    }

                    private final Object productElement$$anonfun$1(int i$1) {
                        return ((Bottom)IArray.package.IArray$.MODULE$.apply((Object[])this.$outer.rdts$filters$FilterDerivation$ProductTypeFilter$$factorBottoms, i$1)).empty();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{productElement$$anonfun$1(int )}, serializedLambda);
                    }
                };
            } else if (option instanceof Some) {
                PermissionTree wildcard = (PermissionTree)((Some)option).value();
                Map filteredFactors = (Map)this.factorLabels.map((Function1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    int n = BoxesRunTime.unboxToInt((Object)x$1._2());
                    PermissionTree permissions = (PermissionTree)permissionTree.children().getOrElse((Object)string, () -> FilterDerivation$.rdts$filters$FilterDerivation$ProductTypeFilter$$_$_$$anonfun$4(wildcard));
                    Object factorOfDelta = product.productElement(n);
                    Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, ((Filter)IArray.package.IArray$.MODULE$.apply((Object[])this.factorFilters, n)).filter(factorOfDelta, permissions));
                });
                object = new Product(filteredFactors, this){
                    private final Map filteredFactors$2;
                    private final /* synthetic */ ProductTypeFilter $outer;
                    {
                        this.filteredFactors$2 = filteredFactors$4;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public boolean canEqual(Object that) {
                        return false;
                    }

                    public int productArity() {
                        return IArray.package.IArray$.MODULE$.length((Object[])this.$outer.rdts$filters$FilterDerivation$ProductTypeFilter$$factorBottoms);
                    }

                    public Object productElement(int i) {
                        return this.filteredFactors$2.apply((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                };
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        }
    }

    public static class SumTypeFilter<T>
    extends AlgebraicFilter<T> {
        private final Mirror.Sum sm;
        private final Bottom<T> bottom;
        private final String[] elementNames;
        private final Filter<Object>[] elementFilters;

        public SumTypeFilter(Mirror.Sum sm, Bottom<T> bottom2, String[] elementNames, Bottom<Object>[] elementBottoms, Filter<Object>[] elementFilters) {
            this.sm = sm;
            this.bottom = bottom2;
            this.elementNames = elementNames;
            this.elementFilters = elementFilters;
            Object object = Predef$.MODULE$.refArrayOps((Object[])elementNames);
            super((Map<String, Object>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), elementFilters);
        }

        @Override
        public T filter(T delta, PermissionTree permission) {
            PermissionTree permissionTree = permission;
            PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
            Permission permission2 = permissionTree2._1();
            Map<String, PermissionTree> map = permissionTree2._2();
            Permission permission3 = Permission$.ALLOW;
            Permission permission4 = permission2;
            if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                return delta;
            }
            Permission permission5 = Permission$.PARTIAL;
            Permission permission6 = permission2;
            if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                Map<String, PermissionTree> children = map;
                if (children.isEmpty()) {
                    return this.bottom.empty();
                }
                Map<String, PermissionTree> children2 = map;
                int ordinal = this.sm.ordinal(delta);
                String elementName = this.elementNames[ordinal];
                PermissionTree permissionTree3 = (PermissionTree)children2.getOrElse((Object)elementName, () -> FilterDerivation$.rdts$filters$FilterDerivation$SumTypeFilter$$_$filter$$anonfun$1(children2));
                PermissionTree permissionTree4 = PermissionTree$.MODULE$.unapply(permissionTree3);
                Permission permission7 = permissionTree4._1();
                Map<String, PermissionTree> map2 = permissionTree4._2();
                Permission permission8 = Permission$.ALLOW;
                Permission permission9 = permission7;
                if (!(permission8 != null ? !permission8.equals(permission9) : permission9 != null)) {
                    return delta;
                }
                Permission permission10 = Permission$.PARTIAL;
                Permission permission11 = permission7;
                if (!(permission10 != null ? !permission10.equals(permission11) : permission11 != null)) {
                    Map<String, PermissionTree> children3 = map2;
                    if (children3.isEmpty()) {
                        return this.bottom.empty();
                    }
                    Map<String, PermissionTree> children4 = map2;
                    PermissionTree childPerm = permissionTree3;
                    return ((Filter)IArray.package.IArray$.MODULE$.apply((Object[])this.elementFilters, ordinal)).filter(delta, childPerm);
                }
                throw new MatchError((Object)permissionTree3);
            }
            throw new MatchError((Object)permissionTree);
        }
    }

    public static class TerminalFilter<T>
    implements Filter<T> {
        private final Bottom<T> evidence$1;

        public TerminalFilter(Bottom<T> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public T filter(T delta, PermissionTree permission) {
            PermissionTree permissionTree = permission;
            PermissionTree permissionTree2 = PermissionTree$.MODULE$.unapply(permissionTree);
            Permission permission2 = permissionTree2._1();
            Map<String, PermissionTree> map = permissionTree2._2();
            Permission permission3 = Permission$.ALLOW;
            Permission permission4 = permission2;
            if (!(permission3 != null ? !permission3.equals(permission4) : permission4 != null)) {
                return delta;
            }
            Permission permission5 = Permission$.PARTIAL;
            Permission permission6 = permission2;
            if (!(permission5 != null ? !permission5.equals(permission6) : permission6 != null)) {
                return Bottom$.MODULE$.apply(this.evidence$1).empty();
            }
            throw new MatchError((Object)permissionTree);
        }

        @Override
        public void validatePermissionTree(PermissionTree permissionTree) {
            Predef$.MODULE$.require(permissionTree.children().isEmpty());
        }

        @Override
        public PermissionTree minimizePermissionTree(PermissionTree permissionTree) {
            PermissionTree permissionTree2 = permissionTree;
            PermissionTree permissionTree3 = PermissionTree$.MODULE$.unapply(permissionTree2);
            Permission permission = permissionTree3._1();
            Map<String, PermissionTree> map = permissionTree3._2();
            Permission permission2 = Permission$.ALLOW;
            Permission permission3 = permission;
            if (!(permission2 != null ? !permission2.equals(permission3) : permission3 != null)) {
                return PermissionTree$.MODULE$.allow();
            }
            Permission permission4 = Permission$.PARTIAL;
            Permission permission5 = permission;
            if (!(permission4 != null ? !permission4.equals(permission5) : permission5 != null)) {
                return PermissionTree$.MODULE$.empty();
            }
            throw new MatchError((Object)permissionTree2);
        }
    }
}

